/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.DseqTreeNode;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.RateCvtSetScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class AdjustConvertUtil {
    private static final Predicate<Integer> diffTest = entryRowType -> entryRowType.equals(AdjustEntryRowTypeEnum.CURR_DIFF.getValue()) || entryRowType.equals(AdjustEntryRowTypeEnum.RATE_DIFF.getValue());
    private static final BigDecimal contast = new BigDecimal("0.001");
    private static Predicate<BigDecimal> diffCreateTest = diff -> diff != null && contast.compareTo(diff.abs()) <= 0;

    public static Predicate<Integer> getDiffTest() {
        return diffTest;
    }

    public static Predicate<BigDecimal> getDiffCreateTest() {
        return diffCreateTest;
    }

    public static OperationResult calRateDiff(Long modelId, Long scene, Long tarYear, Long tarPeriod, Set<Long> adjustSet) {
        OperateOption op = OperateOption.create();
        op.setVariableValue("model", Long.toString(modelId));
        op.setVariableValue("year", tarYear.toString());
        op.setVariableValue("period", tarPeriod.toString());
        op.setVariableValue("scene", scene.toString());
        op.setVariableValue("openBatch", Boolean.toString(true));
        return OperationServiceHelper.executeOperate((String)"createratediff", (String)"bcm_rptadjust", (Object[])adjustSet.toArray(), (OperateOption)op);
    }

    public static boolean isBigDecimalEmpty(BigDecimal credit) {
        return credit == null || BigDecimal.ZERO.compareTo(credit) == 0;
    }

    public static List<RateCvtSetScheme> queryRateCvtSetSchemes(long modelid, int type) {
        Map configObjs = BusinessDataServiceHelper.loadFromCache((String)"bcm_ratecvtset", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_ratecvtset").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelid), new QFilter("type", "=", (Object)(type + ""))});
        List<RateCvtSetScheme> rateCvtSetSchemes = null;
        if (!configObjs.isEmpty()) {
            SchemeContext schemeContext = new SchemeContext(modelid);
            List<String> dims = Arrays.asList(DimTypesEnum.MULTIGAAP.getNumber(), DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber(), DimTypesEnum.MYCOMPANY.getNumber());
            schemeContext.removeIf(p -> p.isIssys() && !dims.contains(p.getNumber()));
            Map<Long, Dimension> dimensionMap = schemeContext.getDimensions().stream().collect(Collectors.toMap(p -> p.getId(), p -> p));
            rateCvtSetSchemes = configObjs.values().stream().map(configObj -> new RateCvtSetScheme((DynamicObject)configObj, dimensionMap, type)).collect(Collectors.toList());
        } else {
            rateCvtSetSchemes = new ArrayList<RateCvtSetScheme>();
        }
        return rateCvtSetSchemes;
    }

    public static Set<Long> getMultipleCurrency(long modelId, long orgId, String businessType) {
        DynamicObject[] cvtSchemes = (DynamicObject[])ThreadCache.get((Object)("getMultipleCurrency_" + modelId), () -> {
            List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entrycvtcurrency", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}).toArray(), null, (int)-1);
            return BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_entrycvtcurrency"));
        });
        return AdjustConvertUtil.getMultipleCurrency(modelId, cvtSchemes, orgId, businessType);
    }

    public static Set<Long> getMultipleCurrency(long modelId, DynamicObject[] cvtSchemes, long orgId, String businessType) {
        return (Set)BcmThreadCache.get((Object)"getMultipleCurrency", (Object)modelId, (Object)orgId, (Object)businessType, () -> {
            HashSet currencyIdSet = Sets.newHashSet();
            String businessTypeIndex = BusinessTypeEnum.searchByName((String)businessType).getIndex();
            for (DynamicObject obj : cvtSchemes) {
                boolean hasOrg = false;
                boolean hasBusinessType = false;
                DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
                HashSet entityIdSet = Sets.newHashSet();
                HashSet currencyTemp = Sets.newHashSet();
                for (DynamicObject membObj : entryCol) {
                    if (DimEntityNumEnum.ENTITY.getNumber().equals(membObj.getString("dimensionnum"))) {
                        entityIdSet.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange("bcm_entitymembertree", membObj.getLong("memberid"), membObj.getInt("scope"), Long.toString(modelId), null));
                        continue;
                    }
                    if (!DimEntityNumEnum.CURRENCY.getNumber().equals(membObj.getString("dimensionnum")) || "EC".equals(membObj.getString("dimensionnum")) || "DC".equals(membObj.getString("dimensionnum"))) continue;
                    currencyTemp.add(membObj.getLong("memberid"));
                }
                if (entityIdSet.isEmpty() || entityIdSet.contains(orgId)) {
                    hasOrg = true;
                }
                if (!hasOrg) continue;
                String value = (String)obj.get("businesstype");
                if (StringUtils.isBlank((String)value)) {
                    hasBusinessType = true;
                } else {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    while (st.hasMoreElements()) {
                        if (!st.nextToken().equals(businessTypeIndex)) continue;
                        hasBusinessType = true;
                        break;
                    }
                }
                if (!hasBusinessType) continue;
                currencyIdSet.addAll(currencyTemp);
            }
            return currencyIdSet;
        });
    }

    public static Map<Integer, List<DynamicObject>> createSeqGroup(List<DynamicObject> udfsClone, boolean isUseNewgetUserDefindedList) {
        TreeMap<Integer, List<DynamicObject>> seqGroup = new TreeMap<Integer, List<DynamicObject>>(Comparator.comparingInt(k -> k * (isUseNewgetUserDefindedList ? -1 : 1)));
        for (DynamicObject dy : udfsClone) {
            Integer priority = dy.getInt("executionorder");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)seqGroup.get(priority);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                seqGroup.put(priority, list);
            }
            list.add(dy);
        }
        return seqGroup;
    }

    public static List<DynamicObject> getUserDefindedList(Long modelId, Long yearId, Long scenarioId, Long periodId) {
        if (scenarioId == null || yearId == null || periodId == null) {
            return null;
        }
        SimpleVo sceneSimple = SimpleVo.newOne(null, scenarioId);
        SimpleVo fySimple = SimpleVo.newOne(null, yearId);
        SimpleVo periodSimple = SimpleVo.newOne(null, periodId);
        boolean isUseNewgetUserDefindedList = ConfigServiceHelper.getBoolParam(modelId, "isUseNewgetUserDefindedList");
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        if (isUseNewgetUserDefindedList) {
            qf.add("status", "=", (Object)"1");
        }
        String key = "userdefinedformula|" + modelId + "|" + scenarioId + yearId + periodId;
        List udfs = (List)GlobalCacheServiceHelper.getOrLoadNode((String)key, () -> {
            DynamicObject[] udfstmp = BusinessDataServiceHelper.load((String)"bcm_userdefcvtformula", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdefcvtformula").getAllFields().keySet()), (QFilter[])qf.toArray());
            List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(20);
            Collections.addAll(list, udfstmp);
            list.removeIf(udf -> {
                DynamicObjectCollection effectives = udf.getDynamicObjectCollection("effective");
                return udf.getDynamicObject("scenario") != null && udf.getDynamicObject("scenario").getLong("id") != sceneSimple.id.longValue() || !ConvertDifferenceHandle.isApply(fySimple.id, periodSimple.id, effectives, yearIdsList);
            });
            return list;
        });
        return udfs;
    }

    public static String getRateNumberByEnumValue(String rate) {
        switch (rate) {
            case "1": {
                rate = "ClosingRate";
                break;
            }
            case "2": {
                rate = "AverageRate";
                break;
            }
            case "3": {
                rate = "UserdefinedRate";
                break;
            }
        }
        return rate;
    }

    public static void resetSeq(List<DynamicObject> entries) {
        AdjustConvertUtil.resetSeq(entries, Boolean.TRUE);
    }

    public static void batchResetSeq(List<DynamicObject> entries, boolean isRestGroupNum, AdjustDataSortRuleEnum sortRuleEnum) {
        entries.stream().collect(Collectors.groupingBy(p -> DynUtils.getBaseId((DynamicObject)p, (String)"adjust"))).forEach((adjustId, singleEntries) -> AdjustConvertUtil.resetSeq(singleEntries, isRestGroupNum, sortRuleEnum));
    }

    public static void resetSeq(List<DynamicObject> entries, boolean isRestGroupNum) {
        AdjustConvertUtil.resetSeq(entries, isRestGroupNum, AdjustDataSortRuleEnum.NO_SORT);
    }

    public static void resetSeq(List<DynamicObject> entries, boolean isRestGroupNum, AdjustDataSortRuleEnum sortRuleEnum) {
        AdjustConvertUtil.setAdjustDataShowSeq(entries, sortRuleEnum);
        HashBasedTable groupBy = HashBasedTable.create();
        entries.stream().filter(Objects::nonNull).sorted((p1, p2) -> {
            String g1 = p1.getString("dseq");
            String g2 = p2.getString("dseq");
            boolean isG1Empty = StringUtils.isEmpty((String)g1);
            boolean isG2Empty = StringUtils.isEmpty((String)g2);
            if (isG1Empty && isG2Empty) {
                return Integer.compare(p1.getInt("showseq"), p2.getInt("showseq"));
            }
            if (isG1Empty) {
                return -1;
            }
            if (isG2Empty) {
                return 1;
            }
            boolean isG1Contain_ = g1.contains("-");
            boolean isG2Contain_ = g2.contains("-");
            if (isG1Contain_ && isG2Contain_) {
                return Integer.compare(p1.getInt("showseq"), p2.getInt("showseq"));
            }
            if (isG1Contain_) {
                return -1;
            }
            if (isG2Contain_) {
                return 1;
            }
            return Integer.compare(p1.getInt("showseq"), p2.getInt("showseq"));
        }).forEach(arg_0 -> AdjustConvertUtil.lambda$resetSeq$14((Table)groupBy, arg_0));
        int groupNumSize = Integer.toString(groupBy.rowKeySet().size()).length();
        int groupNumIndex = 1;
        for (String groupNum : groupBy.rowKeySet()) {
            String newGroupNum = String.format("G%0" + groupNumSize + "d", groupNumIndex++);
            DseqTreeNode root = new DseqTreeNode();
            Map rowData = groupBy.row((Object)groupNum);
            rowData.forEach((parent, node) -> {
                if (isRestGroupNum) {
                    node.updateField("groupnum", newGroupNum);
                }
                rowData.getOrDefault(node.getParentDseq(), root).addChild((DseqTreeNode)node);
            });
            root.updateDseq();
        }
        groupBy.clear();
    }

    private static void repairEmptySeqNode(String groupnum, DseqTreeNode dseqTreeNode, Table<String, String, DseqTreeNode> groupBy) {
        if (StringUtils.isNotEmpty((String)dseqTreeNode.getParentDseq())) {
            DseqTreeNode parentNode = (DseqTreeNode)groupBy.get((Object)groupnum, (Object)dseqTreeNode.getParentDseq());
            if (parentNode == null) {
                parentNode = new DseqTreeNode(dseqTreeNode.getDseq());
                groupBy.put((Object)groupnum, (Object)dseqTreeNode.getParentDseq(), (Object)parentNode);
            }
            AdjustConvertUtil.repairEmptySeqNode(groupnum, parentNode, groupBy);
        }
    }

    public static void setAdjustDataShowSeq(Collection<DynamicObject> adjustdatas) {
        AdjustConvertUtil.setAdjustDataShowSeq(adjustdatas, AdjustDataSortRuleEnum.NO_SORT);
    }

    public static void setAdjustDataShowSeq(Collection<DynamicObject> adjustdatas, AdjustDataSortRuleEnum sortRuleEnum) {
        List linkList = EntrySourceEnum.getLinkList();
        if (CollectionUtils.isEmpty(adjustdatas) || adjustdatas.stream().noneMatch(e -> e.getInt("showseq") == 0 && !linkList.contains(e.getInt("entrysource")))) {
            return;
        }
        int showseq = 1;
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject adjustdata : sortRuleEnum.reSort(adjustdatas)) {
            if (linkList.contains(adjustdata.getInt("entrysource"))) continue;
            String currDseq = adjustdata.getString("dseq");
            String groupnum = adjustdata.getString("groupnum");
            if (table.contains((Object)groupnum, (Object)currDseq)) {
                adjustdata.set("showseq", table.get((Object)groupnum, (Object)currDseq));
                continue;
            }
            adjustdata.set("showseq", (Object)showseq);
            table.put((Object)groupnum, (Object)currDseq, (Object)showseq++);
        }
    }

    public static void setAdjustDataShowSeqByMoreAdjust(Collection<DynamicObject> adjustdatas, AdjustDataSortRuleEnum sortRuleEnum) {
        if (!CollectionUtils.isEmpty(adjustdatas)) {
            Map<Long, List<DynamicObject>> adjusts = adjustdatas.stream().collect(Collectors.groupingBy(k -> DynUtils.getBaseId((DynamicObject)k, (String)"adjust")));
            adjusts.forEach((adjustId, adjustdatatemps) -> AdjustConvertUtil.setAdjustDataShowSeq(adjustdatatemps, sortRuleEnum));
        }
    }

    public static String createNewGroupNum(int groupNum, int length) {
        return String.format("G%0" + length + "d", groupNum);
    }

    private static /* synthetic */ void lambda$resetSeq$14(Table groupBy, DynamicObject entry) {
        String currDseq = entry.getString("dseq");
        String groupnum = entry.getString("groupnum");
        DseqTreeNode dseqTreeNode = (DseqTreeNode)groupBy.get((Object)groupnum, (Object)currDseq);
        if (dseqTreeNode == null) {
            dseqTreeNode = new DseqTreeNode(entry);
            groupBy.put((Object)groupnum, (Object)currDseq, (Object)dseqTreeNode);
            AdjustConvertUtil.repairEmptySeqNode(groupnum, dseqTreeNode, (Table<String, String, DseqTreeNode>)groupBy);
        } else if (dseqTreeNode.hasDefaultData().booleanValue() && entry.getBoolean("isdefaultcurrency")) {
            dseqTreeNode.addSameDseqData(entry);
        } else {
            dseqTreeNode.addOtherCurrencyData(entry);
        }
    }
}

