/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.util;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class AdjustDimRedirectHelper {
    private static final Set<String> supportDim = Sets.newHashSet((Object[])new String[]{"bcm_accountmembertree", "bcm_icmembertree", "bcm_userdefinedmembertree", "bcm_mycompanymembertree", "bcm_rulemembertree"});

    public static IDNumberTreeNode getParentRedirectChildMember(long modelId, String entityNumber, DynamicObject dy) {
        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)dy.getLong("id"));
        return AdjustDimRedirectHelper.getRedirectChildMember(modelId, entityNumber, node);
    }

    private static IDNumberTreeNode getRedirectChildMember(long modelId, String entityNumber, IDNumberTreeNode node) {
        IDNumberTreeNode redirectDim;
        if (ConfigServiceHelper.getBoolParam(modelId, "CM043") && supportDim.contains(entityNumber) && !node.isLeaf() && StorageTypeEnum.DYNAMIC == node.getStorageType() && node.getProperty("assostoremem") != null && (redirectDim = MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)((Long)node.getProperty("assostoremem")))) != IDNumberTreeNode.NotFoundTreeNode) {
            return redirectDim;
        }
        return node;
    }

    public static IDNumberTreeNode getParentRedirectChildMember(long modelId, String entityNumber, IDNumberTreeNode memNode) {
        return AdjustDimRedirectHelper.getRedirectChildMember(modelId, entityNumber, memNode);
    }

    public static IDNumberTreeNode getParentRedirectChildMember(long modelId, String entityNumber, long memId) {
        return AdjustDimRedirectHelper.getParentRedirectChildMember(modelId, entityNumber, MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)memId));
    }

    public static SingleF7TypeEnum getSingeF7Type(String dimNum) {
        return AdjustDimRedirectHelper.isNoSupportRedirct(dimNum) ? SingleF7TypeEnum.LEAF : SingleF7TypeEnum.COMMON;
    }

    public static boolean isSupportRedirct(String dimNum) {
        return supportDim.contains(DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNum));
    }

    public static boolean isNoSupportRedirct(String dimNum) {
        return !AdjustDimRedirectHelper.isSupportRedirct(dimNum);
    }
}

