/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckContext;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.convert.AdjustRateDiffCreateService;
import kd.fi.bcm.business.adjust.inputReader.CurrencyMoneyNode;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.model.AdjustDataCheckBM;
import kd.fi.bcm.business.adjust.model.IAdjustDataModel;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustBaseInfoCheckValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckArchiveStatusValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataSysToMDDValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckOlapLockValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvDynamicStockRatioHelper;
import kd.fi.bcm.business.invest.invstructuretable.model.OrgPathNode;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.adjust.AdjustRepairDataServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.AdjustLoadTypeEnum;
import kd.fi.bcm.common.dynamicObjectModel.DataSetDynamicModel;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.dynamicObjectModel.LoadDynamicModel;
import kd.fi.bcm.common.dynamicObjectModel.NewDynamicModel;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.RptAdjustCheckStatusEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CodeRuleUtil;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustOperationHelper {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustOperationHelper.class);

    public static void executeDBBatch(String insertSql, List<Object[]> obParams, int batchSize, boolean isForceRun) {
        if (CollectionUtil.isEmpty(obParams)) {
            return;
        }
        if (isForceRun || obParams.size() >= batchSize) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, obParams);
            obParams.clear();
        }
    }

    public static VersionParam createVersionParam(long modelId, long sceneId, long yearId, long periodId) {
        return (VersionParam)BcmThreadCache.get((Object)sceneId, (Object)yearId, (Object)periodId, (Object)"createVersionParam", () -> new VersionParam(modelId, sceneId, yearId, periodId));
    }

    public static String packRowPfix(Integer row, String log) {
        return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c : %2$s", (String)"AdjustOperationHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), row, log);
    }

    public static boolean isMatchIcItem(VersionParam param, String pNum, String icItemNum) {
        IDNumberTreeNode icNode = BcmThreadCache.findMemberByNum((String)MemberReader.findModelNumberById((Object)param.getModelId()), (String)"InternalCompany", (String)icItemNum);
        if (icNode == IDNumberTreeNode.NotFoundTreeNode) {
            return false;
        }
        String newPNum = "InternalCompany".equals(pNum) ? null : "!" + pNum + "!";
        Set<Long> invalidIC = ICVersionServiceHelper.getInvalidIdByParent(param);
        Predicate<IDNumberTreeNode> test = ic -> (newPNum == null || ic.getLongNumber().contains(newPNum)) && !invalidIC.contains(ic.getId());
        return test.test(icNode) || Optional.ofNullable(icNode.getShareNodes()).orElseGet(Collections::emptyList).stream().anyMatch(test);
    }

    public static Set<String> queryIcMemberNumbersByRange(VersionParam param, String memNum, RangeEnum rangeEnum) {
        return (Set)BcmThreadCache.get((Object)"queryIcMemberNumbersByRange", (Object)param, (Object)memNum, (Object)rangeEnum, () -> {
            String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
            IDNumberTreeNode icNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)"InternalCompany", (String)memNum);
            HashSet result = Sets.newHashSet();
            new MembRangeItem("bcm_icmembertree", icNode.getId(), icNode.getLongNumber(), icNode.getNumber(), rangeEnum.getValue(), false, (Object)param.getModelId()).matchItem4Ic(param, item -> result.add(item.number));
            return result;
        });
    }

    public static Set<Long> queryIcMemberIdsByRange(VersionParam param, long memId, RangeEnum rangeEnum) {
        return (Set)BcmThreadCache.get((Object)"queryIcMemberIdsByRange", (Object)param, (Object)memId, (Object)rangeEnum, () -> {
            String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
            IDNumberTreeNode icNode = BcmThreadCache.findNodeById((String)modelNum, (String)"InternalCompany", (long)memId);
            HashSet result = Sets.newHashSet();
            new MembRangeItem("bcm_icmembertree", icNode.getId(), icNode.getLongNumber(), icNode.getNumber(), rangeEnum.getValue(), false, (Object)param.getModelId()).matchItem4Ic(param, item -> result.add((Long)item.id));
            return result;
        });
    }

    public static void clonePermClassFromSrcAdjust(long modelId, Map<Long, Long> src2tarAdjustMap) {
        HashMap permClassMap = new HashMap(16);
        QFBuilder range = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)"bcm_rptadjust").add("entityid", "in", src2tarAdjustMap.keySet());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_permclass_entity", (String)"entityid,permclass.id", (QFilter[])range.toArray(), null);){
            ds.forEachRemaining(permClass -> permClassMap.put(permClass.getLong("entityid"), permClass.getLong("permclass.id")));
        }
        ArrayList list = new ArrayList(src2tarAdjustMap.size());
        src2tarAdjustMap.forEach((src, tar) -> {
            long permClassId;
            if (LongUtil.isvalidLong((Object)src) && LongUtil.isvalidLong((Object)tar) && LongUtil.isvalidLong((Object)(permClassId = permClassMap.getOrDefault(src, 0L).longValue()))) {
                DynamicObject permClassDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                permClassDy.set("entityname", (Object)"bcm_rptadjust");
                permClassDy.set("entityid", tar);
                permClassDy.set("model", (Object)modelId);
                permClassDy.set("permclass", (Object)permClassId);
                list.add(permClassDy);
            }
        });
        PlatUtil.executeWithTX(txHandle -> {
            DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])new QFBuilder("entityid", "in", src2tarAdjustMap.values()).toArray());
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        });
    }

    public static Map<Long, HashBasedTable<Long, Long, List<String>>> batchCheckOlapDataLockByLinkIds(String specialSourceKey, AbstractContext ctx, Collection<Long> adjustIds, Function<Pair<IDynamicObjectModel, List<Pair<String, String>>>, String> func) {
        HashMap<Long, HashBasedTable<Long, Long, List<String>>> result = new HashMap<Long, HashBasedTable<Long, Long, List<String>>>(16);
        if (!LockScopeServiceHelper.isExistLockDim(ctx.getModelId()) || !StageServiceHelper.isExistLockPlan(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId())) {
            return result;
        }
        HashMap src2LinkRelationMap = new HashMap();
        HashMultimap src2ShareRelationMap = HashMultimap.create();
        QFBuilder sourceFilter = new QFBuilder("model", "in", (Object)ctx.getModelId());
        sourceFilter.and(new QFilter("id", "in", adjustIds).or("linkagelinksource", "in", adjustIds));
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList("entrysource", "linkagelinksource", "id", "shareentry.shareadjust"));
        try (DataSet ds = AdjustQueryServiceHelper.queryAdjustElimDataSet(selectFields, sourceFilter, null, -1);){
            ds.forEachRemaining(adjust -> {
                long adjustId = adjust.getLong("id");
                String entrySource = adjust.getString("entrysource");
                long linkSourceId = adjust.getLong("linkagelinksource");
                if (linkSourceId != 0L && (ElimHeaderSourceEnum.SOURCE.getValue().equals(entrySource) || ElimHeaderSourceEnum.SHARE.getValue().equals(entrySource))) {
                    src2LinkRelationMap.put(adjustId, linkSourceId);
                }
                if (ElimHeaderSourceEnum.SOURCE.getValue().equals(entrySource) || ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(entrySource)) {
                    src2ShareRelationMap.put((Object)adjustId, (Object)adjust.getLong("shareentry.shareadjust"));
                }
            });
        }
        HashSet<Long> adjustIdSet = new HashSet<Long>(16);
        adjustIdSet.addAll(adjustIds);
        adjustIdSet.addAll(src2LinkRelationMap.keySet());
        adjustIdSet.addAll(src2LinkRelationMap.values());
        adjustIdSet.addAll(src2ShareRelationMap.keySet());
        adjustIdSet.addAll(src2ShareRelationMap.values());
        adjustIdSet.remove(0L);
        adjustIdSet.remove(null);
        HashBasedTable<Long, Long, List<String>> dataLock = AdjustOperationHelper.batchCheckOlapDataLockByModel(specialSourceKey, ctx, AdjustOperationHelper.queryElimEntriesForLockCheck(ctx.getModelId(), adjustIdSet), func);
        for (Long adjustId : adjustIds) {
            dataLock.row((Object)adjustId).forEach((c, v) -> {
                List cfr_ignored_0 = (List)result.computeIfAbsent(adjustId, a -> HashBasedTable.create()).put((Object)adjustId, c, v);
            });
            if (src2LinkRelationMap.containsKey(adjustId)) {
                long linkId = (Long)src2LinkRelationMap.get(adjustId);
                dataLock.row((Object)linkId).forEach((c, v) -> {
                    List cfr_ignored_0 = (List)result.computeIfAbsent(adjustId, a -> HashBasedTable.create()).put((Object)linkId, c, v);
                });
            }
            src2ShareRelationMap.get((Object)adjustId).forEach(shareId -> dataLock.row(shareId).forEach((c, v) -> {
                List cfr_ignored_0 = (List)result.computeIfAbsent(adjustId, a -> HashBasedTable.create()).put(shareId, c, v);
            }));
        }
        return result;
    }

    public static HashBasedTable<Long, Long, List<String>> batchCheckOlapDataLockByIds(String specialSourceKey, AbstractContext ctx, Collection<Long> adjustIds, Function<Pair<IDynamicObjectModel, List<Pair<String, String>>>, String> func) {
        if (!LockScopeServiceHelper.isExistLockDim(ctx.getModelId()) || !StageServiceHelper.isExistLockPlan(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId())) {
            return HashBasedTable.create();
        }
        return AdjustOperationHelper.batchCheckOlapDataLockByModel(specialSourceKey, ctx, AdjustOperationHelper.queryElimEntriesForLockCheck(ctx.getModelId(), adjustIds), func);
    }

    private static List<IDynamicObjectModel> queryElimEntriesForLockCheck(long modelId, Collection<Long> adjustIdSet) {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("groupnum");
        fields.add("dseq");
        fields.add("merge");
        fields.add("id");
        fields.add("model");
        fields.add("adjust");
        fields.add("adjust.id");
        fields.add("adjust.number");
        new SchemeContext(modelId).getDimensions().forEach(dim -> {
            fields.add(dim.getFieldmapped());
            fields.add(dim.getFieldmapped() + ".number");
        });
        QFilter[] filters = new QFilter[]{new QFilter("adjust", "in", adjustIdSet), new QFilter("isdefaultcurrency", "in", (Object)"1")};
        return AdjustQueryServiceHelper.loadDataFromDB(AdjustLoadTypeEnum.DataSetRow, "bcm_rptadjustdata", String.join((CharSequence)",", fields), filters, null);
    }

    public static HashBasedTable<Long, Long, List<String>> batchCheckOlapDataLockByModel(String specialSourceKey, AbstractContext ctx, Collection<IDynamicObjectModel> entityDataList, Function<Pair<IDynamicObjectModel, List<Pair<String, String>>>, String> func) {
        HashBasedTable resultMap = HashBasedTable.create();
        if (!LockScopeServiceHelper.isExistLockDim(ctx.getModelId()) || !StageServiceHelper.isExistLockPlan(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId())) {
            return resultMap;
        }
        if (!CollectionUtil.isEmpty(entityDataList)) {
            IDynamicObjectModel tempEntry = entityDataList.iterator().next();
            long modelId = tempEntry.getBaseDataId("model");
            if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
                return resultMap;
            }
            long scenarioId = tempEntry.getBaseDataId("scenario");
            long yearId = tempEntry.getBaseDataId("year");
            long periodId = tempEntry.getBaseDataId("period");
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            String sceneNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Scenario", (long)scenarioId).getNumber();
            String yearNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Year", (long)yearId).getNumber();
            String periodNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Period", (long)periodId).getNumber();
            Set<String> currencySet = entityDataList.stream().map(p -> BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)p.getBaseDataId("currency")).getNumber()).collect(Collectors.toSet());
            Dimension lockDim = ((SchemeContext)ThreadCache.get((Object)"SchemeContext", () -> SchemeContext.getInstance(modelId))).getDimensionByNumber(LockScopeServiceHelper.getLockDimNumber(modelId));
            if (lockDim != null) {
                AdjustCheckContext _ctx = new AdjustCheckContext(modelId, scenarioId, yearId, periodId);
                LockScope lockScope = LockScopeServiceHelper.queryLockScope(modelId, sceneNum, Collections.singleton(yearNum), Collections.singleton(periodNum), currencySet);
                for (IDynamicObjectModel entry : entityDataList) {
                    String processNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Process", (long)entry.getBaseDataId("process")).getNumber();
                    String currencyNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)entry.getBaseDataId("currency")).getNumber();
                    String entityNum = OrgRelaProcessMembPool.isRelaProcess((String)processNum) ? BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)entry.getBaseDataId("merge")).getNumber() : BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)entry.getBaseDataId("entity")).getNumber();
                    String lockDimMemNum = BcmThreadCache.findNodeById((String)modelNum, (String)lockDim.getNumber(), (long)entry.getBaseDataId(lockDim.getFieldmapped())).getNumber();
                    Pair<Boolean, List<Pair<String, String>>> lockPair = lockScope.isLock(yearNum, periodNum, currencyNum, entityNum, lockDimMemNum);
                    if (!((Boolean)lockPair.p1).booleanValue()) continue;
                    List lockList = ((List)lockPair.p2).stream().map(p -> String.format("%s(%s)", p.p1, p.p2)).collect(Collectors.toList());
                    resultMap.put((Object)entry.getBaseDataId("adjust"), (Object)entry.getBaseDataId("id"), lockList);
                    String lockInfo = String.format(ResManager.loadKDString((String)"%1$s|%2$s|%3$s|(\u9501\u5b9a\u9636\u6bb5-%4$s)", (String)"AdjustOperationHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getString("groupnum"), entry.getString("dseq"), Arrays.toString(new String[]{entityNum, currencyNum, lockDimMemNum}), lockList);
                    _ctx.getTraceLog().addTag(func == null ? lockInfo : func.apply((Pair<IDynamicObjectModel, List<Pair<String, String>>>)Pair.onePair((Object)entry, (Object)lockPair.p2)) + lockInfo, () -> "");
                }
                _ctx.getTraceLog().setDimKeys(Arrays.asList("Entity", "Currency", lockDim.getNumber()));
                _ctx.getTraceLog().setOperTypeEnum(AdjustOperTypeEnum.OLAPDATALOCKCHECK_OPERATION);
                _ctx.getTraceLog().setSpecialSourceKey(specialSourceKey);
                _ctx.getTraceLog().publish();
            }
        }
        return resultMap;
    }

    public static HashBasedTable<Long, Long, List<String>> batchCheckOlapDataLock(String specialSourceKey, AbstractContext ctx, Collection<DynamicObject> entityDataList, Function<Pair<DynamicObject, List<Pair<String, String>>>, String> func) {
        HashBasedTable resultMap = HashBasedTable.create();
        if (!LockScopeServiceHelper.isExistLockDim(ctx.getModelId()) || !StageServiceHelper.isExistLockPlan(ctx.getModelId(), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId())) {
            return resultMap;
        }
        if (!CollectionUtil.isEmpty(entityDataList)) {
            DynamicObject tempEntry = entityDataList.iterator().next();
            long modelId = DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)tempEntry, (String)"model");
            if (!LockScopeServiceHelper.isExistLockDim(modelId)) {
                return resultMap;
            }
            long scenarioId = ctx.getScenarioId();
            long yearId = ctx.getFyId();
            long periodId = ctx.getPeriodId();
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            String sceneNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Scenario", (long)scenarioId).getNumber();
            String yearNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Year", (long)yearId).getNumber();
            String periodNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Period", (long)periodId).getNumber();
            Set<String> currencySet = entityDataList.stream().map(p -> BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)p, (String)"currency")).getNumber()).collect(Collectors.toSet());
            Dimension lockDim = ((SchemeContext)ThreadCache.get((Object)"SchemeContext", () -> SchemeContext.getInstance(modelId))).getDimensionByNumber(LockScopeServiceHelper.getLockDimNumber(modelId));
            if (lockDim != null) {
                AdjustCheckContext _ctx = new AdjustCheckContext(modelId, scenarioId, yearId, periodId);
                LockScope lockScope = LockScopeServiceHelper.queryLockScope(modelId, sceneNum, Collections.singleton(yearNum), Collections.singleton(periodNum), currencySet);
                for (DynamicObject entry : entityDataList) {
                    String processNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Process", (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"process")).getNumber();
                    String currencyNum = BcmThreadCache.findNodeById((String)modelNum, (String)"Currency", (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"currency")).getNumber();
                    String entityNum = OrgRelaProcessMembPool.isRelaProcess((String)processNum) ? BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"merge")).getNumber() : BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"entity")).getNumber();
                    String lockDimMemNum = BcmThreadCache.findNodeById((String)modelNum, (String)lockDim.getNumber(), (long)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)lockDim.getFieldmapped())).getNumber();
                    Pair<Boolean, List<Pair<String, String>>> lockPair = lockScope.isLock(yearNum, periodNum, currencyNum, entityNum, lockDimMemNum);
                    if (!((Boolean)lockPair.p1).booleanValue()) continue;
                    List lockList = ((List)lockPair.p2).stream().map(p -> String.format("%s(%s)", p.p1, p.p2)).collect(Collectors.toList());
                    String lockInfo = String.format(ResManager.loadKDString((String)"%1$s|%2$s|%3$s|(\u9501\u5b9a\u9636\u6bb5-%4$s)", (String)"AdjustOperationHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getString("groupnum"), entry.getString("dseq"), Arrays.toString(new String[]{entityNum, currencyNum, lockDimMemNum}), lockList);
                    resultMap.put((Object)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"adjust"), (Object)DynUtils.getBaseId((String)"batchCheckOlapDataLock", (DynamicObject)entry, (String)"id"), lockList);
                    _ctx.getTraceLog().addTag(func == null ? lockInfo : func.apply((Pair<DynamicObject, List<Pair<String, String>>>)Pair.onePair((Object)entry, (Object)lockPair.p2)) + lockInfo, () -> "");
                }
                _ctx.getTraceLog().setDimKeys(Arrays.asList("Currency", "Entity", lockDim.getNumber()));
                _ctx.getTraceLog().setOperTypeEnum(AdjustOperTypeEnum.OLAPDATALOCKCHECK_OPERATION);
                _ctx.getTraceLog().setSpecialSourceKey(specialSourceKey);
                _ctx.getTraceLog().publish();
            }
        }
        return resultMap;
    }

    public static boolean isMultipleCurrencyElim(IDynamicObjectModel elim) {
        return elim.getBoolean("multiplecurrency") || elim.get("cvtbeforecurrency") instanceof DynamicObject;
    }

    public static void resetElim(IDynamicObjectModel newElim, boolean isNoKeepSpreadJson) {
        newElim.getDynamicObjectCollection("shareentry").clear();
        newElim.set("allshareorg", null);
        newElim.set("entrysource", (Object)ElimHeaderSourceEnum.SOURCE.getValue());
        newElim.set("extend", null);
        newElim.set("extendfrom", null);
        newElim.set("submitter", null);
        newElim.set("submittime", null);
        newElim.set("cancelsubmitter", null);
        newElim.set("cancelsubmittime", null);
        newElim.set("ratifier", null);
        newElim.set("ratifytime", null);
        newElim.set("cancelratifier", null);
        newElim.set("cancelratifytime", null);
        newElim.set("reviewer", null);
        newElim.set("reviewtime", null);
        newElim.set("callbacker", null);
        newElim.set("callbacktime", null);
        newElim.set("modifier", null);
        newElim.set("modifytime", null);
        newElim.set("creator", null);
        newElim.set("createtime", null);
        newElim.set("checkstatus", (Object)RptAdjustCheckStatusEnum.NOTCHECKED.getStatus());
        newElim.set("iscontinuous", (Object)1);
        newElim.set("linkagelinksource", (Object)0L);
        newElim.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        newElim.set("checkrecord", null);
        if (isNoKeepSpreadJson) {
            newElim.set("spreadjson", null);
            newElim.set("data", null);
        }
    }

    public static void resetElimCommonEntries(IDynamicObjectModel newElim) {
        if (newElim == null) {
            return;
        }
        for (DynamicObject commembentry : newElim.getDynamicObjectCollection("commembentry")) {
            String dimNum = commembentry.getString("comdimension.number");
            commembentry.set("id", null);
            switch (dimNum) {
                case "Scenario": {
                    commembentry.set("commembid", (Object)newElim.getBaseDataId("scenario"));
                    break;
                }
                case "Year": {
                    commembentry.set("commembid", (Object)newElim.getBaseDataId("year"));
                    break;
                }
                case "Period": {
                    commembentry.set("commembid", (Object)newElim.getBaseDataId("period"));
                    break;
                }
                case "AuditTrail": {
                    commembentry.set("commembid", (Object)newElim.getBaseDataId("audittrail"));
                }
            }
        }
        newElim.getDynamicObjectCollection("spreadmembentry").forEach(spreadmemb -> spreadmemb.set("id", null));
    }

    public static IDynamicObjectModel cloneNewEntry(IDynamicObjectModel tempEntry) {
        IDynamicObjectModel entryClone;
        if (tempEntry instanceof LoadDynamicModel) {
            entryClone = tempEntry.copy(true);
        } else if (tempEntry instanceof DataSetDynamicModel) {
            entryClone = new NewDynamicModel("cloneNewEntry", "bcm_rptadjustdata");
            for (String field : ((DataSetDynamicModel)tempEntry).getRowMeta().getFieldNames()) {
                entryClone.set(field, tempEntry.get(field));
            }
        } else {
            return null;
        }
        entryClone.set("id", null);
        return entryClone;
    }

    public static String dealEntryEffectEntity(IDynamicObjectModel entryClone) {
        long modelId = entryClone.getBaseDataId("model");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)modelNum, (Long)entryClone.getBaseDataId("process"));
        String msg = null;
        if (OrgRelaProcessMembPool.isRelaProcess((String)processNode.getNumber())) {
            IDNumberTreeNode oldOrgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)entryClone.getBaseDataId("entity"));
            Set<Long> effOrgList = InvestServiceHelper.queryEffectiveOrgList(modelId, entryClone.getBaseDataId("scenario"), entryClone.getBaseDataId("year"), entryClone.getBaseDataId("period"), entryClone.getBaseDataId("merge"), oldOrgNode.getNumber());
            if (CollectionUtil.isEmpty(effOrgList)) {
                entryClone.set("entity", null);
                msg = String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7%1$s\u5e8f\u53f7%2$s\u7684\u660e\u7ec6\u5206\u5f55\u7684\u7ec4\u7ec7%3$s|%4$s\u5728\u5f53\u524d\u7ec4\u7ec7\u67b6\u6784\u627e\u4e0d\u5230\u94fe\u8def\u751f\u6548\u4e14\u53c2\u4e0e\u5408\u5e76\u7684\u7ec4\u7ec7;", (String)"AdjustOperationHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), entryClone.getString("groupnum"), entryClone.getString("dseq"), oldOrgNode.getNumber(), oldOrgNode.getName());
            } else if (!effOrgList.contains(oldOrgNode.getId())) {
                DynamicObject orgDy = AdjustQueryServiceHelper.loadSingle(modelNum, "bcm_entitymembertree", effOrgList.iterator().next());
                entryClone.set("entity", (Object)orgDy);
                msg = String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7%1$s\u5e8f\u53f7%2$s\u7684\u660e\u7ec6\u5206\u5f55\u7684\u7ec4\u7ec7%3$s|%4$s\u8fdb\u884c\u4e86\u66ff\u6362,\uff08%5$s->%6$s\uff09;", (String)"AdjustOperationHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), entryClone.getString("groupnum"), entryClone.getString("dseq"), oldOrgNode.getNumber(), oldOrgNode.getName(), oldOrgNode.getLongNumber(), orgDy.getString("longnumber"));
            }
            AdjustOperationHelper.fillAdjustDataOfOlapOrg(modelNum, entryClone, (boolean)Boolean.TRUE);
        }
        return msg;
    }

    public static void changeCarryYearAdjustElim(VersionParam versionParam, IDynamicObjectModel entryClone, List<LossCarryScheme> lossCarrySchemes) {
        String modelNum = MemberReader.findModelNumberById((Object)versionParam.getModelId());
        HashMap<String, String> dimComb = new HashMap<String, String>(16);
        if (!CollectionUtil.isEmpty(lossCarrySchemes)) {
            long memId = 0L;
            for (Dimension dim : LossCarryScheme.getLossCarryDimCtx(versionParam.getModelId()).getDimensions()) {
                String processNum;
                memId = "Entity".equals(dim.getNumber()) ? (OrgRelaProcessMembPool.isRelaProcess((String)(processNum = BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)entryClone.getBaseDataId("process")).getNumber())) ? entryClone.getBaseDataId("merge") : entryClone.getBaseDataId("entity")) : ("Scenario".equals(dim.getNumber()) ? versionParam.getSceneId() : ("Year".equals(dim.getNumber()) ? versionParam.getYearId() : ("Period".equals(dim.getNumber()) ? versionParam.getPeriodId() : entryClone.getBaseDataId(dim.getFieldmapped()))));
                dimComb.put(dim.getFieldmapped(), BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)memId).getNumber());
            }
            AdjustmentServiceHelper.changeCarryYearAdjustElim(versionParam, dimComb, lossCarrySchemes, (DynamicObject)entryClone.getData());
        }
    }

    public static void dealEntryPrecision(long modelId, String sceneNum, IDynamicObjectModel entryClone) {
        String currencyNum = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)"Currency", (long)entryClone.getBaseDataId("currency")).getNumber();
        String accountNum = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)"Account", (long)entryClone.getBaseDataId("account")).getNumber();
        int precision = CurrencyScaleHandler.getNewCurrencyScale(modelId, sceneNum, currencyNum, accountNum);
        entryClone.set("debit", (Object)entryClone.getBigDecimal("debit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("credit", (Object)entryClone.getBigDecimal("credit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("summoney", (Object)entryClone.getBigDecimal("summoney").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforecredit", (Object)entryClone.getBigDecimal("cvtbeforecredit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforedebit", (Object)entryClone.getBigDecimal("cvtbeforedebit").setScale(precision, RoundingMode.HALF_UP));
        entryClone.set("cvtbeforesummoney", (Object)entryClone.getBigDecimal("cvtbeforesummoney").setScale(precision, RoundingMode.HALF_UP));
    }

    public static void batchSetNumbers(String entityId, List<DynamicObject> entityDataList) {
        List<String> batchNumberResult = AdjustOperationHelper.batchGetNumbers(entityId, entityDataList);
        for (int i = 0; i < entityDataList.size(); ++i) {
            entityDataList.get(i).set("number", (Object)batchNumberResult.get(i));
        }
    }

    public static List<String> batchGetNumbers(String entityId, List<DynamicObject> entityDataList) {
        List batchNumberResult;
        if (CollectionUtil.isEmpty(entityDataList)) {
            return Collections.emptyList();
        }
        ICodeRuleService codeRuleService = CodeRuleUtil.getCodeRuleService();
        if (codeRuleService.isExist(entityId, entityDataList.get(0), null)) {
            batchNumberResult = CodeRuleUtil.getCodeRuleService().getNumbers(entityId, entityDataList);
            if (batchNumberResult.size() < entityDataList.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u89c4\u5219\u6ca1\u6709\u8db3\u591f\u7684\u7f16\u7801\u53ef\u4ee5\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"AdjustOperationHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u89c4\u5219\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"AdjustOperationHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return batchNumberResult;
    }

    public static IDNumberTreeNode resolveCommonParentNode(AbstractContext _ctx, List<DynamicObject> entrys, IDNumberTreeNode mergeOrgNode) {
        HashSet<String> detailOrgSet = new HashSet<String>(entrys.size());
        HashSet<IDNumberTreeNode> temp = new HashSet<IDNumberTreeNode>();
        for (DynamicObject entry : entrys) {
            detailOrgSet.add(entry.getString("entity.number"));
            IDNumberTreeNode orgNode = InvestServiceHelper.queryEffectiveOrgNode(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId(), mergeOrgNode.getId(), entry.getString("entity.number"));
            if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9%1$s\u4e0b\u627e\u4e0d\u5230\u6709\u6548\u7684\u7ec4\u7ec7\u8282\u70b9%2$s\u3002", (String)"AdjustOperationHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), mergeOrgNode.getLongNumber(), entry.getString("entity.number")));
            }
            if (temp.isEmpty()) {
                OrgPathNode.initParentOrgsStatic(orgNode, temp);
                continue;
            }
            temp.retainAll(OrgPathNode.initParentOrgsStatic(orgNode, Sets.newHashSet()));
        }
        IDNumberTreeNode highLevelNode = InvDynamicStockRatioHelper.findHighLevel(new ArrayList<IDNumberTreeNode>(temp)).iterator().next();
        if (detailOrgSet.contains(highLevelNode.getNumber())) {
            highLevelNode = highLevelNode.getParent();
        }
        return highLevelNode;
    }

    public static Pair<Boolean, String> validateSceneVersion(AdjustOperationContext ctx, IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
        long sceneId = adjust.getBaseDataId("scenario");
        long yearId = adjust.getBaseDataId("year");
        long periodId = adjust.getBaseDataId("period");
        if (MergeControlHelper.isQuoteScene(ctx.getModelId(), sceneId)) {
            if (OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"))) {
                Long mergeId = adjust.getBaseDataId("entity");
                if (!MergeControlHelper.isVersionedOrg(ctx.getModelId(), sceneId, yearId, periodId, mergeId)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)AdjustSceneVersionValidator.packErrorMsg(MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)mergeId).getNumber(), MemberReader.findFyMemberById((Long)ctx.getModelId(), (Long)yearId).getNumber(), MemberReader.findPeriodMemberById((Long)ctx.getModelId(), (Long)periodId).getNumber()));
                }
            } else {
                Set closedVersionedOrgSet = adjustDataList.stream().map(adjustData -> adjustData.getBaseDataId("entity")).filter(entityId -> !MergeControlHelper.isVersionedOrg(ctx.getModelId(), sceneId, yearId, periodId, entityId)).map(entityId -> MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)entityId).getNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(closedVersionedOrgSet)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)AdjustSceneVersionValidator.packErrorMsg(closedVersionedOrgSet, MemberReader.findFyMemberById((Long)ctx.getModelId(), (Long)yearId).getNumber(), MemberReader.findPeriodMemberById((Long)ctx.getModelId(), (Long)periodId).getNumber()));
                }
            }
        }
        return Pair.onePair((Object)Boolean.TRUE, null);
    }

    public static void resetMoneyNode(long modelId, String accNum, CurrencyMoneyNode moneyNode, BigDecimal credit, BigDecimal debit, BigDecimal summoney) {
        moneyNode.setAccNum(accNum);
        if (AdjustOperationHelper.isZero(debit)) {
            moneyNode.setDebit(null);
        } else {
            moneyNode.setDebit(debit);
            moneyNode.setCredit(null);
        }
        if (AdjustOperationHelper.isZero(credit)) {
            moneyNode.setCredit(null);
        } else {
            moneyNode.setDebit(null);
            moneyNode.setCredit(credit);
        }
        if (AdjustOperationHelper.isZero(summoney)) {
            moneyNode.setSummoney(AdjustOperationUtils.handleSummoney((BigDecimal)moneyNode.getDebit(), (BigDecimal)moneyNode.getCredit()));
        } else {
            moneyNode.setSummoney(summoney);
        }
    }

    public static boolean isZero(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static DynamicObject copyDynamicObject(DynamicObject entry, boolean isOrmCopy) {
        return AdjustOperationUtils.copyDynamicObject((DynamicObject)entry, (boolean)isOrmCopy);
    }

    @Deprecated
    public static boolean checkAdjustDataBalance(long model, String balanceType, Table<String, String, List<IAdjustDataModel>> adjustDatas, long cvtbeforecurrency, boolean isMultipleCurrency) {
        if (adjustDatas == null || "2".equals(balanceType)) {
            return true;
        }
        Map<String, List<IAdjustDataModel>> balanceGroup = AdjustOperationHelper.balanceGroupBy(balanceType, adjustDatas);
        return AdjustOperationHelper.checkAllGroupBalance(model, balanceGroup, cvtbeforecurrency, isMultipleCurrency);
    }

    private static Map<String, List<IAdjustDataModel>> balanceGroupBy(String balanceType, Table<String, String, List<IAdjustDataModel>> adjustDatas) {
        HashMap<String, List<IAdjustDataModel>> group = new HashMap<String, List<IAdjustDataModel>>(16);
        for (Table.Cell cell : adjustDatas.cellSet()) {
            String key;
            AdjustDataCheckBM defaultDataCheckBM = (AdjustDataCheckBM)((List)cell.getValue()).stream().filter(p -> p.isdefaultcurrency()).findFirst().get();
            if ("1".equals(balanceType)) {
                key = defaultDataCheckBM.getGroumnum();
                if (kd.bos.util.StringUtils.isEmpty((String)key)) {
                    key = "noGroupNum";
                }
            } else {
                key = defaultDataCheckBM.getEntity() == 0L ? "noOrgNum" : Long.toString(defaultDataCheckBM.getEntity());
            }
            AdjustOperationHelper.setGroupMap(key, defaultDataCheckBM, group);
        }
        return group;
    }

    private static void setGroupMap(String groumnum, AdjustDataCheckBM defaultDataCheckBM, Map<String, List<IAdjustDataModel>> group) {
        group.computeIfAbsent(groumnum, a -> new ArrayList(10)).add(defaultDataCheckBM);
    }

    private static boolean checkAllGroupBalance(long model, Map<String, List<IAdjustDataModel>> balanceGroup, long cvtbeforecurrency, boolean isMultipleCurrency) {
        boolean isSingleCurrency = !isMultipleCurrency && cvtbeforecurrency == 0L;
        BigDecimal configBalance = ConfigServiceHelper.getAdjustBalance(model);
        for (List<IAdjustDataModel> groupnum : balanceGroup.values()) {
            BigDecimal debtor = BigDecimal.ZERO;
            BigDecimal lender = BigDecimal.ZERO;
            for (IAdjustDataModel iAdjustDataModel : groupnum) {
                BigDecimal credit;
                if (!AdjustOperationHelper.isCalcCurrentRow(iAdjustDataModel, isMultipleCurrency)) continue;
                BigDecimal debit = isSingleCurrency ? iAdjustDataModel.getDebit() : iAdjustDataModel.getCvtbeforedebit();
                BigDecimal bigDecimal = credit = isSingleCurrency ? iAdjustDataModel.getCredit() : iAdjustDataModel.getCvtbeforecredit();
                if (!AdjustOperationHelper.isBigDecimalEmpty(debit)) {
                    debtor = debtor.add(debit);
                    continue;
                }
                if (AdjustOperationHelper.isBigDecimalEmpty(credit)) continue;
                lender = lender.add(credit);
            }
            if (debtor.subtract(lender).abs().compareTo(configBalance) <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isBigDecimalEmpty(BigDecimal credit) {
        return credit == null || BigDecimal.ZERO.compareTo(credit) == 0;
    }

    public static boolean isCalcCurrentRow(IAdjustDataModel iAdjustDataModel, boolean isMultipleCurrency) {
        return !isMultipleCurrency || StringUtils.isBlank((CharSequence)iAdjustDataModel.getEntryrowtype());
    }

    public static void fillAdjustDataOfOlapOrg(String modelnum, String process, DynamicObject adjustData) {
        boolean isMerge = OrgRelaProcessMembPool.isRelaProcess((String)process);
        AdjustOperationHelper.fillAdjustDataOfOlapOrg(modelnum, adjustData, isMerge);
    }

    public static void fillAdjustDataOfOlapOrg(String modelnum, IDynamicObjectModel adjustData, boolean isMerge) {
        Long entityId = adjustData.getBaseDataId("entity");
        String olapOrg = null;
        if (entityId != 0L) {
            IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelnum, (String)"Entity", (long)entityId);
            IDNumberTreeNode mergeNode = BcmThreadCache.findNodeById((String)modelnum, (String)"Entity", (long)adjustData.getBaseDataId("merge"));
            String string = olapOrg = isMerge ? AdjustCheckServiceHelper.getParentDirectChild(mergeNode.getNumber(), orgNode.getLongNumber()) : orgNode.getNumber();
            if (StringUtils.isEmpty((CharSequence)olapOrg)) {
                if (WatchLoggerUtil.isDebug()) {
                    LOG.error("fillAdjustDataOfOlapOrg.entityId : " + entityId);
                    LOG.error("fillAdjustDataOfOlapOrg.entityNode : " + orgNode.getProperty("cslscheme.number") + orgNode.getLongNumber());
                    LOG.error("fillAdjustDataOfOlapOrg.mergeNode : " + mergeNode.getProperty("cslscheme.number") + mergeNode.getLongNumber());
                    LOG.error(ThrowableHelper.getThreadTrace());
                }
            } else {
                adjustData.set("olaporg", (Object)olapOrg);
            }
        }
    }

    public static void fillAdjustDataOfOlapOrg(String modelnum, DynamicObject adjustData, boolean isMerge) {
        Long entityId = DynUtils.getBaseId((DynamicObject)adjustData, (String)"entity");
        String olapOrg = null;
        if (entityId != 0L) {
            IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelnum, (String)"Entity", (long)entityId);
            IDNumberTreeNode mergeNode = BcmThreadCache.findNodeById((String)modelnum, (String)"Entity", (long)DynUtils.getBaseId((DynamicObject)adjustData, (String)"merge"));
            String string = olapOrg = isMerge ? AdjustCheckServiceHelper.getParentDirectChild(mergeNode.getNumber(), orgNode.getLongNumber()) : orgNode.getNumber();
            if (StringUtils.isEmpty((CharSequence)olapOrg)) {
                if (WatchLoggerUtil.isDebug()) {
                    LOG.error("fillAdjustDataOfOlapOrg.entityId : " + entityId);
                    LOG.error("fillAdjustDataOfOlapOrg.entityNode : " + orgNode.getProperty("cslscheme.number") + orgNode.getLongNumber());
                    LOG.error("fillAdjustDataOfOlapOrg.mergeNode : " + mergeNode.getProperty("cslscheme.number") + mergeNode.getLongNumber());
                    LOG.error(ThrowableHelper.getThreadTrace());
                }
            } else {
                adjustData.set("olaporg", (Object)olapOrg);
            }
        }
    }

    public static void transformMyCompanyVars(String modelNum, DynamicObject adjustData) {
        long mycompany = adjustData.getLong("mycompany");
        if (mycompany != 0L) {
            IDNumberTreeNode node = MemberReader.findMemberById((String)modelNum, (String)"bcm_mycompanymembertree", (Long)mycompany);
            if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) {
                String number;
                long entity = adjustData.getLong("entity");
                String string = number = entity != 0L ? MemberReader.findEntityMemberById((String)modelNum, (Long)entity).getNumber() : null;
                if (StringUtils.isNotEmpty(number)) {
                    adjustData.set("mycompany", (Object)MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.MYCOMPANY_DIM, (String)number).getId());
                }
            }
        }
    }

    public static OperationResult saveDataWithCheck(AdjustOperationContext _ctx, List<DynamicObject> adjustHeads, Map<Long, List<DynamicObject>> adjustDatas) {
        OperationResult op = new OperationResult();
        op.setBillCount(adjustHeads.size());
        if (!CollectionUtils.isEmpty(adjustHeads)) {
            try {
                Pair pars = Pair.onePair(adjustHeads, adjustDatas);
                boolean isSysToMDD = (Boolean)_ctx.getUserObject("isSysToMDD", () -> Boolean.FALSE);
                AdjustValidatorExecute<Pair> validatorExecute = new AdjustValidatorExecute<Pair>(_ctx);
                validatorExecute.setValidateResult(op);
                validatorExecute.addValidator(new AdjustBaseInfoCheckValidator(isSysToMDD));
                validatorExecute.addValidator(new AdjustCheckDataNotNullValidator());
                validatorExecute.addValidator(new AdjustCheckDimMemValidator());
                validatorExecute.addValidator(new AdjustCheckArchiveStatusValidator());
                validatorExecute.addValidator(new AdjustSceneVersionValidator());
                if (isSysToMDD) {
                    validatorExecute.addValidator(new AdjustCheckOlapLockValidator().setCheck(true));
                    validatorExecute.addValidator(new AdjustCheckDataSysToMDDValidator());
                }
                validatorExecute.excute(pars);
                if (!CollectionUtil.isEmpty((Collection)((Collection)pars.p1))) {
                    AdjustOperationHelper.saveData(_ctx, (Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>)pars);
                }
            }
            catch (Throwable t) {
                op.getSuccessPkIds().clear();
                op.setMessage(AdjustmentServiceHelper.toString_Adj(t));
            }
        }
        return op;
    }

    private static void saveData(AdjustOperationContext _ctx, Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> pair) {
        AdjustOperationHelper.dealMutiCurrencyEntries(_ctx, pair);
        PlatUtil.executeWithTXNew(tx -> {
            if (!((List)pair.p1).isEmpty()) {
                for (DynamicObject head : (List)pair.p1) {
                    AdjustRepairDataServiceHelper.repairHeadBelongOrgListByDyna((DynamicObject)head, (Collection)((Map)pair.p2).getOrDefault(head.getLong("id"), Collections.emptyList()), (boolean)true);
                }
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)((List)pair.p1).get(0)).getDataEntityType(), (Object[])((List)pair.p1).toArray());
                ArrayList dataList = new ArrayList(100);
                ((Map)pair.p2).forEach((k, v) -> dataList.addAll(v));
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)dataList.get(0)).getDataEntityType(), (Object[])dataList.toArray());
                List<Long> sourceIds = ((List)pair.p1).stream().filter(e -> AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus().equals(e.getString("linkcreatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
                Set<Long> auditElimIds = ((List)pair.p1).stream().filter(e -> RptAdjustStatusEnum.AUDIT.status().equals(e.getString("status"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
                if (!sourceIds.isEmpty()) {
                    LinkageMappingService linkageMappingService = new LinkageMappingService((Long)_ctx.getModelId(), (Long)_ctx.getFyId(), (Long)_ctx.getScenarioId(), (Long)_ctx.getPeriodId(), sourceIds, false);
                    LinkageDataCollector linkageDataCollector = linkageMappingService.buildAutoElimLinkage();
                    Map<Long, Long> sourceId2LinkageIdMap = linkageDataCollector.getSourceId2LinkageIdMap();
                    sourceId2LinkageIdMap.forEach((sourceId, linkageId) -> {
                        if (linkageId != 0L && !auditElimIds.contains(sourceId)) {
                            auditElimIds.add((Long)linkageId);
                        }
                    });
                }
                if (Boolean.TRUE.equals(_ctx.getUserObject("isSysToMDD", () -> Boolean.FALSE)) && !auditElimIds.isEmpty()) {
                    AdjustCheckServiceHelper.doSysToMdd(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId(), auditElimIds, true);
                }
            }
        });
    }

    private static void dealMutiCurrencyEntries(AdjustOperationContext _ctx, Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> pair) {
        ArrayList<DynamicObject> entries = new ArrayList<DynamicObject>(10);
        for (DynamicObject adjust : (List)pair.p1) {
            IDNumberTreeNode entity;
            if (!adjust.getBoolean("multiplecurrency") || (entity = MemberReader.findEntityMemberById((Long)_ctx.getModelId(), (Long)DynUtils.getBaseId((DynamicObject)adjust, (String)"entity"))) == IDNumberTreeNode.NotFoundTreeNode || entity.isLeaf()) continue;
            List adjustdatas = ((Map)pair.p2).getOrDefault(adjust.getLong("id"), Collections.emptyList());
            for (DynamicObject dy : adjustdatas) {
                entries.add(dy);
                Set<Long> currencySet = AdjustConvertUtil.getMultipleCurrency(_ctx.getModelId(), entity.getId(), adjust.getString("bussnesstype"));
                for (Long curId : currencySet) {
                    DynamicObject otherCurrDy = AdjustOperationHelper.copyDynamicObject(dy, false);
                    otherCurrDy.set("currency", (Object)curId);
                    otherCurrDy.set("isdefaultcurrency", (Object)0);
                    entries.add(otherCurrDy);
                }
            }
        }
        if (!entries.isEmpty()) {
            AdjustConvertService adjConvertSer = new AdjustConvertService(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId());
            adjConvertSer.batchConvert(entries);
            HashMap temps = new HashMap(16);
            entries.stream().forEach(e -> temps.computeIfAbsent(DynUtils.getBaseId((DynamicObject)e, (String)"adjust"), v -> new ArrayList(10)).add(e));
            AdjustRateDiffCreateService createRateDiffSer = new AdjustRateDiffCreateService(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getFyId(), _ctx.getPeriodId());
            temps.keySet().iterator().forEachRemaining(e -> ((Map)pair.p2).put(e, createRateDiffSer.createRateDiffSingleElim((List)temps.get(e), true)));
        }
    }

    public static List<Dimension> getUseBalanceDims(long modelId) {
        return (List)ThreadCache.get((Object)("balanceDims_" + modelId), () -> {
            boolean isCM048 = ConfigServiceHelper.getBoolParam(modelId, "CM048");
            if (!ConfigServiceHelper.getBoolParam(modelId, "closeAdjustBalanceSet") && isCM048) {
                QFilter qf = new QFilter("model", "=", (Object)modelId);
                QFilter qFilter = new QFilter("issysdimension", "=", (Object)false).or("number", "=", (Object)PresetConstant.CHANGETYPE_DIM);
                qf.and(qFilter);
                return QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,id,dseq,membermodel,issysdimension,name,number,fieldmapped", (QFilter[])qf.toArray(), null).stream().map(dy -> new Dimension((DynamicObject)dy)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
    }

    public static boolean isRedirectNegate(long modelId, Map<String, Long> dimDataMap) {
        int balanceVal = 0;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (Dimension dim : AdjustOperationHelper.getUseBalanceDims(modelId)) {
            Long baseId = dimDataMap.get(dim.getNumber());
            IDNumberTreeNode node = MemberReader.findMemberById((String)modelNum, (String)dim.getEntity(), (Long)baseId);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return false;
            }
            Boolean baldirection = (Boolean)node.getProperty("baldirection");
            if (baldirection == null || !baldirection.booleanValue()) continue;
            balanceVal ^= 0xFFFFFFFF;
        }
        return balanceVal == -1;
    }
}

