/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.CommonAdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.RptAdjustTemplateModel;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustTemplateHelper {
    private static final String LOCK_ASSIGN = "lock.";
    private static final String CACHE_HEAD = "adjPapertemp.";
    public static final String ASSIGN_CACHE = "assign";
    public static final String TEMPLATE_CACHE = "temp";

    private AdjustTemplateHelper() {
    }

    public static Collection<Long> getAssignOrgNumToTempIdCache(Long modelId, Long scenarioId, String orgNum, String templatetype) {
        Map distributeMapFromCache = AdjustTemplateHelper.getAllCache(AdjustTemplateHelper.getCacheKey(ASSIGN_CACHE, modelId, scenarioId), () -> AdjustTemplateHelper.getAssignOrgNumAndTempIdMap(modelId, scenarioId, templatetype), HashMap.class);
        if (distributeMapFromCache == null) {
            return Collections.emptyList();
        }
        return distributeMapFromCache.getOrDefault(orgNum, Collections.emptyList());
    }

    private static Map<Long, Set<Long>> getAssignOrgIdToTempId(Long modelId, Long scenarioId, String templatetype, String isExcept) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("template.templatetype", "=", (Object)templatetype);
        qFilter.and("template.status", "=", (Object)"1");
        qFilter.and("isexcept", "=", (Object)isExcept);
        DataSet assignRecords = AdjustTemplateHelper.getPaperTemplateAssign(qFilter);
        Dimension entityDimension = AdjustTemplateHelper.getEntityDimension(modelId);
        if (entityDimension != null) {
            HashMap<Long, Set<Long>> orgIdToTempMap = new HashMap<Long, Set<Long>>(32);
            HashMap orgIdScopeMap = new HashMap(16);
            AtomicLong currTemplateId = new AtomicLong(0L);
            Consumer consumer = e -> {
                DimensionScope ds = new DimensionScope(modelId.toString(), entityDimension, (Map<Long, Integer>)e);
                Set<Long> resolveScopes = ds.getResolveScopeIds();
                resolveScopes.forEach(a -> {
                    HashSet<Long> templateSet = (HashSet<Long>)orgIdToTempMap.get(a);
                    if (CollectionUtils.isEmpty((Collection)templateSet)) {
                        templateSet = new HashSet<Long>();
                        orgIdToTempMap.put((Long)a, (Set<Long>)templateSet);
                    }
                    templateSet.add(currTemplateId.get());
                });
            };
            assignRecords.forEachRemaining(e -> {
                if (currTemplateId.get() == e.getLong("template.id").longValue() || currTemplateId.get() == 0L) {
                    orgIdScopeMap.put(e.getLong("entity.id") == 0L ? e.getLong("propertyvalue") : e.getLong("entity.id"), e.getInteger("range"));
                    currTemplateId.set(e.getLong("template.id"));
                } else {
                    consumer.accept((Object)orgIdScopeMap);
                    currTemplateId.set(e.getLong("template.id"));
                    orgIdScopeMap.clear();
                    orgIdScopeMap.put(e.getLong("entity.id") == 0L ? e.getLong("propertyvalue") : e.getLong("entity.id"), e.getInteger("range"));
                }
            });
            consumer.accept(orgIdScopeMap);
            return orgIdToTempMap;
        }
        return Collections.emptyMap();
    }

    private static Map<String, Collection<Long>> getAssignOrgNumAndTempIdMap(Long modelId, Long scenarioId, String templatetype) {
        Map<Long, Set<Long>> assignOrgIdToTempId = AdjustTemplateHelper.getAssignOrgIdToTempId(modelId, scenarioId, templatetype, "0");
        Map<Long, Set<Long>> exceptOrgIdToTempId = AdjustTemplateHelper.getAssignOrgIdToTempId(modelId, scenarioId, templatetype, "1");
        if (!CollectionUtils.isEmpty(assignOrgIdToTempId) && !CollectionUtils.isEmpty(exceptOrgIdToTempId)) {
            HashSet noOrgSet = new HashSet();
            assignOrgIdToTempId.forEach((k, v) -> {
                if (exceptOrgIdToTempId.containsKey(k)) {
                    v.removeAll((Collection)exceptOrgIdToTempId.get(k));
                    if (v.isEmpty()) {
                        noOrgSet.add(k);
                    }
                }
            });
            noOrgSet.forEach(assignOrgIdToTempId::remove);
        }
        HashMap<String, Collection<Long>> assignOrgNumToTempId = new HashMap<String, Collection<Long>>(16);
        if (!assignOrgIdToTempId.isEmpty()) {
            assignOrgIdToTempId.forEach((key, value) -> assignOrgNumToTempId.computeIfAbsent(MemberReader.findEntityMemberById((Long)modelId, (Long)key).getNumber(), k -> Sets.newHashSet()).addAll(value));
        }
        return assignOrgNumToTempId;
    }

    private static Set<Long> getAllShareOrg(Long modelId, Long mergeId) {
        HashSet<Long> allOrgs = new HashSet<Long>(16);
        IDNumberTreeNode mergeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)mergeId);
        if (mergeNode != IDNumberTreeNode.NotFoundTreeNode) {
            IDNumberTreeNode baseTreeNode = mergeNode.getBaseTreeNode();
            baseTreeNode.getShareNodes().forEach(e -> allOrgs.add(e.getId()));
            allOrgs.add(baseTreeNode.getId());
        }
        return allOrgs;
    }

    public static Set<Long> getAssignTemplateOrgDataRange(Long modelId, Long mergeId, Long templateId) {
        Set<Long> allShareOrg = AdjustTemplateHelper.getAllShareOrg(modelId, mergeId);
        QFilter qf = new QFilter("type", "=", (Object)"1");
        qf.and("belongid", "=", (Object)templateId);
        qf.and("mergeorg", "in", allShareOrg);
        DynamicObject[] ass = BusinessDataServiceHelper.load((String)"bcm_merge_assign_data", (String)"mergeorg.id,belongid,entryentity.entity,entryentity.range,entryentity.property1,entryentity.propertyvalue1,isexcept", (QFilter[])qf.toArray(), (String)"isexcept");
        SchemeContext schemeContext = SchemeContext.getInstance(modelId);
        Dimension dimension = schemeContext.getDimensionByNumber("Entity");
        Map<Object, Object> orgScopeMap = new HashMap(16);
        if (ass.length == 0 || ass[0].getBoolean("isexcept")) {
            DynamicObject[] collect = new HashMap(16);
            collect.put(mergeId, RangeEnum.VALUE_20.getValue());
            orgScopeMap = AdjustTemplateHelper.resolveEntity(modelId, dimension, (Map<Long, Integer>)collect, mergeId);
        }
        for (DynamicObject as : ass) {
            DynamicObjectCollection entryentity = as.getDynamicObjectCollection("entryentity");
            HashMap<Long, Integer> collect = new HashMap<Long, Integer>(16);
            if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                for (DynamicObject orgRange : entryentity) {
                    long orgId = orgRange.getLong("entity_id") != 0L ? orgRange.getLong("entity_id") : orgRange.getLong("propertyvalue1_id");
                    int range = orgRange.getInt("range");
                    if (allShareOrg.contains(orgId)) {
                        if (RangeEnum.VALUE_10.getValue() == range || RangeEnum.VALUE_60.getValue() == range || RangeEnum.VALUE_70.getValue() == range) continue;
                        if (RangeEnum.VALUE_30.getValue() == range) {
                            range = RangeEnum.VALUE_20.getValue();
                        } else if (RangeEnum.VALUE_50.getValue() == range) {
                            range = RangeEnum.VALUE_40.getValue();
                        }
                    }
                    collect.put(orgId, range);
                }
            } else {
                collect.put(mergeId, RangeEnum.VALUE_20.getValue());
            }
            Map<String, Long> resolveMap = AdjustTemplateHelper.resolveEntity(modelId, dimension, collect, as.getLong("mergeorg.id"));
            if (as.getBoolean("isexcept")) {
                for (Map.Entry<String, Long> entry : resolveMap.entrySet()) {
                    orgScopeMap.remove(entry.getKey());
                }
                continue;
            }
            orgScopeMap.putAll(resolveMap);
        }
        HashSet<Long> orgScopeIds = new HashSet<Long>(orgScopeMap.size());
        String longNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)mergeId).getLongNumber();
        orgScopeMap.forEach((k, id) -> {
            IDNumberTreeNode baseNode;
            String realPath = longNumber + k;
            if (StringUtils.equals((CharSequence)realPath, (CharSequence)(baseNode = MemberReader.findEntityMemberById((Long)modelId, (Long)id).getBaseTreeNode()).getLongNumber())) {
                orgScopeIds.add(baseNode.getId());
            } else {
                baseNode.getShareNodes().forEach(e -> {
                    if (StringUtils.equals((CharSequence)realPath, (CharSequence)e.getLongNumber())) {
                        orgScopeIds.add(e.getId());
                        return;
                    }
                });
            }
        });
        return orgScopeIds;
    }

    private static Map<String, Long> resolveEntity(long modelId, Dimension dimension, Map<Long, Integer> map, Long mergeId) {
        DimensionScope ds = new DimensionScope(modelId + "", dimension, map);
        HashMap<String, Long> res = new HashMap<String, Long>(16);
        IDNumberTreeNode merge = MemberReader.findEntityMemberById((Long)modelId, (Long)mergeId);
        ds.getResolveScopeIds().forEach(orgId -> {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String newLongNumber = org.getLongNumber().substring(merge.getLongNumber().length());
            res.put(newLongNumber, (Long)orgId);
        });
        return res;
    }

    private static <T> T getAllCache(String cacheKey, Supplier<T> supplier) {
        return AdjustTemplateHelper.getAllCache(cacheKey, supplier, Object.class);
    }

    private static <T> T getAllCache(String cacheKey, Supplier<T> supplier, Class clazz) {
        Object res = AppCacheServiceHelper.get(cacheKey, clazz);
        if (res == null) {
            try (DLock lock = DLock.create((String)(LOCK_ASSIGN + cacheKey));){
                if (lock.tryLock(60000L) && (res = AppCacheServiceHelper.get(cacheKey, clazz)) == null) {
                    res = supplier.get();
                    AppCacheServiceHelper.put(cacheKey, res, 60);
                }
            }
        }
        return res;
    }

    private static DataSet getPaperTemplateAssign(QFilter qFilter) {
        return QueryServiceHelper.queryDataSet((String)"bcm_templateassignrecord", (String)"bcm_templateassignrecord", (String)"entity.id,entity.number,template.id,range,isexcept,propertyvalue,property", (QFilter[])qFilter.toArray(), (String)"template");
    }

    private static Dimension getEntityDimension(Long modelId) {
        return (Dimension)ThreadCache.get((Object)"templateEntityDimension", () -> {
            DynamicObject dimensionDy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,dseq,membermodel,issysdimension,name,number,fieldmapped,shortnumber", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"Entity").toArray());
            if (dimensionDy != null) {
                Dimension dimension = new Dimension(dimensionDy);
                dimension.setSeq(dimensionDy.getInt("dseq"));
                dimension.setMembermodel(dimensionDy.getString("membermodel"));
                return dimension;
            }
            return null;
        });
    }

    private static String getCacheKey(String sign, Long modelId, Long scenarioId) {
        return CACHE_HEAD + sign + modelId + "." + scenarioId + "_V1.0";
    }

    private static void clearDistributeMapFromCache(Long modelId, Long scenarioId, String ... signs) {
        if (signs != null) {
            for (String sign : signs) {
                AppCacheServiceHelper.remove(AdjustTemplateHelper.getCacheKey(sign, modelId, scenarioId));
            }
        }
    }

    public static void clearDistributeMapFromAllCache(Long modelId, Long scenarioId) {
        AdjustTemplateHelper.clearDistributeMapFromCache(modelId, scenarioId, ASSIGN_CACHE, TEMPLATE_CACHE);
        AdjustTemplateHelper.clearAllSceneTemplateCache(modelId, ASSIGN_CACHE, TEMPLATE_CACHE);
    }

    public static void clearAssignTemplateCache(Long modelId, Long scenarioId) {
        AdjustTemplateHelper.clearDistributeMapFromCache(modelId, scenarioId, ASSIGN_CACHE);
        AdjustTemplateHelper.clearAllSceneTemplateCache(modelId, ASSIGN_CACHE);
    }

    public static void clearAllSceneTemplateCache(Long modelId, String ... signs) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Set sceneIds = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.SCENARIO.getNumber(), (String)modelNumber).stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
        for (Long sceneId : sceneIds) {
            AdjustTemplateHelper.clearDistributeMapFromCache(modelId, sceneId, signs);
        }
        AdjustTemplateHelper.clearDistributeMapFromCache(modelId, null, signs);
        AdjustTemplateHelper.clearDistributeMapFromCache(modelId, 0L, signs);
        AdjustTemplateHelper.clearDistributeMapFromCache(modelId, -1L, signs);
    }

    public static List<CommonAdjustTemplateModel> getTemplateListCache(Long modelId, Long scenarioId, Collection<Long> templateIds) {
        String cache;
        if (templateIds != null && !templateIds.isEmpty() && (cache = AdjustTemplateHelper.getAllCache(AdjustTemplateHelper.getCacheKey(TEMPLATE_CACHE, modelId, scenarioId), () -> {
            PaperTmplChainFilter filter = new PaperTmplChainFilter(modelId, PaperTemplateTypeEnum.PRTADJUST, true);
            filter.addFilter(new SceneFilter(scenarioId));
            QFilter qf = new QFilter("model", "=", (Object)modelId).and("status", "=", (Object)"1").and("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype()).and("id", "in", filter.doFilter(null));
            String selectFields = "id,templatecatalog,model,scenario,versionnumber,versiondescription,effectivedate,expiringdate,creator,status,templatetype,number,adjustcatalog,permclass,effectivescope,createtime,modifytime,group,description,versionstatus,modifier,spreadjson,data,name,bussnesstype,linkcreatetype,balancetype,journaltype,commembid,comdimension,comentitysign,commembentry.seq,spreadmembid,spreaddimension,spreadentitysign,spreadmembentry.seq,multiplecurrency,cvtbeforecurrency,executeorder";
            DynamicObject[] templs = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qf.toArray());
            HashMap<Long, CommonAdjustTemplateModel> templateMap = new HashMap<Long, CommonAdjustTemplateModel>(16);
            for (DynamicObject templ : templs) {
                CommonAdjustTemplateModel commonAdjustTemplateModel = new CommonAdjustTemplateModel();
                commonAdjustTemplateModel.loadDynaObj2Model(templ);
                templateMap.put(templ.getLong("id"), commonAdjustTemplateModel);
            }
            return ObjectSerialUtil.toByteSerialized(templateMap);
        })) != null) {
            Map mapCache = (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
            return templateIds.stream().map(mapCache::get).filter(e -> e != null).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<CommonAdjustTemplateModel> getTemplateListById(Long modelId, Collection<Long> templateIds) {
        if (templateIds != null && !templateIds.isEmpty()) {
            DynamicObject[] templs;
            List<CommonAdjustTemplateModel> resultList = AdjustTemplateHelper.getTemplateListCache(modelId, null, templateIds);
            QFilter qf = new QFilter("model", "=", (Object)modelId).and("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype()).and("id", "in", templateIds).and("id", "not in", resultList.stream().map(RptAdjustTemplateModel::getId).collect(Collectors.toList()));
            String selectFields = "id,templatecatalog,model,scenario,versionnumber,versiondescription,effectivedate,expiringdate,creator,status,templatetype,number,adjustcatalog,permclass,effectivescope,createtime,modifytime,group,description,versionstatus,modifier,spreadjson,data,name,bussnesstype,linkcreatetype,balancetype,journaltype,commembid,comdimension,comentitysign,commembentry.seq,spreadmembid,spreaddimension,spreadentitysign,spreadmembentry.seq,multiplecurrency,cvtbeforecurrency,executeorder";
            for (DynamicObject templ : templs = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qf.toArray())) {
                CommonAdjustTemplateModel commonAdjustTemplateModel = new CommonAdjustTemplateModel();
                commonAdjustTemplateModel.loadDynaObj2Model(templ);
                resultList.add(commonAdjustTemplateModel);
            }
            return resultList;
        }
        return Lists.newArrayList();
    }
}

