/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.IValidator;

public abstract class AbstractValidator<T>
implements IValidator<T> {
    private final Map<Long, List<ImportLogger.ImportLog>> tempLogCache = new HashMap<Long, List<ImportLogger.ImportLog>>(16);
    private AdjustOperationContext _ctx;
    private OperationResult op;
    private T checkData;
    private AdjRecordLog log;
    private boolean isOnlyWarning = false;

    @Override
    public void validate() {
    }

    @Override
    public void setCheckData(T checkData) {
        this.checkData = checkData;
    }

    public T getCheckData() {
        return this.checkData;
    }

    @Override
    public void setCtx(AdjustOperationContext _ctx) {
        this._ctx = _ctx;
    }

    public AdjustOperationContext _ctx() {
        return this._ctx;
    }

    @Override
    public void setValidateResult(OperationResult op) {
        this.op = op;
    }

    public OperationResult getOp() {
        if (this.op == null) {
            this.op = new OperationResult();
        }
        return this.op;
    }

    @Override
    public void setAdjLog(AdjRecordLog log) {
        this.log = log;
    }

    public AdjRecordLog getLog() {
        if (this.log == null) {
            this.log = new AdjRecordLog();
        }
        return this.log;
    }

    @Override
    public void setOnlyWarning(Boolean isOnlyWarning) {
        this.isOnlyWarning = isOnlyWarning;
    }

    @Override
    public Boolean isOnlyWarning() {
        return this.isOnlyWarning;
    }

    protected void addMessage(long pkId, String content, ErrorLevel errorLevel) {
        OperateErrorInfo info = new OperateErrorInfo();
        info.setErrorLevel(errorLevel.name());
        info.setTitle(this.getValidatorKey());
        info.setMessage(content);
        if (ErrorLevel.Warning == errorLevel || this.isOnlyWarning().booleanValue()) {
            this.getLog().addWarningMsg(info.getMessage());
        } else {
            info.setPkValue((Object)pkId);
            this.getLog().addErrorMsg(info.getMessage());
        }
        this.getOp().addErrorInfo(info);
    }

    public Map<Long, List<ImportLogger.ImportLog>> getTempLogCache() {
        return this.tempLogCache;
    }

    protected void addTempLogCache(long pkId, String content) {
        this.getTempLogCache().computeIfAbsent(pkId, a -> Lists.newArrayList()).add(new ImportLogger.ImportLog(content));
    }

    protected abstract String getValidatorKey();
}

