/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.entity.operate.result.OperationResult;
import kd.fi.bcm.business.adjust.model.AdjustOperQueryParam;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.common.Pair;

public class AdjustValidatorExecute<T> {
    private AdjustOperationContext ctx;
    private final LinkedHashMap<Class, IValidator<T>> validators = new LinkedHashMap(10);
    private OperationResult validateResult;
    private AdjRecordLog adjLog;

    public AdjustValidatorExecute(long modelId) {
        this.ctx = new AdjustOperationContext(modelId);
    }

    public AdjustValidatorExecute(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    public void addValidator(IValidator validator) {
        this.validators.put(validator.getClass(), validator);
    }

    public void addOnlyWarningValidator(IValidator validator) {
        validator.setOnlyWarning(true);
        this.addValidator(validator);
    }

    public OperationResult excute(List<Object> pkIds) {
        AdjustOperQueryParam queryParam = new AdjustOperQueryParam(true, 0);
        AdjustOperationThreadHelper.groupAdjustList(pkIds, queryParam, (adjustDys, adjustDatas) -> this.excute(Pair.onePair((Object)adjustDys, (Object)adjustDatas)));
        return this.getValidateResult();
    }

    public OperationResult excute(T checkdata) {
        this.validators.forEach((className, validator) -> {
            validator.setCtx(this.ctx);
            validator.setValidateResult(this.getValidateResult());
            validator.setAdjLog(this.adjLog);
            validator.setCheckData(checkdata);
            if (validator.isContinueValidate(checkdata).booleanValue()) {
                validator.validate();
            }
        });
        return this.getValidateResult();
    }

    public boolean isSuccess() {
        return this.getValidateResult().isSuccess();
    }

    public void setValidateResult(OperationResult validateResult) {
        this.validateResult = validateResult;
    }

    public Collection<IValidator<T>> getValidators() {
        return this.validators.values();
    }

    public OperationResult getValidateResult() {
        if (this.validateResult == null) {
            this.validateResult = new OperationResult();
            this.setValidateResult(this.validateResult);
        }
        return this.validateResult;
    }

    public void setOperationKey(String operationKey) {
        this.ctx.getUserObject().removeAll((Object)"OperationKey");
        this.ctx.addUserObject("OperationKey", operationKey);
    }

    public void setAdjLog(AdjRecordLog adjLog) {
        if (adjLog != null) {
            this.adjLog = adjLog;
        }
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }
}

