/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DimMemberNodeValidator;

import java.util.Set;
import kd.fi.bcm.business.adjust.inputReader.DimMemberNode;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;

public abstract class AbstractDimMemberNodeValidator
implements IValidator<Set<DimMemberNode>> {
    private final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AbstractDimMemberNodeValidator.class);
    private AdjustOperationContext ctx;
    private Set<DimMemberNode> toCheckNodeSet;

    protected void beforeValidate() {
    }

    @Override
    public void setCheckData(Set<DimMemberNode> toCheckNodeSet) {
        this.toCheckNodeSet = toCheckNodeSet;
    }

    @Override
    public void validate() {
        this.startWatch();
        this.beforeValidate();
        for (DimMemberNode node : this.toCheckNodeSet) {
            if (!StringUtils.isEmpty((CharSequence)node.getErrorMsg())) continue;
            this.validateSingle(node);
        }
        this.afterValidate();
        this.endWatch();
    }

    protected abstract void validateSingle(DimMemberNode var1);

    protected void afterValidate() {
    }

    private void startWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            this.LOG.startWatch();
        }
    }

    private void endWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            this.LOG.infoEnd(String.format("\u6821\u9a8c[%s]\u6267\u884c\u8017\u65f6", this.getValidatorKey()));
        }
    }

    protected String getOperationKey() {
        return (String)this.ctx.getProperty("OperationKey");
    }

    protected abstract String getValidatorKey();

    protected long getModelId() {
        return this.getSctx().getModel();
    }

    protected String getModelNum() {
        return this.getSctx().getModelNumber();
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }

    protected SchemeContext getSctx() {
        return this.getCtx().getSctx();
    }

    @Override
    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Boolean isOnlyWarning() {
        return false;
    }

    @Override
    public Boolean isContinueValidate(Set<DimMemberNode> checkData) {
        return true;
    }

    protected AdjustOperTypeEnum getOperationType() {
        return this.getCtx().getOperTypeEnum();
    }
}

