/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.operation.AdjDynamicModelConsumer;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;

public abstract class AbstractDynamicModelValidator
implements IValidator<Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>>> {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AbstractValidator.class);
    private Boolean isOnlyWarning = false;
    private AdjustOperationContext ctx;
    private OperationResult validateResult;
    private AdjRecordLog adjLog;
    private List<IDynamicObjectModel> adjustDys;
    private Map<Long, List<IDynamicObjectModel>> adjustDatas;
    private final StringBuilder rowErrorCacher = new StringBuilder();

    @Override
    public void setCheckData(Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>> checkData) {
        this.adjustDys = (List)checkData.p1;
        this.adjustDatas = (Map)checkData.p2;
        if (CollectionUtils.isEmpty(this.adjustDys)) {
            return;
        }
        HashSet<Long> successPkId = new HashSet<Long>(this.adjustDys.size());
        this.getValidateResult().getSuccessPkIds().forEach(succ -> successPkId.add((Long)succ));
        for (IDynamicObjectModel dy : this.adjustDys) {
            successPkId.add(dy.getLong("id"));
        }
        this.getValidateResult().getSuccessPkIds().clear();
        this.getValidateResult().getSuccessPkIds().addAll(successPkId);
    }

    @Override
    public void validate() {
        this.startWatch();
        this.beforeValidate();
        this.iterator((singleAdjust, singleAdjustDatas) -> {
            this.validateSingle(singleAdjust, singleAdjustDatas);
            if (this.rowErrorCacher.length() > 0) {
                this.addErrorMessage(singleAdjust, this.rowErrorCacher.toString());
                this.rowErrorCacher.setLength(0);
            }
        });
        this.afterValidate();
        this.endWatch();
    }

    protected void beforeValidate() {
    }

    protected abstract void validateSingle(IDynamicObjectModel var1, List<IDynamicObjectModel> var2);

    protected void afterValidate() {
        this.getAdjustDys().removeIf(adjustDy -> {
            Long adjId = adjustDy.getLong("id");
            if (this.getValidateResult().getSuccessPkIds().contains(adjId)) {
                return false;
            }
            this.getAdjustDatas().remove(adjId);
            return true;
        });
        this.adjustDys = null;
        this.adjustDatas = null;
    }

    protected void iterator(AdjDynamicModelConsumer adjConsumer) {
        this.getAdjustDys().forEach(adjustDy -> adjConsumer.accept((IDynamicObjectModel)adjustDy, this.getAdjustDatas().getOrDefault(adjustDy.getLong("id"), Collections.emptyList())));
    }

    public List<IDynamicObjectModel> getAdjustDys() {
        return this.adjustDys;
    }

    public Map<Long, List<IDynamicObjectModel>> getAdjustDatas() {
        return this.adjustDatas;
    }

    @Override
    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setAdjLog(AdjRecordLog log) {
        this.adjLog = log;
    }

    @Override
    public void setOnlyWarning(Boolean isOnlyWarning) {
        this.isOnlyWarning = isOnlyWarning;
    }

    @Override
    public Boolean isOnlyWarning() {
        return this.isOnlyWarning;
    }

    @Override
    public void setValidateResult(OperationResult op) {
        this.validateResult = op;
    }

    public OperationResult getValidateResult() {
        return this.validateResult;
    }

    protected String getOperationKey() {
        return (String)this.ctx.getProperty("OperationKey");
    }

    protected void addRowErrorMsg(IDynamicObjectModel rowData, String content) {
        this.rowErrorCacher.append(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7\u4e3a%1$s\u5e8f\u53f7\u4e3a%2$s\u7684\u660e\u7ec6\u5206\u5f55%3$s", (String)"AbstractValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), rowData.getString("groupnum"), rowData.getString("dseq"), content));
    }

    protected void addWarningMessage(IDynamicObjectModel adjust, String content) {
        this.addMessage(adjust, content, ErrorLevel.Warning);
    }

    protected void addErrorMessage(IDynamicObjectModel adjust, String content) {
        if (this.isOnlyWarning().booleanValue()) {
            this.addWarningMessage(adjust, content);
        } else {
            this.addMessage(adjust, content, ErrorLevel.Error);
            this.getValidateResult().getSuccessPkIds().remove(adjust.getLong("id"));
        }
    }

    protected void addMessage(IDynamicObjectModel adjust, String content, ErrorLevel errorLevel) {
        OperateErrorInfo info = new OperateErrorInfo();
        info.setErrorLevel(errorLevel.name());
        info.setEntityKey(this.getEntityKey());
        info.setTitle(this.getOperationKey());
        info.setMessage(adjust.getString("number") + ":".concat(content));
        if (ErrorLevel.Warning == errorLevel) {
            this.getAdjLog().addWarningMsg(info.getMessage());
        } else {
            info.setPkValue((Object)adjust.getLong("id"));
            this.getAdjLog().addErrorMsg(info.getMessage());
        }
        this.validateResult.addErrorInfo(info);
    }

    protected boolean needCheck(IDynamicObjectModel rowData) {
        if ("btn_createlinkage".equals(this.getOperationKey()) && EntrySourceEnum.getLinkListToString().contains(rowData.getString("entrysource"))) {
            return false;
        }
        return !"btn_adddiffentry".equals(this.getOperationKey()) || !"2".equals(rowData.getString("entryrowtype"));
    }

    public AdjRecordLog getAdjLog() {
        if (this.adjLog == null) {
            this.adjLog = new AdjRecordLog();
        }
        return this.adjLog;
    }

    private void startWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.startWatch();
        }
    }

    private void endWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.infoEnd(String.format("\u6821\u9a8c[%s]\u6267\u884c\u8017\u65f6", this.getValidatorKey()));
        }
    }

    protected String getValidatorKey() {
        return this.getClass().getName();
    }

    public String getEntityKey() {
        return "bcm_rptadjust";
    }

    @Override
    public Boolean isContinueValidate(Pair<List<IDynamicObjectModel>, Map<Long, List<IDynamicObjectModel>>> checkData) {
        return IValidator.super.isContinueValidate(checkData);
    }

    public AdjustOperationContext _ctx() {
        return this.ctx;
    }
}

