/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AbstractDynamicModelValidator;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;

public class AdjustCheckDataNotNullDynaModelValidator
extends AbstractDynamicModelValidator {
    @Override
    protected void beforeValidate() {
    }

    @Override
    protected void validateSingle(IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
        adjustDataList.forEach(rowData -> {
            if (this.needCheck((IDynamicObjectModel)rowData)) {
                boolean bl = this.checkDimensionMemNotNull((IDynamicObjectModel)rowData) && this.checkBigDecimalValNotNull(adjust, (IDynamicObjectModel)rowData);
            }
        });
    }

    private boolean checkBigDecimalValNotNull(IDynamicObjectModel adjust, IDynamicObjectModel rowData) {
        if (AdjustEntryRowTypeEnum.RATE_DIFF.getValue().intValue() == rowData.getInt("entryrowtype")) {
            return true;
        }
        boolean isMutiCurrency = adjust.getBoolean("multiplecurrency");
        boolean isDValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("debit"));
        boolean isCValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("credit"));
        boolean isSumValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("summoney"));
        boolean isNotEmpty = isDValueEmpty ^ isCValueEmpty && !isSumValueEmpty;
        boolean isAllEmpty = isDValueEmpty && isCValueEmpty && isSumValueEmpty;
        boolean isUse = Boolean.TRUE;
        if (isMutiCurrency) {
            boolean isRateValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("rate"));
            boolean isCvtBefDValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("cvtbeforedebit"));
            boolean isCvtBefCValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("cvtbeforecredit"));
            boolean isCvtBefSumValueEmpty = AdjustOperationHelper.isZero(rowData.getBigDecimal("cvtbeforesummoney"));
            boolean cvtBeforeNotEmpty = isCvtBefCValueEmpty ^ isCvtBefDValueEmpty && !isCvtBefSumValueEmpty;
            boolean cvtBeforeAllEmpty = isCvtBefCValueEmpty && isCvtBefDValueEmpty && isCvtBefSumValueEmpty;
            isUse = !(cvtBeforeAllEmpty && isNotEmpty || cvtBeforeNotEmpty && isNotEmpty && isRateValueEmpty);
        } else {
            boolean bl = isUse = isNotEmpty || isAllEmpty;
        }
        if (!isUse) {
            this.addRowErrorMsg(rowData, ResManager.loadKDString((String)"\u91d1\u989d\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDataNotNullValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return isUse;
    }

    private boolean checkDimensionMemNotNull(IDynamicObjectModel rowData) {
        if (rowData.getBoolean("isdefaultcurrency")) {
            HashSet<String> emptyDimensionSet = new HashSet<String>(16);
            for (Dimension dim : this._ctx().getSctx().getDimensions()) {
                IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dim.getNumber(), (long)rowData.getBaseDataId(dim.getFieldmapped()));
                if (IDNumberTreeNode.NotFoundTreeNode != memNode && memNode.getParent() != null) continue;
                emptyDimensionSet.add(dim.getName());
            }
            if (!emptyDimensionSet.isEmpty()) {
                this.addRowErrorMsg(rowData, String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u7ef4\u5ea6\u201c%s\u201d\u6210\u5458\u662f\u5426\u4e3a\u7a7a\u3002", (String)"AdjustCheckDataNotNullValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), emptyDimensionSet));
                return false;
            }
        }
        return true;
    }
}

