/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AbstractDynamicModelValidator;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;

public class AdjustCheckDimMemDynaModelValidator
extends AbstractDynamicModelValidator {
    @Override
    protected void validateSingle(IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
        String modelNum = this._ctx().getModelNum();
        List<Dimension> dimensions = this._ctx().getSctx().getDimensions();
        String process = adjust.getString("process");
        boolean relaProcess = OrgRelaProcessMembPool.isRelaProcess((String)process);
        adjustDataList.forEach(rowData -> {
            if (rowData.getBoolean("isdefaultcurrency") && this.needCheck((IDynamicObjectModel)rowData)) {
                for (Dimension dim : dimensions) {
                    long memberId = rowData.getBaseDataId(dim.getFieldmapped());
                    IDNumberTreeNode dimTree = BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)memberId);
                    if (dimTree == null || IDNumberTreeNode.NotFoundTreeNode.equals(dimTree)) continue;
                    if (StorageTypeEnum.LABEL == dimTree.getStorageType()) {
                        this.addRowErrorMsg((IDynamicObjectModel)rowData, String.format(AdjustCheckDimMemDynaModelValidator.labelTextMessage(), dim.getName()));
                        continue;
                    }
                    if ("Entity".equals(dim.getNumber())) {
                        if (dimTree.isLeaf() && ("DADJ".equals(process) || "DEJE".equals(process))) {
                            this.addRowErrorMsg((IDynamicObjectModel)rowData, ResManager.loadKDString((String)"DADJ\u548cDEJE\u4e1a\u52a1\u7c7b\u578b\u4e0b\u4e0d\u80fd\u5b58\u5728\u660e\u7ec6\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                            continue;
                        }
                    } else if (!dimTree.isLeaf()) {
                        this.addRowErrorMsg((IDynamicObjectModel)rowData, String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e0d\u80fd\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff1a%2$s", (String)"AdjustCheckDimMemValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), dimTree.getName()));
                        continue;
                    }
                    if ("Entity".equals(dim.getNumber())) {
                        if (!relaProcess) continue;
                        Long mergeId = rowData.getBaseDataId("merge");
                        IDNumberTreeNode mergeTree = BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)mergeId);
                        if (mergeTree == null || IDNumberTreeNode.NotFoundTreeNode.equals(mergeTree) || dimTree.getLongNumber().contains("!" + mergeTree.getNumber() + "!")) continue;
                        this.addRowErrorMsg((IDynamicObjectModel)rowData, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u548c\u5408\u5e76\u8282\u70b9\u4e0d\u5339\u914d,\u5176\u4e2d\u660e\u7ec6\u5206\u5f55\u7ec4\u7ec7\u4e3a%1$s,\u5408\u5e76\u8282\u70b9\u7ec4\u7ec7\u4e3a%2$s\u3002", (String)"AdjustCheckDimMemValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), rowData.getString("entity.longnumber"), rowData.getString("entity.longnumber")));
                        continue;
                    }
                    if ("Account".equals(dim.getNumber())) {
                        if (Boolean.TRUE.equals(ObjectConverter.convert((Object)dimTree.getProperty("iscaltype"), Boolean.class, (boolean)false))) {
                            this.addRowErrorMsg((IDynamicObjectModel)rowData, AdjustCheckDimMemDynaModelValidator.calAcctTextMessage());
                            continue;
                        }
                        DataTypeEnum accountType = DataTypeEnum.getDataTypeEnumByIndex((String)((String)dimTree.getProperty("datatype")));
                        if (DataTypeEnum.TXT == accountType || DataTypeEnum.DATETP == accountType || DataTypeEnum.ENUMTP == accountType) {
                            this.addRowErrorMsg((IDynamicObjectModel)rowData, String.format(ResManager.loadKDString((String)"%1$s\u662f%2$s\u6210\u5458\uff0c\u4e0d\u53ef\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCopyOperation_3", (String)"fi-bcm-business", (Object[])new Object[0]), dimTree.getNumber(), accountType.getName()));
                            continue;
                        }
                        if (DrCRDirectEnum.NONE.getOIndex().equals(dimTree.getProperty("drcrdirect"))) {
                            this.addRowErrorMsg((IDynamicObjectModel)rowData, AdjustCheckDimMemDynaModelValidator.acctDirectTextmessage());
                            continue;
                        }
                        if (this.checkAccountDimVal(dimTree.getId(), (IDynamicObjectModel)rowData)) continue;
                        continue;
                    }
                    if (!"MyCompany".equals(dim.getNumber()) || !SystemVarsEnum.isDimVars((String)dimTree.getNumber())) continue;
                    this.addRowErrorMsg((IDynamicObjectModel)rowData, AdjustCheckDimMemDynaModelValidator.varTestMessage());
                }
            }
        });
    }

    private boolean checkAccountDimVal(Long accId, IDynamicObjectModel rowData) {
        HashMap accResult = new HashMap(16);
        Map<String, Set<Long>> acc = AccountMemberUtil.getAccountDimValMapWithGlobalCache(accId, this._ctx().getModelId());
        if (acc != null && !acc.isEmpty()) {
            acc.forEach((dimNum, ids) -> accResult.put(dimNum, ids.stream().map(id -> BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dimNum, (long)id).getNumber()).collect(Collectors.toSet())));
        }
        if (!accResult.isEmpty()) {
            HashSet<String> noCheckDimSet = new HashSet<String>(16);
            Map<String, Long> dimMemMap = this._ctx().getSctx().getDimensions().stream().collect(Collectors.toMap(Dimension::getNumber, dim -> rowData.getBaseDataId(dim.getFieldmapped())));
            for (Map.Entry enrty : accResult.entrySet()) {
                String dimNum2 = (String)enrty.getKey();
                Long memId = dimMemMap.get(dimNum2);
                IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dimNum2, (long)memId);
                if (memNode == IDNumberTreeNode.NotFoundTreeNode || ((Set)enrty.getValue()).contains(memNode.getNumber())) continue;
                noCheckDimSet.add(this._ctx().getSctx().getDimensionByNumber(dimNum2).getName());
            }
            if (!noCheckDimSet.isEmpty()) {
                this.addRowErrorMsg(rowData, String.format(ResManager.loadKDString((String)"%s\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u7b26\u5408\u79d1\u76ee\u6709\u6548\u6027\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]), noCheckDimSet));
                noCheckDimSet.clear();
                return false;
            }
        }
        return true;
    }

    public static String acctDirectTextmessage() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u79d1\u76ee\u662f\u5426\u5b58\u5728\u501f\u8d37\u7b97\u6cd5\u3002", (String)"AdjustCheckDimMemValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String calAcctTextMessage() {
        return ResManager.loadKDString((String)"\u5305\u542b\u8ba1\u7b97\u7c7b\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String labelTextMessage() {
        return ResManager.loadKDString((String)"%s\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String varTestMessage() {
        return ResManager.loadKDString((String)"%s\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
    }
}

