/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.validator.DynamicObjectModelValidator.AbstractDynamicModelValidator;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;

public class AdjustCheckPermDynaModelValidator
extends AbstractDynamicModelValidator {
    private PermissionService permissionService;
    private ArrayListMultimap<String, Long> permCalssMap = null;
    private ArrayListMultimap<String, Long> calPermCalssMap = null;
    private boolean permSign = true;
    private boolean isSkipOrg = false;

    public AdjustCheckPermDynaModelValidator() {
    }

    public AdjustCheckPermDynaModelValidator(boolean permSign) {
        this.permSign = permSign;
    }

    public AdjustCheckPermDynaModelValidator setSkipOrg() {
        this.isSkipOrg = Boolean.TRUE;
        return this;
    }

    @Override
    protected void beforeValidate() {
        this.permissionService = PermissionServiceImpl.getInstance(this._ctx().getModelId());
        if (!this.permissionService.isAdmin()) {
            this.permCalssMap = PermClassEntityHelper.getPermissionMap("bcm_rptadjust", String.valueOf(this._ctx().getModelId()), RequestContext.get().getUserId());
        }
        if (!this.permissionService.isAdmin()) {
            this.calPermCalssMap = PermClassEntityHelper.getPermissionMap("bcm_templatecatalog", String.valueOf(this._ctx().getModelId()), RequestContext.get().getUserId());
        }
    }

    @Override
    protected void validateSingle(IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
        if (!this.permissionService.isAdmin() && this.checkAdjustPermClass(adjust) && this.checkAdjustDimMemPerm(adjust, adjustDataList)) {
            return;
        }
    }

    private boolean checkAdjustPermClass(IDynamicObjectModel adjust) {
        List readOnlyIds;
        List noPermIds = this.permCalssMap.get((Object)"1");
        if (!CollectionUtils.isEmpty((Collection)noPermIds) && noPermIds.contains(adjust.getLong("id"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u7ed1\u5b9a\u6743\u9650\u7c7b\u65e0\u6743", (String)"AdjustCheckPermValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (this.permSign && !CollectionUtils.isEmpty((Collection)(readOnlyIds = this.permCalssMap.get((Object)"2"))) && readOnlyIds.contains(adjust.getLong("id"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u7ed1\u5b9a\u6743\u9650\u7c7b\u53ea\u8bfb", (String)"AdjustCheckPermValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        long templatecatalog = adjust.getBaseDataId("templatecatalog");
        if (templatecatalog != 0L) {
            List readOnlyCalIds;
            List noPermCalIds = this.calPermCalssMap.get((Object)"1");
            if (!CollectionUtils.isEmpty((Collection)noPermCalIds) && noPermCalIds.contains(templatecatalog)) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u7c7b\u7ed1\u5b9a\u6743\u9650\u7c7b\u65e0\u6743", (String)"AdjustCheckPermValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (this.permSign && !CollectionUtils.isEmpty((Collection)(readOnlyCalIds = this.calPermCalssMap.get((Object)"2"))) && readOnlyCalIds.contains(templatecatalog)) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u7c7b\u7ed1\u5b9a\u6743\u9650\u7c7b\u53ea\u8bfb", (String)"AdjustCheckPermValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkAdjustDimMemPerm(IDynamicObjectModel adjust, List<IDynamicObjectModel> adjustDataList) {
        IDNumberTreeNode mergeTree;
        boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"));
        if (hasMerge && (mergeTree = MemberReader.findEntityMemberById((String)this._ctx().getModelNum(), (Long)adjust.getBaseDataId("entity"))) != IDNumberTreeNode.NotFoundTreeNode && !this.permissionService.hasWritePerm(mergeTree.getDimId(), mergeTree.getId())) {
            this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9[%1$s]%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckPermValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]), mergeTree.getNumber(), this.getPermMsg()));
            return false;
        }
        HashMap<String, Set<Long>> dim2memIdSet = new HashMap<String, Set<Long>>();
        for (Dimension dim : this._ctx().getSctx().getDimensions()) {
            if (hasMerge && "Entity".equals(dim.getNumber())) continue;
            Set<Long> memIdSet = adjustDataList.parallelStream().map(adjustData -> adjustData.getBaseDataId(dim.getFieldmapped())).collect(Collectors.toSet());
            if (this.isSkipOrg && "Entity".equals(dim.getNumber())) {
                dim2memIdSet.put(dim.getNumber(), this.permissionService.matchNoPermMembers(dim.getId(), dim.getEntity(), memIdSet));
                continue;
            }
            if (this.permSign) {
                memIdSet.removeAll(this.permissionService.matchWritePermMembers(dim.getId(), dim.getEntity(), memIdSet));
                dim2memIdSet.put(dim.getNumber(), memIdSet);
                continue;
            }
            dim2memIdSet.put(dim.getNumber(), this.permissionService.matchNoPermMembers(dim.getId(), dim.getEntity(), memIdSet));
        }
        HashSet noPermSet = new HashSet(16);
        adjustDataList.stream().filter(p -> p.getBoolean("isdefaultcurrency")).forEach(adjustData -> {
            for (Dimension dim : this._ctx().getSctx().getDimensions()) {
                long dimMemId;
                if (hasMerge && "Entity".equalsIgnoreCase(dim.getFieldmapped()) || (dimMemId = adjustData.getBaseDataId(dim.getFieldmapped())) == 0L || !dim2memIdSet.getOrDefault(dim.getNumber(), Collections.emptySet()).contains(dimMemId)) continue;
                IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dim.getNumber(), (long)dimMemId);
                noPermSet.add(dim.getName().concat("[").concat(memNode.getNumber()).concat("]"));
            }
            if (!noPermSet.isEmpty()) {
                this.addRowErrorMsg((IDynamicObjectModel)adjustData, String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6%1$s%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckPermValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]), noPermSet, this.getPermMsg()));
                noPermSet.clear();
            }
        });
        return true;
    }

    private String getPermMsg() {
        return this.permSign ? ResManager.loadKDString((String)"\u65e0\u6743\u6216\u8005\u53ea\u8bfb", (String)"AdjustCheckPermValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u6743", (String)"AdjustCheckPermValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]);
    }
}

