/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjConsumer;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DynUtils;

public abstract class AbstractValidator
implements IValidator<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AbstractValidator.class);
    private Boolean isOnlyWarning = false;
    private Long scene = null;
    private Long year = null;
    private Long period = null;
    private AdjustOperationContext ctx;
    private OperationResult validateResult;
    private AdjRecordLog adjLog;
    private List<DynamicObject> adjustDys;
    private Map<Long, List<DynamicObject>> adjustDatas;
    private final Set<Long> errorDetailPkSet = new HashSet<Long>(50);
    private final StringBuilder rowErrorCacher = new StringBuilder();

    @Override
    public void validate() {
        this.startWatch();
        this.beforeValidate();
        this.iterator((singleAdjust, singleAdjustDatas) -> {
            this.validateSingle(singleAdjust, singleAdjustDatas);
            if (this.rowErrorCacher.length() > 0) {
                this.addErrorMessage(singleAdjust, this.rowErrorCacher.toString());
                this.rowErrorCacher.setLength(0);
            }
        });
        this.afterValidate();
        this.endWatch();
    }

    private void initValidateResult(List<DynamicObject> adjustDys) {
        HashSet<Long> successPkId = new HashSet<Long>(adjustDys.size());
        this.getValidateResult().getSuccessPkIds().forEach(succ -> successPkId.add((Long)succ));
        for (DynamicObject dy : adjustDys) {
            successPkId.add(dy.getLong("id"));
        }
        this.getValidateResult().getSuccessPkIds().clear();
        this.getValidateResult().getSuccessPkIds().addAll(successPkId);
    }

    @Override
    public void setCheckData(Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> checkData) {
        this.adjustDys = (List)checkData.p1;
        this.adjustDatas = (Map)checkData.p2;
        if (CollectionUtils.isEmpty(this.adjustDys)) {
            return;
        }
        this.initValidateResult(this.adjustDys);
        DynamicObject adjust = this.adjustDys.get(0);
        this.scene = AdjustmentServiceHelper.transformDimid(adjust, "scenario");
        this.year = AdjustmentServiceHelper.transformDimid(adjust, "year");
        this.period = AdjustmentServiceHelper.transformDimid(adjust, "period");
    }

    protected void beforeValidate() {
    }

    protected abstract void validateSingle(DynamicObject var1, List<DynamicObject> var2);

    protected void afterValidate() {
        HashSet successPkIds = new HashSet(this.getValidateResult().getSuccessPkIds());
        this.getAdjustDys().removeIf(adjustDy -> {
            Long adjId = adjustDy.getLong("id");
            if (successPkIds.contains(adjId)) {
                return false;
            }
            this.getAdjustDatas().remove(adjId);
            return true;
        });
        this.adjustDys = null;
        this.adjustDatas = null;
    }

    protected void iterator(AdjConsumer adjConsumer) {
        this.getAdjustDys().forEach(adjustDy -> adjConsumer.accept((DynamicObject)adjustDy, this.getAdjustDatas().getOrDefault(adjustDy.getLong("id"), Collections.emptyList())));
    }

    protected void addWarningMessage(DynamicObject adjust, String content) {
        this.addMessage(adjust, content, ErrorLevel.Warning);
    }

    protected void addErrorMessage(DynamicObject adjust, String content) {
        if (this.isOnlyWarning().booleanValue()) {
            this.addWarningMessage(adjust, content);
        } else {
            this.addMessage(adjust, content, ErrorLevel.Error);
            this.getValidateResult().getSuccessPkIds().remove(adjust.getLong("id"));
        }
    }

    protected boolean needCheck(DynamicObject rowData) {
        if ("btn_createlinkage".equals(this.getOperationKey()) && EntrySourceEnum.getLinkListToString().contains(rowData.getString("entrysource"))) {
            return false;
        }
        return !"btn_adddiffentry".equals(this.getOperationKey()) || !"2".equals(rowData.getString("entryrowtype"));
    }

    private void startWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.startWatch();
        }
    }

    private void endWatch() {
        if (DebugServiceHelper.isDebugModel()) {
            LOG.infoEnd(String.format("\u6821\u9a8c[%s]\u6267\u884c\u8017\u65f6", this.getValidatorKey()));
        }
    }

    protected void addMessage(DynamicObject adjust, String content, ErrorLevel errorLevel) {
        OperateErrorInfo info = new OperateErrorInfo();
        info.setErrorLevel(errorLevel.name());
        info.setEntityKey(this.getEntityKey());
        info.setTitle(this.getOperationKey());
        info.setMessage(DynUtils.getProperty((DynamicObject)adjust, (String)"number") + ":".concat(content));
        if (ErrorLevel.Warning == errorLevel) {
            this.getAdjLog().addWarningMsg(info.getMessage());
        } else {
            info.setPkValue(DynUtils.getProperty((DynamicObject)adjust, (String)"id"));
            this.getAdjLog().addErrorMsg(info.getMessage());
        }
        this.validateResult.addErrorInfo(info);
    }

    public AdjRecordLog getAdjLog() {
        if (this.adjLog == null) {
            this.adjLog = new AdjRecordLog();
        }
        return this.adjLog;
    }

    protected void addRowErrorMsg(DynamicObject rowData, String content) {
        this.rowErrorCacher.append(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u53f7\u4e3a%1$s\u5e8f\u53f7\u4e3a%2$s\u7684\u660e\u7ec6\u5206\u5f55%3$s", (String)"AbstractValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), DynUtils.getProperty((DynamicObject)rowData, (String)"groupnum"), DynUtils.getProperty((DynamicObject)rowData, (String)"dseq"), content));
        this.errorDetailPkSet.add((Long)DynUtils.getProperty((DynamicObject)rowData, (String)"id"));
    }

    protected boolean isZero(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0;
    }

    @Override
    public void setValidateResult(OperationResult validateResult) {
        this.validateResult = validateResult;
    }

    public OperationResult getValidateResult() {
        return this.validateResult;
    }

    protected String getOperationKey() {
        return (String)this.ctx.getProperty("OperationKey");
    }

    protected String getValidatorKey() {
        return this.getClass().getName();
    }

    public String getEntityKey() {
        return "bcm_rptadjust";
    }

    protected long getModelId() {
        return this.getSctx().getModel();
    }

    protected String getModelNum() {
        return this.getSctx().getModelNumber();
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }

    protected SchemeContext getSctx() {
        return this.getCtx().getSctx();
    }

    @Override
    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    public List<DynamicObject> getAdjustDys() {
        return this.adjustDys;
    }

    public Map<Long, List<DynamicObject>> getAdjustDatas() {
        return this.adjustDatas;
    }

    public Long getScene() {
        return this.scene;
    }

    public Long getYear() {
        return this.year;
    }

    public Long getPeriod() {
        return this.period;
    }

    @Override
    public void setAdjLog(AdjRecordLog adjLog) {
        this.adjLog = adjLog;
    }

    @Override
    public Boolean isOnlyWarning() {
        return this.isOnlyWarning;
    }

    @Override
    public void setOnlyWarning(Boolean onlyWarning) {
        this.isOnlyWarning = onlyWarning;
    }

    protected AdjustOperTypeEnum getOperationType() {
        return this.getCtx().getOperTypeEnum();
    }

    @Override
    public Boolean isContinueValidate(Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>> checkData) {
        if (checkData == null || checkData.p1 == null || ((List)checkData.p1).size() < 1) {
            return false;
        }
        return true;
    }

    public Set<Long> getErrorDetailPkSet() {
        return this.errorDetailPkSet;
    }

    protected <T> T loadFromCache(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        return this.ctx.getUsetObjectFromCache(key, loader);
    }
}

