/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.model.AdjustBalanceCheckModel;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class AdjustBaseInfoCheckValidator
extends AbstractValidator {
    private Map<String, Boolean> nonRepeatNums;
    private boolean isSysToMDD = false;
    private AdjustBalanceCheckService adjustBalanceCheckService;

    public AdjustBaseInfoCheckValidator(boolean isSysToMDD) {
        this.isSysToMDD = isSysToMDD;
    }

    @Override
    protected void beforeValidate() {
        this.nonRepeatNums = this.getAdjustDys().stream().map(e -> e.getString("number")).collect(Collectors.toMap(k -> k, v -> true));
        QFilter qf = new QFilter("model", "=", (Object)this.getCtx().getModelId());
        qf.and("scenario", "=", (Object)this.getCtx().getScenarioId()).and("year", "=", (Object)this.getCtx().getFyId()).and("period", "=", (Object)this.getCtx().getPeriodId());
        qf.and("number", "in", this.nonRepeatNums.keySet());
        List<String> collect = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"number", (QFilter[])qf.toArray()).stream().map(e -> e.getString("number")).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            collect.forEach(e -> this.nonRepeatNums.put((String)e, false));
        }
        this.adjustBalanceCheckService = new AdjustBalanceCheckService(this.getModelId());
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (!this.validateHeadBaseInfo(adjust) || !this.checkPageLayout(adjust)) {
            return;
        }
        if (!RptAdjustStatusEnum.TEMPSAVE.status().equals(adjust.getString("status"))) {
            Map<String, AdjustBalanceCheckModel> res = this.adjustBalanceCheckService.checkAdjustBalance(adjust, adjustDataList);
            for (AdjustBalanceCheckModel checkModel : res.values()) {
                if (checkModel.isDataBalance(this.adjustBalanceCheckService.getConfigBalance())) continue;
                this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u6309\u3010%s\u3011\u5206\u7ec4\u6821\u9a8c\u4e0d\u5e73\u8861", (String)"AdjustBaseInfoCheckValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), checkModel.getGroupKey()));
            }
        }
    }

    private boolean validateHeadBaseInfo(DynamicObject adjustHead) {
        if (StringUtils.isEmpty((CharSequence)adjustHead.getString("name"))) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"AdjustBaseInfoCheckValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        String number = adjustHead.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.addErrorMessage(adjustHead, String.format(ResManager.loadKDString((String)"%s\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AdjustBaseInfoCheckValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]), adjustHead.getString("name").concat(":")));
            return false;
        }
        Boolean isNonRepeatNum = this.nonRepeatNums.remove(number);
        if (isNonRepeatNum == null) {
            this.addErrorMessage(adjustHead, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801%s\u5728\u5f85\u5904\u7406\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u8bb0\u5f55", (String)"AdjustBaseInfoCheckValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), adjustHead.getString("number")));
            return false;
        }
        if (!isNonRepeatNum.booleanValue()) {
            this.addErrorMessage(adjustHead, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801%s\u5728\u5e93\u4e2d\u5df2\u5b58\u5728\u91cd\u590d\u7684\u8bb0\u5f55", (String)"AdjustBaseInfoCheckValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]), adjustHead.getString("number")));
            return false;
        }
        Integer balancetype = adjustHead.getInt("balancetype");
        if (balancetype == null || BalanceTypeEnum.getEnumByIndex((int)balancetype) == null) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u5e73\u8861\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"AdjustBaseInfoCheckValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        String bussnesstype = adjustHead.getString("bussnesstype");
        BusinessTypeEnum businessTypeEnum = BusinessTypeEnum.searchByName((String)bussnesstype);
        if (businessTypeEnum == null) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"AdjustBaseInfoCheckValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.equals((CharSequence)businessTypeEnum.getProcessNumber(), (CharSequence)adjustHead.getString("process"))) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5408\u7b26\u5f55\u5165\u7684\u8fc7\u7a0b", (String)"AdjustBaseInfoCheckValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        AdjustLinkCreateEnum linkcreatetype = AdjustLinkCreateEnum.searchByStatus((String)adjustHead.getString("linkcreatetype"));
        if (linkcreatetype == null) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u8054\u52a8\u751f\u6210\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"AdjustBaseInfoCheckValidator_9", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        RptAdjustStatusEnum statusEnum = RptAdjustStatusEnum.getStatusEnumBy((String)adjustHead.getString("status"));
        if (statusEnum == null) {
            adjustHead.set("status", (Object)RptAdjustStatusEnum.TEMPSAVE.status());
        } else if (statusEnum == RptAdjustStatusEnum.AUDIT && !this.isSysToMDD) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u4e0d\u53ef\u76f4\u63a5\u5ba1\u6838\u5165\u5e93", (String)"AdjustBaseInfoCheckValidator_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (OrgRelaProcessMembPool.isRelaProcess((String)adjustHead.getString("process"))) {
            long entity = adjustHead.getLong("entity");
            if (entity == 0L) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AdjustBaseInfoCheckValidator_11", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            IDNumberTreeNode mergeNode = MemberReader.findEntityMemberById((Long)this.getCtx().getModelId(), (Long)entity);
            if (mergeNode == IDNumberTreeNode.NotFoundTreeNode) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"AdjustBaseInfoCheckValidator_12", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (mergeNode.isLeaf()) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7\u53ea\u80fd\u662f\u975e\u53f6\u5b50\u8282\u70b9", (String)"AdjustBaseInfoCheckValidator_13", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (entity != adjustHead.getLong("belongorg")) {
                adjustHead.set("belongorg", (Object)entity);
            }
            if (adjustHead.getBoolean("multiplecurrency")) {
                Long cvtBeforeCurrency = adjustHead.getLong("cvtbeforecurrency");
                if (cvtBeforeCurrency == null) {
                    this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u5206\u5f55\u591a\u5e01\u79cd\u9700\u8981\u5f55\u5165\u8f93\u5165\u5e01", (String)"AdjustBaseInfoCheckValidator_14", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return false;
                }
                IDNumberTreeNode currcNode = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.getCtx().getModelId()), (Long)cvtBeforeCurrency);
                if (currcNode == IDNumberTreeNode.NotFoundTreeNode) {
                    this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u8f93\u5165\u5e01\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u7b26\u8981\u6c42", (String)"AdjustBaseInfoCheckValidator_15", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkPageLayout(DynamicObject adjustHead) {
        DynamicObjectCollection commembentry = adjustHead.getDynamicObjectCollection("commembentry");
        Map cloneDim = (Map)((HashMap)this.getCtx().getSctx().getDimensionMap()).clone();
        IDNumberTreeNode currencyNode = null;
        for (DynamicObject com : commembentry) {
            Dimension dim = (Dimension)cloneDim.remove(com.getLong("comdimension"));
            if (dim == null) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u901a\u7528\u9875\u9762\u5e03\u5c40\u4e0d\u5b58\u5728\u7ef4\u5ea6\u5217\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_16", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getCtx().getModelId(), (String)dim.getMembermodel(), (Long)com.getLong("commembid"));
            if (memberNode == IDNumberTreeNode.NotFoundTreeNode) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u901a\u7528\u9875\u9762\u5e03\u5c40\u4e0d\u5b58\u5728\u7ef4\u5ea6\u5217\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_17", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!DimTypesEnum.CURRENCY.getNumber().equals(memberNode.getDimNumber())) continue;
            currencyNode = memberNode;
        }
        if (cloneDim.values().stream().anyMatch(e -> DimTypesEnum.YEAR.getNumber().equals(e.getNumber()) || DimTypesEnum.PROCESS.getNumber().equals(e.getNumber()) || DimTypesEnum.PERIOD.getNumber().equals(e.getNumber()) || DimTypesEnum.SCENARIO.getNumber().equals(e.getNumber()))) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u901a\u7528\u9875\u9762\u5e03\u5c40\u4e2d\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\uff0c\u8fc7\u7a0b\u7ef4\u5ea6\u5fc5\u987b\u5728\u901a\u7528\u7ef4\u4e0a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_18", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (currencyNode != null) {
            String currencyNum;
            String string = currencyNum = "RAdj".equals(adjustHead.getString("process")) ? "DC" : "EC";
            if (!currencyNum.equals(currencyNode.getNumber())) {
                this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u901a\u7528\u9875\u9762\u5e03\u5c40\u4e0d\u5b58\u5728\u5e01\u79cd\u7ef4\u5ea6\u6210\u5458\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_19", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
        }
        if (cloneDim.values().stream().filter(e -> DimTypesEnum.ENTITY.getNumber().equals(e.getNumber()) || DimTypesEnum.ACCOUNT.getNumber().equals(e.getNumber())).count() != 2L) {
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u901a\u7528\u9875\u9762\u5e03\u5c40\u7ec4\u7ec7\uff0c\u79d1\u76ee\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u5728\u901a\u7528\u7ef4\u4e0a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection spreadmembentry = adjustHead.getDynamicObjectCollection("spreadmembentry");
        for (DynamicObject spreadDim : spreadmembentry) {
            if (cloneDim.remove(spreadDim.getLong("spreaddimension")) != null) continue;
            this.addErrorMessage(adjustHead, ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u9875\u9762\u5e03\u5c40\u4e0d\u5b58\u5728\u7ef4\u5ea6\u5217\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustBaseInfoCheckValidator_21", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        if (!cloneDim.isEmpty()) {
            this.addErrorMessage(adjustHead, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u9875\u9762\u5e03\u5c40\u7ef4\u5ea6\u5217\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3010%s\u3011\u3002", (String)"AdjustBaseInfoCheckValidator_22", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", cloneDim.values().stream().map(e -> e.getName()).collect(Collectors.toList()))));
            return false;
        }
        return true;
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustBaseInfoCheckValidator";
    }
}

