/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.common.enums.JournalTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustChargeCheckValidator
extends AbstractValidator {
    private List<Long> hasCharged;

    @Override
    protected void beforeValidate() {
        super.beforeValidate();
        if (this.hasCharged == null) {
            this.hasCharged = new ArrayList<Long>(30);
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)this.getModelId());
            qf.add("year", "=", (Object)this.getTarYear());
            qf.add("period", "=", (Object)this.getTarPeriod());
            qf.add("journaltype", "=", (Object)JournalTypeEnum.CHARGE_AGAINST.getKey());
            try (DataSet oldChargeSet = QueryServiceHelper.queryDataSet((String)"AdjustChargeCheckValidator", (String)"bcm_rptadjust", (String)"extend", (QFilter[])qf.toArray(), null);){
                oldChargeSet.forEachRemaining(row -> this.hasCharged.add(row.getLong("extend")));
            }
        }
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (!RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u4ec5\u80fd\u5bf9\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u5206\u5f55\u6267\u884c\u51b2\u9500\u64cd\u4f5c\u3002", (String)"AdjustChargeOperation_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        if (this.hasCharged.contains(adjust.getLong("id"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u4ec5\u80fd\u5bf9\u672a\u51b2\u9500\u8fc7\u7684\u8c03\u6574\u62b5\u9500\u5206\u5f55\uff0c\u6267\u884c\u51b2\u9500\u64cd\u4f5c\u3002", (String)"AdjustChargeOperation_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustChargeCheckValidator";
    }

    protected long getTarYear() {
        return (Long)this.getCtx().getProperty("tarYear");
    }

    protected long getTarPeriod() {
        return (Long)this.getCtx().getProperty("tarPeriod");
    }
}

