/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class AdjustCheckArchiveStatusValidator
extends AbstractValidator {
    private Map<Long, McStatus> mcStatusMap = null;
    private final HashMultimap<Long, Long> adjustId2OrgId = HashMultimap.create();

    @Override
    protected void beforeValidate() {
        HashSet<Long> orgIdSet = new HashSet<Long>(100);
        this.iterator((adjust, adjustDataList) -> {
            boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"));
            adjustDataList.forEach(adjustData -> {
                if (adjustData.getBoolean("isdefaultcurrency")) {
                    Long orgId = 0L;
                    if (hasMerge) {
                        orgId = AdjustmentServiceHelper.transformDimid(adjustData, "merge");
                        if (orgId == null || orgId == 0L) {
                            orgId = AdjustmentServiceHelper.transformDimid(adjustData, "adjust.entity");
                        }
                    } else {
                        orgId = AdjustmentServiceHelper.transformDimid(adjustData, "entity");
                    }
                    if (orgId != null && orgId != 0L) {
                        this.adjustId2OrgId.put((Object)adjust.getLong("id"), (Object)orgId);
                        orgIdSet.add(orgId);
                    }
                }
            });
        });
        this.mcStatusMap = McStatus.batchGetMcStatus(this.getModelId(), orgIdSet, this.getScene(), this.getYear(), this.getPeriod());
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        HashSet isArchiveSet = new HashSet(this.mcStatusMap.size());
        Set orgIdSet = this.adjustId2OrgId.get((Object)adjust.getLong("id"));
        orgIdSet.forEach(orgId -> {
            if (this.mcStatusMap.containsKey(orgId) && this.mcStatusMap.get(orgId).getArchive().isArchive()) {
                IDNumberTreeNode orgTree = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)orgId);
                isArchiveSet.add(orgTree.getNumber());
            }
        });
        if (!isArchiveSet.isEmpty()) {
            this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u7ec4\u7ec7\u5728\u667a\u80fd\u5408\u5e76\u4e2d\u5df2\u5f52\u6863\u3002", (String)"AdjustCheckArchiveStatusValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), ((Object)isArchiveSet).toString()));
        }
    }

    @Override
    protected void afterValidate() {
        super.afterValidate();
        this.mcStatusMap.clear();
        this.adjustId2OrgId.clear();
    }

    @Override
    public Long getScene() {
        return (Long)this.getCtx().getUserObject("tarScene", () -> super.getScene());
    }

    @Override
    public Long getPeriod() {
        return (Long)this.getCtx().getUserObject("tarPeriod", () -> super.getPeriod());
    }

    @Override
    public Long getYear() {
        return (Long)this.getCtx().getUserObject("tarYear", () -> super.getYear());
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckArchiveStatusValidator";
    }
}

