/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustCheckDataNotNullValidator
extends AbstractValidator {
    @Override
    protected void beforeValidate() {
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        adjustDataList.forEach(rowData -> {
            if (this.needCheck((DynamicObject)rowData)) {
                boolean bl = this.checkDimensionMemNotNull((DynamicObject)rowData) && this.checkBigDecimalValNotNull(adjust, (DynamicObject)rowData);
            }
        });
    }

    private boolean checkBigDecimalValNotNull(DynamicObject adjust, DynamicObject rowData) {
        if (AdjustEntryRowTypeEnum.RATE_DIFF.getValue().intValue() == rowData.getInt("entryrowtype")) {
            return true;
        }
        boolean isMutiCurrency = adjust.getBoolean("multiplecurrency");
        boolean isDValueEmpty = this.isZero(rowData.getBigDecimal("debit"));
        boolean isCValueEmpty = this.isZero(rowData.getBigDecimal("credit"));
        boolean isSumValueEmpty = this.isZero(rowData.getBigDecimal("summoney"));
        boolean isNotEmpty = isDValueEmpty ^ isCValueEmpty && !isSumValueEmpty;
        boolean isAllEmpty = isDValueEmpty && isCValueEmpty && isSumValueEmpty;
        boolean isUse = Boolean.TRUE;
        if (isMutiCurrency) {
            boolean isRateValueEmpty = this.isZero(rowData.getBigDecimal("rate"));
            boolean isCvtBefDValueEmpty = this.isZero(rowData.getBigDecimal("cvtbeforedebit"));
            boolean isCvtBefCValueEmpty = this.isZero(rowData.getBigDecimal("cvtbeforecredit"));
            boolean isCvtBefSumValueEmpty = this.isZero(rowData.getBigDecimal("cvtbeforesummoney"));
            boolean cvtBeforeNotEmpty = isCvtBefCValueEmpty ^ isCvtBefDValueEmpty && !isCvtBefSumValueEmpty;
            boolean cvtBeforeAllEmpty = isCvtBefCValueEmpty && isCvtBefDValueEmpty && isCvtBefSumValueEmpty;
            isUse = !(cvtBeforeAllEmpty && isNotEmpty || cvtBeforeNotEmpty && isNotEmpty && isRateValueEmpty);
        } else {
            boolean bl = isUse = isNotEmpty || isAllEmpty;
        }
        if (!isUse) {
            this.addRowErrorMsg(rowData, ResManager.loadKDString((String)"\u91d1\u989d\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDataNotNullValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return isUse;
    }

    private boolean checkDimensionMemNotNull(DynamicObject rowData) {
        if (rowData.getBoolean("isdefaultcurrency")) {
            HashSet<String> emptyDimensionSet = new HashSet<String>(16);
            for (Dimension dim : this.getSctx().getDimensions()) {
                IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)dim.getNumber(), (long)DynUtils.getBaseId((DynamicObject)rowData, (String)dim.getFieldmapped()));
                if (IDNumberTreeNode.NotFoundTreeNode != memNode && memNode.getParent() != null) continue;
                emptyDimensionSet.add(dim.getName());
            }
            if (!emptyDimensionSet.isEmpty()) {
                this.addRowErrorMsg(rowData, String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u7ef4\u5ea6\u201c%s\u201d\u6210\u5458\u662f\u5426\u4e3a\u7a7a\u3002", (String)"AdjustCheckDataNotNullValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), emptyDimensionSet));
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckDataNotNullValidator";
    }
}

