/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;

public class AdjustCheckDataSysToMDDValidator
extends AbstractValidator {
    public static final List<String> submitProcessList = Arrays.asList("ADJ", "ARPT", "CADJ", "PRPT", "EJE", "CC", "CCADJ", "CCTotal");
    private final HashMultimap<Long, Long> adjustId2OrgId = HashMultimap.create();
    private final Map<Long, String> orgMap = new HashMap<Long, String>(100);
    private Set<String> periodStatusOpenOrgNum;
    private Map<Long, McStatus> org2MC;

    @Override
    protected void beforeValidate() {
        this.iterator((adjust, adjustDataList) -> {
            boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"));
            adjustDataList.forEach(adjustData -> {
                if (adjustData.getBoolean("isdefaultcurrency")) {
                    IDNumberTreeNode node;
                    Long orgId = 0L;
                    if (hasMerge) {
                        orgId = AdjustmentServiceHelper.transformDimid(adjustData, "merge");
                        if (orgId == null || orgId == 0L) {
                            orgId = AdjustmentServiceHelper.transformDimid(adjustData, "adjust.entity");
                        }
                    } else {
                        orgId = AdjustmentServiceHelper.transformDimid(adjustData, "entity");
                    }
                    if (!IDNumberTreeNode.NotFoundTreeNode.equals(node = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"Entity", (long)orgId))) {
                        this.adjustId2OrgId.put((Object)adjust.getLong("id"), (Object)orgId);
                        this.orgMap.put(orgId, node.getNumber());
                    }
                }
            });
        });
        if (ConfigServiceHelper.getBoolParam(this.getModelId(), "CM012")) {
            this.periodStatusOpenOrgNum = PeriodSettingHelper.batchSelectPeriodStatusOpen(this.getModelId(), new HashSet<String>(this.orgMap.values()), this.getScene(), this.getYear(), this.getPeriod(), "entrystatus");
        }
        this.org2MC = McStatus.batchGetMcStatus(this.getModelId(), this.orgMap.keySet(), this.getScene(), this.getYear(), this.getPeriod());
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (AdjustOperTypeEnum.BACKOPERATION == this.getCtx().getOperTypeEnum() && !RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
            return;
        }
        if (!this.checkPeriodStatus(adjust)) {
            return;
        }
        if (!this.checkFlowStatus(adjust)) {
            return;
        }
    }

    private boolean checkPeriodStatus(DynamicObject adjust) {
        if (this.periodStatusOpenOrgNum != null) {
            Set orgIdSet = this.adjustId2OrgId.get((Object)adjust.getLong("id"));
            Set periodStatusColsed = orgIdSet.stream().filter(orgId -> !this.periodStatusOpenOrgNum.contains(this.orgMap.get(orgId))).map(this.orgMap::get).collect(Collectors.toSet());
            if (!periodStatusColsed.isEmpty()) {
                this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u5f53\u524d%s\u7ec4\u7ec7\u8c03\u6574\u5206\u5f55\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckDataSysToMDDValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]), periodStatusColsed));
                return false;
            }
        }
        return true;
    }

    private boolean checkFlowStatus(DynamicObject adjust) {
        String process = adjust.getString("process");
        Set orgIdSet = this.adjustId2OrgId.get((Object)adjust.getLong("id"));
        HashSet flowNoCheckSet = new HashSet(this.org2MC.size());
        orgIdSet.forEach(orgId -> {
            McStatus mcstatus = this.org2MC.get(orgId);
            IDNumberTreeNode orgTree = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)orgId);
            if (mcstatus != null && mcstatus.getFlow().isSubmit()) {
                if ("RAdj".equals(process)) {
                    if (mcstatus.getPcFlow().isSubmit()) {
                        flowNoCheckSet.add(orgTree.getNumber() + "[" + orgTree.getName() + "]");
                    }
                } else if (mcstatus.getFlow().isSubmit()) {
                    flowNoCheckSet.add(orgTree.getNumber() + "[" + orgTree.getName() + "]");
                }
            }
        });
        if (!flowNoCheckSet.isEmpty()) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u72b6\u6001\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckDataSysToMDDValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void afterValidate() {
        super.afterValidate();
        this.adjustId2OrgId.clear();
        this.orgMap.clear();
        this.periodStatusOpenOrgNum = null;
        this.org2MC = null;
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckDataSysToMDDValidator";
    }
}

