/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustCheckDimMemValidator
extends AbstractValidator {
    @Override
    protected void beforeValidate() {
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        String modelNum = this.getModelNum();
        List<Dimension> dimensions = this.getCtx().getSctx().getDimensions();
        String process = (String)DynUtils.getProperty((DynamicObject)adjust, (String)"process");
        boolean relaProcess = OrgRelaProcessMembPool.isRelaProcess((String)process);
        adjustDataList.forEach(rowData -> {
            if (rowData.getBoolean("isdefaultcurrency") && this.needCheck((DynamicObject)rowData)) {
                for (Dimension dim : dimensions) {
                    Long memberId = AdjustmentServiceHelper.transformDimid(rowData, dim.getFieldmapped());
                    IDNumberTreeNode dimTree = BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)memberId);
                    if (dimTree == null || IDNumberTreeNode.NotFoundTreeNode.equals(dimTree)) continue;
                    if (StorageTypeEnum.LABEL == dimTree.getStorageType()) {
                        this.addRowErrorMsg((DynamicObject)rowData, String.format(AdjustCheckDimMemValidator.labelTextMessage(), dim.getName()));
                        continue;
                    }
                    if ("Entity".equals(dim.getNumber())) {
                        if (dimTree.isLeaf() && ("DADJ".equals(process) || "DEJE".equals(process))) {
                            this.addRowErrorMsg((DynamicObject)rowData, ResManager.loadKDString((String)"DADJ\u548cDEJE\u4e1a\u52a1\u7c7b\u578b\u4e0b\u4e0d\u80fd\u5b58\u5728\u660e\u7ec6\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                            continue;
                        }
                    } else if (!dimTree.isLeaf()) {
                        this.addRowErrorMsg((DynamicObject)rowData, String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e0d\u80fd\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff1a%2$s", (String)"AdjustCheckDimMemValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), dimTree.getName()));
                        continue;
                    }
                    if ("Entity".equals(dim.getNumber())) {
                        if (!relaProcess) continue;
                        Long mergeId = DynUtils.getBaseId((DynamicObject)rowData, (String)"merge");
                        IDNumberTreeNode mergeTree = BcmThreadCache.findNodeById((String)modelNum, (String)dim.getNumber(), (long)mergeId);
                        if (mergeTree == null || IDNumberTreeNode.NotFoundTreeNode.equals(mergeTree) || dimTree.getLongNumber().contains("!" + mergeTree.getNumber() + "!")) continue;
                        this.addRowErrorMsg((DynamicObject)rowData, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u548c\u5408\u5e76\u8282\u70b9\u4e0d\u5339\u914d,\u5176\u4e2d\u660e\u7ec6\u5206\u5f55\u7ec4\u7ec7\u4e3a%1$s,\u5408\u5e76\u8282\u70b9\u7ec4\u7ec7\u4e3a%2$s\u3002", (String)"AdjustCheckDimMemValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), rowData.getString("entity.longnumber"), rowData.getString("entity.longnumber")));
                        continue;
                    }
                    if ("Account".equals(dim.getNumber())) {
                        if (Boolean.TRUE.equals(ObjectConverter.convert((Object)dimTree.getProperty("iscaltype"), Boolean.class, (boolean)false))) {
                            this.addRowErrorMsg((DynamicObject)rowData, AdjustCheckDimMemValidator.calAcctTextMessage());
                            continue;
                        }
                        DataTypeEnum accountType = DataTypeEnum.getDataTypeEnumByIndex((String)((String)dimTree.getProperty("datatype")));
                        if (DataTypeEnum.TXT == accountType || DataTypeEnum.DATETP == accountType || DataTypeEnum.ENUMTP == accountType) {
                            this.addRowErrorMsg((DynamicObject)rowData, String.format(ResManager.loadKDString((String)"%1$s\u662f%2$s\u6210\u5458\uff0c\u4e0d\u53ef\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCopyOperation_3", (String)"fi-bcm-business", (Object[])new Object[0]), dimTree.getNumber(), accountType.getName()));
                            continue;
                        }
                        if (!DrCRDirectEnum.NONE.getOIndex().equals(dimTree.getProperty("drcrdirect"))) continue;
                        this.addRowErrorMsg((DynamicObject)rowData, AdjustCheckDimMemValidator.acctDirectTextmessage());
                        continue;
                    }
                    if (!"MyCompany".equals(dim.getNumber()) || !SystemVarsEnum.isDimVars((String)dimTree.getNumber())) continue;
                    this.addRowErrorMsg((DynamicObject)rowData, AdjustCheckDimMemValidator.varTestMessage());
                }
            }
        });
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckDimMemValidator";
    }

    public static String acctDirectTextmessage() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u79d1\u76ee\u662f\u5426\u5b58\u5728\u501f\u8d37\u7b97\u6cd5\u3002", (String)"AdjustCheckDimMemValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String calAcctTextMessage() {
        return ResManager.loadKDString((String)"\u5305\u542b\u8ba1\u7b97\u7c7b\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String labelTextMessage() {
        return ResManager.loadKDString((String)"%s\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String varTestMessage() {
        return ResManager.loadKDString((String)"%s\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustCheckDimMemValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]);
    }
}

