/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustCheckOlapLockValidator
extends AbstractValidator {
    private boolean isCheckByLinkId = false;
    private boolean isCheck = false;
    private boolean isExistArchiving;
    private Map<Long, HashBasedTable<Long, Long, List<String>>> lockedMemKeySet = null;

    public AdjustCheckOlapLockValidator setCheck(boolean check) {
        this.isCheck = check;
        return this;
    }

    public AdjustCheckOlapLockValidator setCheckByLinkId(boolean checkByLinkId) {
        this.isCheckByLinkId = checkByLinkId;
        return this;
    }

    @Override
    protected void beforeValidate() {
        super.beforeValidate();
        this.isExistArchiving = LockScopeServiceHelper.isExistArchiving(this.getCtx().getModelId(), this.getCtx().getScenariodNum(), this.getCtx().getFyNum(), this.getCtx().getPeriodNum());
        if (this.isExistArchiving) {
            return;
        }
        if (this.isCheckByLinkId) {
            this.lockedMemKeySet = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds("AdjustCheckOlapLockValidator." + (this.getOperationType() == null ? "from api" : this.getOperationType().getName()), this.getCtx(), this.getAdjustDys().parallelStream().map(p -> p.getLong("id")).collect(Collectors.toSet()), null);
        } else {
            this.lockedMemKeySet = new HashMap<Long, HashBasedTable<Long, Long, List<String>>>(this.getAdjustDys().size());
            ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>(16);
            this.getAdjustDatas().values().forEach(entryList::addAll);
            AdjustOperationHelper.batchCheckOlapDataLock("AdjustCheckOlapLockValidator." + (this.getOperationType() == null ? "from api" : this.getOperationType().getName()), this.getCtx(), entryList, null).cellSet().forEach(cell -> this.lockedMemKeySet.computeIfAbsent((Long)cell.getRowKey(), a -> HashBasedTable.create()).put(cell.getRowKey(), cell.getColumnKey(), cell.getValue()));
        }
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (this.isCheck || this.getOperationType() == AdjustOperTypeEnum.AUDITOPERATION || this.getOperationType() == AdjustOperTypeEnum.AUTOAUDITOPERATION || this.getOperationType() == AdjustOperTypeEnum.BACKOPERATION && RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
            if (this.isExistArchiving) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u56e0\u4e3a\u5f53\u671f\u671f\u95f4\u5206\u9636\u6bb5\u65b9\u6848\u5df2\u5f52\u6863\u3002", (String)"AdjustCheckDataSysToMDDValidator_10", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            long pkId = adjust.getLong("id");
            if (this.lockedMemKeySet != null && this.lockedMemKeySet.containsKey(pkId)) {
                long belongOrg = DynUtils.getBaseId((String)this.getValidatorKey(), (DynamicObject)adjust, (String)"belongorg");
                HashBasedTable<Long, Long, List<String>> lockedMemTable = this.lockedMemKeySet.get(pkId);
                if (lockedMemTable.containsRow((Object)pkId)) {
                    this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5b58\u5728\u5206\u9636\u6bb5\u9501\u5b9a%2$s\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckOlapLockValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]), BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"Entity", (long)belongOrg).getNumber(), lockedMemTable.row((Object)pkId).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                } else {
                    this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u5171\u4eab\u5206\u5f55\u5b58\u5728\u5206\u9636\u6bb5\u9501\u5b9a%1$s\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdjustCheckOlapLockValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]), lockedMemTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
                }
            }
        }
    }
}

