/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;

public class AdjustCheckOperPersonValidator
extends AbstractValidator {
    private boolean isNeedCheck;
    private final AdjustOperTypeEnum operTypeEnum;

    public AdjustCheckOperPersonValidator(AdjustOperTypeEnum operTypeEnum) {
        this.operTypeEnum = operTypeEnum;
    }

    @Override
    protected void beforeValidate() {
        super.beforeValidate();
        this.isNeedCheck = !MemberPermHelper.getLimitedModelListByUser().contains(this.getModelId()) && ConfigServiceHelper.getBoolParam(this.getModelId(), "CM038") && (AdjustOperTypeEnum.BACKOPERATION == this.operTypeEnum || AdjustOperTypeEnum.AUDITOPERATION == this.operTypeEnum || AdjustOperTypeEnum.AUTOAUDITOPERATION == this.operTypeEnum);
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (this.isNeedCheck) {
            if (AdjustOperTypeEnum.AUTOAUDITOPERATION == this.operTypeEnum && !RptAdjustStatusEnum.COMMIT.status().equals(adjust.getString("status"))) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"CM038\u53c2\u6570\u5df2\u5f00\u542f\uff0c\u5206\u5f55\u63d0\u4ea4\u4eba\u4e0e\u5ba1\u6838\u4eba\u53ca\u6253\u56de\u4eba\u4e0d\u53ef\u76f8\u540c\u3002", (String)"AdjustCheckOperPersonValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            Long submitter = AdjustmentServiceHelper.transformDimid(adjust, "submitter");
            Long currUserId = RequestContext.getOrCreate().getCurrUserId();
            if (submitter != null && submitter != 0L && currUserId.equals(submitter)) {
                if (AdjustOperTypeEnum.BACKOPERATION == this.operTypeEnum && RptAdjustStatusEnum.COMMIT.status().equals(adjust.getString("status"))) {
                    return;
                }
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"CM038\u53c2\u6570\u5df2\u5f00\u542f\uff0c\u5206\u5f55\u63d0\u4ea4\u4eba\u4e0e\u5ba1\u6838\u4eba\u53ca\u6253\u56de\u4eba\u4e0d\u53ef\u76f8\u540c\u3002", (String)"AdjustCheckOperPersonValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckOperPersonValidator";
    }
}

