/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.util.DynUtils;

public class AdjustCheckRelativeDataValidator
extends AbstractValidator {
    private Map<Long, Boolean> checkSourceAdjustResult;

    @Override
    protected void beforeValidate() {
        super.beforeValidate();
        List<DynamicObject> notSourceAdjustList = this.getAdjustDys().stream().filter(this::isNotSource).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notSourceAdjustList)) {
            this.checkSourceAdjustResult = AdjustmentServiceHelper.batchCheckSourceAdjust(notSourceAdjustList, RptAdjustStatusEnum.AUDIT, new OperationResult());
        }
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (this.checkShareAdjust(adjust) && this.checkLinkAdjust(adjust)) {
            this.checkAutoAdjust(adjust, adjustDataList);
        }
    }

    private boolean checkAutoAdjust(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        String sourceType = (String)DynUtils.getProperty((DynamicObject)adjust, (String)"sourcetype");
        if (StringUtils.isEmpty((String)sourceType) || ElimRptAdjSourceTypeEnum.AUTO.getValue() == Integer.parseInt(sourceType)) {
            Optional<Integer> first = adjustDataList.stream().map(row -> Integer.parseInt((String)DynUtils.getProperty((DynamicObject)row, (String)"entrysource"))).filter(entrysource -> !this.getCtx().checkCanOperAutoElim((int)entrysource)).findFirst();
            if (first.isPresent()) {
                if (EntrySourceEnum.RULECREATE.getValue() == first.get().intValue()) {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u4e0d\u53ef\u64cd\u4f5c\u89c4\u5219\u751f\u6210\u7684\u5206\u5f55\u3002", (String)"AdjustFlowStatusValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                } else {
                    this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u5f55\u662f\u4e0d\u53ef\u4fee\u6539\u7684\uff0c\u8bf7\u542f\u7528\u4f53\u7cfb\u53c2\u6570\u201cCM003\u201d\u540e\uff0c\u518d\u6253\u56de\u3002", (String)"AdjustSaveOperation_21", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                return false;
            }
        } else if (ElimRptAdjSourceTypeEnum.SHEETINV.getValue() == Integer.parseInt(sourceType) && !ConfigServiceHelper.getBoolChildParam(this.getModelId(), "CM003", ChildConfigEnum.INVAUTOCREATE.getBusinesstypevalue())) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u5f55\u662f\u4e0d\u53ef\u4fee\u6539\u7684\uff0c\u8bf7\u542f\u7528\u4f53\u7cfb\u53c2\u6570\u201cCM003\u201d\u540e\uff0c\u518d\u6253\u56de\u3002", (String)"AdjustSaveOperation_21", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkShareAdjust(DynamicObject adjust) {
        boolean isShare;
        boolean bl = isShare = ElimRptAdjSourceTypeEnum.SHARE.getValue() == adjust.getInt("sourcetype") || ElimHeaderSourceEnum.SHARE.getValue().equals(adjust.getString("entrysource")) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(adjust.getString("entrysource"));
        if (!AdjustOperTypeEnum.BACKOPERATION.getOperation().equals(this.getOperationKey()) && isShare) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u6765\u6e90\u5206\u7c7b\u662f\u5171\u4eab\u7684\u8c03\u6574\u62b5\u9500\u5206\u5f55\u4ec5\u652f\u6301\u201c\u6253\u56de\u201d\u3002", (String)"AdjustSaveOperation_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkLinkAdjust(DynamicObject adjust) {
        if (this.isNotSource(adjust) && !this.checkSourceAdjustResult.getOrDefault(adjust.getLong("id"), Boolean.TRUE).booleanValue()) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5f53\u524d\u8054\u52a8\u5206\u5f55\u6240\u5c5e\u6e90\u5206\u5f55\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002", (String)"AdjustFlowStatusValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isNotSource(DynamicObject adjust) {
        return ElimRptAdjSourceTypeEnum.LINK.getValue() == adjust.getInt("sourcetype");
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustCheckRelativeDataValidator";
    }
}

