/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;

public class AdjustFlowStatusValidator
extends AbstractValidator {
    private final List<RptAdjustStatusEnum> advancedStatus = new ArrayList<RptAdjustStatusEnum>();

    @Override
    protected void beforeValidate() {
        switch (this.getOperationType()) {
            case SAVEOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.SAVE);
                this.advancedStatus.add(RptAdjustStatusEnum.TEMPSAVE);
                this.advancedStatus.add(RptAdjustStatusEnum.BACK);
                break;
            }
            case COMITOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.SAVE);
                this.advancedStatus.add(RptAdjustStatusEnum.BACK);
                break;
            }
            case RATIFYOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.COMMIT);
                break;
            }
            case BACKOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.AUDIT);
                if (ConfigServiceHelper.isHwApp()) break;
                this.advancedStatus.add(RptAdjustStatusEnum.COMMIT);
                break;
            }
            case AUDITOPERATION: {
                this.advancedStatus.add(ConfigServiceHelper.isHwApp() ? RptAdjustStatusEnum.RATIFY : RptAdjustStatusEnum.COMMIT);
                break;
            }
            case CANCELCOMITOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.COMMIT);
                break;
            }
            case CANCELRATIFYOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.RATIFY);
                break;
            }
            case AUTOAUDITOPERATION: {
                this.advancedStatus.add(RptAdjustStatusEnum.SAVE);
                this.advancedStatus.add(RptAdjustStatusEnum.TEMPSAVE);
                this.advancedStatus.add(RptAdjustStatusEnum.BACK);
                this.advancedStatus.add(RptAdjustStatusEnum.COMMIT);
                break;
            }
        }
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        RptAdjustStatusEnum currentStatus = RptAdjustStatusEnum.getStatusEnumBy((String)adjust.getString("status"));
        if (!this.advancedStatus.contains(currentStatus)) {
            this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u53ea\u6709%1$s\u72b6\u6001\u7684\u5206\u5f55\u652f\u6301%2$s\u64cd\u4f5c\u3002", (String)"AdjustFlowOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.advancedStatus, this.getOperationType().getName()));
        }
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustFlowStatusValidator";
    }
}

