/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.DynamicValidator;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustShareCheckValidator
extends AbstractValidator {
    private String yearNum;
    private Long selectorgid = 0L;
    private Map<Long, DynamicObjectCollection> orgid2treeCollectionMapping = Maps.newHashMap();
    Map<Long, DynamicObject> shareOrgMap;

    @Override
    protected void beforeValidate() {
        if (this.getSelectOrgId() != null) {
            this.selectorgid = this.getSelectOrgId();
        }
        this.yearNum = this.getAdjustDys().get(0).getString("year.number");
        this.initShareOrgToDyMap();
    }

    private static boolean needChangeEntryOrg(DynamicObject oldHeaderDyn) {
        return BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName().equals(oldHeaderDyn.getString("bussnesstype")) || BusinessTypeEnum.ADJUSTSELFLEVEL.getName().equals(oldHeaderDyn.getString("bussnesstype")) || BusinessTypeEnum.ADJUSTCROSSLEVEL.getName().equals(oldHeaderDyn.getString("bussnesstype")) || BusinessTypeEnum.OFFSETSELFLEVEL.getName().equals(oldHeaderDyn.getString("bussnesstype")) || BusinessTypeEnum.EADJ.getName().equals(oldHeaderDyn.getString("bussnesstype")) || BusinessTypeEnum.RADJ.getName().equals(oldHeaderDyn.getString("bussnesstype"));
    }

    private void initShareOrgToDyMap() {
        Collection shareOrgIds = this.commonSettingOrgs().values();
        QFilter qFilter = new QFilter("id", "in", (Object)shareOrgIds);
        DynamicObjectCollection shareOrgDyList = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,longnumber", (QFilter[])qFilter.toArray());
        this.shareOrgMap = shareOrgDyList.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    private DynamicObjectCollection getAllVersionOrgCollection2(DynamicObject shareOrgEntity) {
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of("model", this.getModelId());
        param.setNeedSchemeFilter(false);
        param.setPeriodId(this.getPeriod().toString());
        param.setYearNum(this.yearNum);
        param.setSceneId(String.valueOf(this.getScene()));
        QFBuilder builder = new QFBuilder();
        builder.add("longnumber", "like", (Object)(shareOrgEntity.getString("longnumber") + "!%"));
        param.setBuilder(builder);
        DynamicObjectCollection queryResult = param.getOrgDynamicObjectCollection();
        return queryResult;
    }

    private Boolean validateShareContainsEntryOrgs2(DynamicObject entryOrg, DynamicObject shareOrg) {
        long shareOrgId = shareOrg.getLong("id");
        DynamicObjectCollection orgCollection = this.orgid2treeCollectionMapping.get(shareOrgId);
        if (orgCollection == null) {
            orgCollection = this.getAllVersionOrgCollection2(shareOrg);
            this.orgid2treeCollectionMapping.put(shareOrgId, orgCollection);
        }
        String entryOrgNum = entryOrg.getString("number");
        for (DynamicObject org : orgCollection) {
            if (!org.getString("number").equals(entryOrgNum)) continue;
            return true;
        }
        return false;
    }

    private boolean checkGroupNum(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        if (AdjustShareCheckValidator.needChangeEntryOrg(adjust)) {
            return true;
        }
        Collection tempShareOrgIds = this.commonSettingOrgs().get((Object)adjust.getLong("id"));
        if (tempShareOrgIds != null && tempShareOrgIds.size() > 0) {
            boolean b = tempShareOrgIds.stream().allMatch(shareOrgId -> {
                DynamicObject shareOrgEntity = this.shareOrgMap.get(shareOrgId);
                return adjustDataList.stream().allMatch(adjustData -> {
                    DynamicObject entryOrg = adjustData.getDynamicObject("entity");
                    return this.validateShareContainsEntryOrgs2(entryOrg, shareOrgEntity);
                });
            });
            if (b) {
                return true;
            }
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\u5206\u7ec4", (String)"AdjustShareCheckValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return false;
    }

    @Override
    protected void validateSingle(DynamicObject adjust, List<DynamicObject> adjustDataList) {
        IDNumberTreeNode tarNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)this.selectorgid);
        if (IDNumberTreeNode.NotFoundTreeNode == tarNode) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"AdjustShareCheckValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        if (ElimRptAdjSourceTypeEnum.LINK.getValue() == adjust.getInt("sourcetype")) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5206\u5f55\u4e3a\u8054\u52a8\u5206\u5f55\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustCreateLinkageOperation_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        Long sceneId = DynUtils.getBaseId((DynamicObject)adjust, (String)"scenario");
        Long yearId = DynUtils.getBaseId((DynamicObject)adjust, (String)"year");
        Long periodId = DynUtils.getBaseId((DynamicObject)adjust, (String)"period");
        if (MergeControlHelper.isQuoteLocked(this.getModelId(), this.getScene(), yearId, periodId, tarNode.getId())) {
            this.addErrorMessage(adjust, AdjustSceneVersionValidator.packErrorMsg(tarNode.getNumber(), MemberReader.findFyMemberById((Long)this.getModelId(), (Long)yearId).getNumber(), MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)periodId).getNumber()));
            return;
        }
        if (!adjust.getBoolean("multiplecurrency") && this.selectorgid != null) {
            long srcOrgId = OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process")) ? adjust.getLong("entity.id") : adjustDataList.get(0).getLong("entity.id");
            IDNumberTreeNode srcNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)srcOrgId);
            if (IDNumberTreeNode.NotFoundTreeNode == srcNode) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5206\u5f55\u6240\u5c5e\u7ec4\u7ec7\u3002", (String)"AdjustShareCheckValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            String srcCurrency = srcNode.getCurrency();
            String tarCurrency = tarNode.getCurrency();
            if (srcCurrency == null || tarCurrency == null) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u5e01\u3002", (String)"AdjustShareCheckValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            String process = adjust.getString("process");
            if ("RAdj".equals(process)) {
                if (!srcNode.getParent().getNumber().equals("Entity")) {
                    srcCurrency = srcNode.getParent().getCurrency();
                }
                if (!tarNode.getParent().getNumber().equals("Entity")) {
                    tarCurrency = tarNode.getParent().getCurrency();
                }
            }
            if (!srcCurrency.equals(tarCurrency)) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u7684\u5e01\u79cd\u4e0e\u88ab\u5171\u4eab\u7ec4\u7ec7\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"AdjustShareCheckValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            if (tarNode.isLeaf() && ("DEJE".equals(process) || "DADJ".equals(process))) {
                this.addErrorMessage(adjust, ResManager.loadKDString((String)"DADJ\u548cDEJE\u53ea\u80fd\u5728\u5408\u5e76\u8282\u70b9\u4e4b\u95f4\u8fdb\u884c\u5171\u4eab\u3002", (String)"AdjustShareCheckValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
        }
        if (!RptAdjustStatusEnum.AUDIT.status().equals(adjust.getString("status"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5171\u4eab\u5ba1\u6838\u72b6\u6001\u7684\u8c03\u6574\u62b5\u9500\u3002", (String)"AdjustShareCheckValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        if (ElimHeaderSourceEnum.SHARE.getValue().equals(adjust.getString("entrysource")) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(adjust.getString("entrysource"))) {
            this.addErrorMessage(adjust, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6e90\u8c03\u6574\u62b5\u9500\u8fdb\u884c\u5171\u4eab\u64cd\u4f5c\u3002", (String)"AdjustShareCheckValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        if (!OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"))) {
            for (DynamicObject e : adjust.getDynamicObjectCollection("commembentry")) {
                if (!DimTypesEnum.MYCOMPANY.getNumber().equals(e.getString("comdimension.number"))) continue;
                long commembid = e.getLong("commembid");
                if (commembid == 0L) break;
                IDNumberTreeNode node = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_mycompanymembertree", (Long)commembid);
                if (!SystemVarsEnum.RELATE_ENTITY.getNumber().equals(node.getNumber())) break;
                IDNumberTreeNode mc = MemberReader.findMemberByNumber((String)this.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)tarNode.getNumber());
                if (mc == IDNumberTreeNode.NotFoundTreeNode) {
                    this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u89e3\u6790\u627e\u4e0d\u5230\u6307\u5b9a\u6210\u5458%s\u3002", (String)"AdjustShareCheckValidator_9", (String)"fi-bcm-business", (Object[])new Object[0]), tarNode.getNumber()));
                    return;
                }
                if (StorageTypeEnum.LABEL != mc.getStorageType()) break;
                this.addErrorMessage(adjust, String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u7f16\u7801%s \u4e0d\u80fd\u4e3a\u6807\u7b7e\u7c7b\u3002", (String)"AdjustShareCheckValidator_10", (String)"fi-bcm-business", (Object[])new Object[0]), tarNode.getNumber()));
                return;
            }
        }
        this.checkGroupNum(adjust, adjustDataList);
    }

    @Override
    protected String getValidatorKey() {
        return "AdjustShareCheckValidator";
    }

    private Long getSelectOrgId() {
        Object selectorgid = this.getCtx().getProperty("selectorgid");
        return LongUtil.toLong(selectorgid);
    }

    private Multimap<Long, Long> commonSettingOrgs() {
        return (Multimap)this.getCtx().getProperty("commonSettingOrgs");
    }
}

