/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.TemplateModelValidator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.model.CommonAdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.CommonTemplateEntry;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.DebugLogCollector;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataSysToMDDValidator;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.LongUtil;

public class CommonAdjustTemplateModelValidator
implements IValidator<List<CommonAdjustTemplateModel>> {
    private AdjustOperationContext ctx;
    private List<CommonAdjustTemplateModel> checkDataList;
    private final Map<Long, String> orgIdMap = new HashMap<Long, String>(100);
    private Map<Long, McStatus> mcStatusMap = null;
    private Set<String> periodStatusOpenOrgNum;
    private Map<Long, McStatus> org2MC;
    private final DebugLogCollector debugLogCollector;

    public CommonAdjustTemplateModelValidator(DebugLogCollector debugLogCollector) {
        this.debugLogCollector = debugLogCollector;
    }

    private void addLog(String tmpNum, String logInfo) {
        if (this.debugLogCollector != null) {
            this.debugLogCollector.addDebugLog(tmpNum, logInfo);
        }
    }

    private void beforeValidate() {
        this.checkDataList.forEach(tmp -> {
            if (OrgRelaProcessMembPool.isRelaProcess((String)tmp.getProcess())) {
                this.orgIdMap.put(tmp.getMergeNode().getId(), tmp.getMergeNode().getNumber());
            } else {
                tmp.getOrgScope().forEach(org -> this.orgIdMap.put((Long)org, MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)org).getNumber()));
            }
        });
        this.mcStatusMap = McStatus.batchGetMcStatus(this.ctx.getModelId(), this.orgIdMap.keySet(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
        if (ConfigServiceHelper.getBoolParam(this.ctx.getModelId(), "CM012")) {
            this.periodStatusOpenOrgNum = PeriodSettingHelper.batchSelectPeriodStatusOpen(this.ctx.getModelId(), new HashSet<String>(this.orgIdMap.values()), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), "entrystatus");
        }
        this.org2MC = McStatus.batchGetMcStatus(this.ctx.getModelId(), this.orgIdMap.keySet(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
    }

    @Override
    public void validate() {
        if (CollectionUtils.isEmpty(this.checkDataList)) {
            return;
        }
        this.beforeValidate();
        this.checkDataList.removeIf(tmp -> {
            if (!this.checkTemplateModel((CommonAdjustTemplateModel)tmp)) {
                return true;
            }
            tmp.getEntries().removeIf(entry -> !this.checkTemplateEntry((CommonAdjustTemplateModel)tmp, (CommonTemplateEntry)entry));
            if (tmp.getEntries().isEmpty()) {
                this.addLog(tmp.getNumber(), ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u7528\u7684\u8c03\u6574\u62b5\u6d88\u5206\u5f55\u3002", (String)"CommonAdjustTemplateModelValidator_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                return true;
            }
            return false;
        });
        this.afterValidate();
    }

    private boolean checkTemplateModel(CommonAdjustTemplateModel tmp) {
        boolean hasMerge = OrgRelaProcessMembPool.isRelaProcess((String)tmp.getProcess());
        if (hasMerge) {
            this.checkFlowAndPeriodControlStatus(tmp, tmp.getMergeNode());
        }
        tmp.getOrgScope().removeIf(org -> {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)org);
            if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonAdjustTemplateModelValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
                return true;
            }
            if (!hasMerge) {
                return this.checkFlowAndPeriodControlStatus(tmp, orgNode);
            }
            return false;
        });
        if (tmp.getOrgScope().isEmpty()) {
            this.addLog(tmp.getNumber(), ResManager.loadKDString((String)"\u53ef\u7528\u7ec4\u7ec7\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"CommonAdjustTemplateModelValidator_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkFlowAndPeriodControlStatus(CommonAdjustTemplateModel tmp, IDNumberTreeNode org) {
        McStatus mc = this.mcStatusMap.get(org.getId());
        if (mc != null) {
            if (mc.getArchive().isArchive()) {
                this.addLog(tmp.getNumber(), ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u72b6\u6001\u4e0d\u662f\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"CommonAdjustTemplateModelValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                return true;
            }
            if (!this.checkFlowStatus(mc, tmp, org.getId())) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u63d0\u4ea4\u3002", (String)"CommonAdjustTemplateModelValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), org.getNumber()));
                return true;
            }
            if (!this.checkPeriodStatus(org.getId())) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u671f\u95f4\u7ba1\u7406\u672a\u5f00\u542f\u3002", (String)"CommonAdjustTemplateModelValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]), org.getNumber()));
                return true;
            }
            if (!this.checkPhaseSubmitGrpStatus(tmp, org.getId())) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u72b6\u6001\u4e0d\u662f\u201c\u5904\u7406\u4e2d\u201d\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"CommonAdjustTemplateModelValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]), org.getNumber()));
                return true;
            }
        }
        return false;
    }

    private boolean checkPeriodStatus(long org) {
        return this.periodStatusOpenOrgNum == null || this.periodStatusOpenOrgNum.contains(this.orgIdMap.get(org));
    }

    private boolean checkFlowStatus(McStatus mc, CommonAdjustTemplateModel tmp, long org) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)tmp.getProcess()) && AdjustCheckDataSysToMDDValidator.submitProcessList.contains(tmp.getProcess())) {
            return !mc.getFlow().isSubmit();
        }
        if ("RAdj".equals(tmp.getProcess())) {
            return !mc.getPcFlow().isSubmit();
        }
        return true;
    }

    private boolean checkPhaseSubmitGrpStatus(CommonAdjustTemplateModel tmp, long orgId) {
        String process = tmp.getProcess();
        if ("RAdj".equals(process)) {
            return true;
        }
        McStatus mcstatus = this.org2MC.get(orgId);
        return mcstatus == null || !mcstatus.getFlow().isSubmit();
    }

    private boolean checkTemplateEntry(CommonAdjustTemplateModel tmp, CommonTemplateEntry entry) {
        Map<String, Long> comDimMap = tmp.getCommDimensionEntries().stream().collect(Collectors.toMap(com -> com.getDimension().getNumber(), p -> p.getMember().getId(), (v1, v2) -> v1));
        IDNumberTreeNode dimTree = null;
        for (Dimension dim : this.ctx.getSctx().getDimensions()) {
            if ("Entity".equals(dim.getNumber()) || "Scenario".equals(dim.getNumber()) || "Year".equals(dim.getNumber()) || "Period".equals(dim.getNumber())) continue;
            long memId = LongUtil.toLong((Object)entry.getRowData().getOrDefault(dim.getNumber(), comDimMap.getOrDefault(dim.getNumber(), 0L)));
            dimTree = MemberReader.findMemberById((String)this.ctx.getModelNum(), (String)dim.getEntity(), (Long)memId);
            if ("MyCompany".equals(dim.getNumber()) && SystemVarsEnum.isDimVarsByNumber((String)dimTree.getNumber()) && SystemVarsEnum.RELATE_ENTITY.getNumber().equals(dimTree.getNumber())) {
                for (Long orgId : tmp.getOrgScope()) {
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)orgId);
                    IDNumberTreeNode realMcNode = MemberReader.findMemberByNumber((String)this.ctx.getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)orgNode.getNumber());
                    if (realMcNode != IDNumberTreeNode.NotFoundTreeNode && StorageTypeEnum.LABEL != realMcNode.getStorageType()) continue;
                    dimTree = realMcNode;
                    break;
                }
            }
            if (IDNumberTreeNode.NotFoundTreeNode.equals(dimTree)) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u6210\u5458\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"CommonAdjustTemplateModelValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName()));
                return false;
            }
            if (!dimTree.isLeaf()) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e0b\u7684\u201c%2$s\u201d\u6210\u5458\u4e0d\u80fd\u662f\u975e\u660e\u7ec6\u6210\u5458\u3002", (String)"CommonAdjustTemplateModelValidator_9", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), dimTree.getNumber(), dimTree.getName()));
                return false;
            }
            if (StorageTypeEnum.LABEL == dimTree.getStorageType()) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e0b%2$s\u6210\u5458\u5b58\u50a8\u7c7b\u578b\u4e3a\u6807\u7b7e\u6210\u5458", (String)"CommonAdjustTemplateModelValidator_12", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getName(), dimTree.getName()));
                return false;
            }
            if (!"Account".equals(dim.getNumber())) continue;
            DataTypeEnum accountType = DataTypeEnum.getDataTypeEnumByIndex((String)((String)dimTree.getProperty("datatype")));
            if (DataTypeEnum.TXT == accountType || DataTypeEnum.DATETP == accountType || DataTypeEnum.ENUMTP == accountType) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0b%s\u6210\u5458\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\uff0c\u65e5\u671f\uff0c\u679a\u4e3e\u6210\u5458", (String)"CommonAdjustTemplateModelValidator_13", (String)"fi-bcm-business", (Object[])new Object[0]), dimTree.getName()));
                return false;
            }
            if (DrCRDirectEnum.NONE.getOIndex().equals(dimTree.getProperty("drcrdirect"))) {
                this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0b%s\u6210\u5458\u4e0d\u5b58\u5728\u501f\u8d37\u65b9\u5411", (String)"CommonAdjustTemplateModelValidator_14", (String)"fi-bcm-business", (Object[])new Object[0]), dimTree.getName()));
                return false;
            }
            if (!((Boolean)dimTree.getProperty("iscaltype")).booleanValue()) continue;
            this.addLog(tmp.getNumber(), String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0b%s\u6210\u5458\u4e3a\u8ba1\u7b97\u7c7b\u79d1\u76ee", (String)"CommonAdjustTemplateModelValidator_15", (String)"fi-bcm-business", (Object[])new Object[0]), dimTree.getName()));
            return false;
        }
        return true;
    }

    private void afterValidate() {
        this.mcStatusMap = null;
        this.periodStatusOpenOrgNum = null;
        this.org2MC = null;
        this.orgIdMap.clear();
    }

    @Override
    public void setCheckData(List<CommonAdjustTemplateModel> checkDataList) {
        this.checkDataList = checkDataList;
    }

    @Override
    public void setCtx(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setValidateResult(OperationResult op) {
    }

    @Override
    public void setAdjLog(AdjRecordLog log) {
    }

    @Override
    public void setOnlyWarning(Boolean isOnlyWarning) {
    }

    @Override
    public Boolean isOnlyWarning() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isContinueValidate(List<CommonAdjustTemplateModel> checkData) {
        if (checkData == null || checkData.size() < 1) {
            return false;
        }
        return true;
    }
}

