/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.TemplateModelValidator;

import com.google.common.collect.ArrayListMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.model.CommonAdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.CommonTemplateEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AbstractValidator;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class CommonCheckDimMemberPermValidator
extends AbstractValidator<List<CommonAdjustTemplateModel>> {
    private boolean permSign = Boolean.TRUE;
    private Set<String> specicalNoCheckDimSet = new HashSet<String>(16);

    public CommonCheckDimMemberPermValidator() {
    }

    public CommonCheckDimMemberPermValidator(boolean permSign) {
        this.permSign = permSign;
    }

    public CommonCheckDimMemberPermValidator(Set<String> noCheckDimSet) {
        if (noCheckDimSet != null) {
            this.specicalNoCheckDimSet.addAll(noCheckDimSet);
        }
    }

    @Override
    public void validate() {
        boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(this._ctx().getModelId());
        if (modelManage) {
            return;
        }
        ArrayListMultimap<String, Long> templatePermClassMap = PermClassEntityHelper.getPermissionMap("bcm_papertmpl_process", String.valueOf(this._ctx().getModelId()), RequestContext.getOrCreate().getUserId());
        ArrayListMultimap<String, Long> catalogPermClassMap = PermClassEntityHelper.getPermissionMap("bcm_papertemplatecatalog", String.valueOf(this._ctx().getModelId()), RequestContext.getOrCreate().getUserId());
        List templateNoPermList = templatePermClassMap.get((Object)(PermEnum.NOPERM.getValue() + ""));
        List templateReadOnlyPermList = templatePermClassMap.get((Object)(PermEnum.READONLY.getValue() + ""));
        List catalogNoPermList = catalogPermClassMap.get((Object)(PermEnum.NOPERM.getValue() + ""));
        List catalogReadOnlyPermList = catalogPermClassMap.get((Object)(PermEnum.READONLY.getValue() + ""));
        this.specicalNoCheckDimSet.add("Entity");
        this.specicalNoCheckDimSet.add("Scenario");
        this.specicalNoCheckDimSet.add("Year");
        this.specicalNoCheckDimSet.add("Period");
        this.specicalNoCheckDimSet.add("MyCompany");
        boolean comPerm = true;
        for (CommonAdjustTemplateModel tmpl : (List)this.getCheckData()) {
            IDNumberTreeNode memberById;
            if (templateNoPermList.contains(tmpl.getId()) || this.permSign && templateReadOnlyPermList.contains(tmpl.getId())) {
                this.addMessage(tmpl.getId(), String.format(ResManager.loadKDString((String)"\u6a21\u677f%1$s\u6743\u9650\u7c7b%2$s,\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c", (String)"CommonCheckDimMemberPermValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getNumber(), this.getPermMsg()), ErrorLevel.Error);
                continue;
            }
            if (catalogNoPermList.contains(tmpl.getTemplateCatalog().getId()) || this.permSign && catalogReadOnlyPermList.contains(tmpl.getTemplateCatalog().getId())) {
                this.addMessage(tmpl.getId(), String.format(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b%1$s\u6743\u9650\u7c7b%2$s,\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c", (String)"CommonCheckDimMemberPermValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getTemplateCatalog().getNumber(), this.getPermMsg()), ErrorLevel.Error);
                continue;
            }
            for (CommDimensionEntry com : tmpl.getCommDimensionEntries()) {
                String dimNum = com.getDimension().getNumber();
                long memId = com.getMember().getId();
                if (com.getMember() == null || this.specicalNoCheckDimSet.contains(dimNum) || (memberById = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dimNum, (long)memId)) == IDNumberTreeNode.NotFoundTreeNode || !this.isNoPerm(memberById.getDimId(), memId)) continue;
                this.addMessage(tmpl.getId(), String.format(ResManager.loadKDString((String)"\u901a\u7528\u7ef4%1$s\u7ef4\u5ea6\u6210\u5458%2$s%3$s\uff08%4$s\uff09,\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c", (String)"CommonCheckDimMemberPermValidator_3", (String)"fi-bcm-business", (Object[])new Object[0]), com.getDimension().getName(), memberById.getNumber(), memberById.getName(), this.getPermMsg()), ErrorLevel.Error);
                comPerm = false;
                break;
            }
            if (!comPerm) continue;
            List<SpreadDimensionEntry> spreadDims = tmpl.getSpreadDimensionEntries();
            HashSet<String> noPermSet = new HashSet<String>(spreadDims.size());
            for (CommonTemplateEntry entry : tmpl.getEntries()) {
                for (SpreadDimensionEntry spr : spreadDims) {
                    String spreadDimNum = spr.getDimension().getNumber();
                    if (this.specicalNoCheckDimSet.contains(spreadDimNum) || (memberById = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)spreadDimNum, (long)LongUtil.toLong((Object)entry.getRowData().get(spreadDimNum)))) == IDNumberTreeNode.NotFoundTreeNode || !this.isNoPerm(spr.getDimension().getId(), memberById.getId())) continue;
                    noPermSet.add("[" + spr.getDimension().getName() + "[" + memberById.getNumber() + "]]");
                }
                if (!CollectionUtils.isNotEmpty(noPermSet)) continue;
                this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(entry.getRow(), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6%1$s%2$s\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c", (String)"CommonCheckDimMemberPermValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), noPermSet, this.getPermMsg())));
                noPermSet.clear();
            }
        }
    }

    private boolean isNoPerm(long dimId, long membId) {
        if (this.permSign) {
            return !PermissionServiceImpl.getInstance(this._ctx().getModelId()).hasWritePerm(dimId, membId);
        }
        return PermissionServiceImpl.getInstance(this._ctx().getModelId()).hasNoPerm(dimId, membId);
    }

    private String getPermMsg() {
        return this.permSign ? ResManager.loadKDString((String)"\u65e0\u6743\u6216\u8005\u53ea\u8bfb", (String)"CommonCheckDimMemberPermValidator_5", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u6743", (String)"CommonCheckDimMemberPermValidator_6", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    @Override
    protected String getValidatorKey() {
        return this.getClass().getName();
    }
}

