/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.validator.TemplateModelValidator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.bcm.business.adjust.model.CommonAdjustTemplateModel;
import kd.fi.bcm.business.adjust.model.CommonTemplateEntry;
import kd.fi.bcm.business.adjust.model.SpreadDimensionEntry;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AbstractValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.LongUtil;

public class CommonCheckPaperTmplValidator
extends AbstractValidator<List<CommonAdjustTemplateModel>> {
    @Override
    public void validate() {
        for (CommonAdjustTemplateModel tmpl : (List)this.getCheckData()) {
            List<Dimension> dimensionList = this._ctx().getSctx().getDimensions();
            HashSet comEtyDimSet = new HashSet(16);
            Map<String, Long> comDimMap = tmpl.getCommDimensionEntries().stream().filter(com -> !"Year".equals(com.getDimension().getNumber()) && !"Scenario".equals(com.getDimension().getNumber()) && !"Period".equals(com.getDimension().getNumber()) && !"Entity".equals(com.getDimension().getNumber())).peek(com -> {
                if (com.getMember() == null || BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)com.getDimension().getNumber(), (long)com.getMember().getId()) == IDNumberTreeNode.NotFoundTreeNode) {
                    comEtyDimSet.add(com.getDimension().getName());
                }
            }).collect(Collectors.toMap(com -> com.getDimension().getNumber(), p -> p.getMember() == null ? 0L : p.getMember().getId(), (v1, v2) -> v1));
            if (!comEtyDimSet.isEmpty()) {
                this.addMessage(tmpl.getId(), String.format(ResManager.loadKDString((String)"\u901a\u7528\u7ef4%s\u6210\u5458\u4e3a\u7a7a\u6216\u8005\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5", (String)"CommonCheckPaperTmplValidator_1", (String)"fi-bcm-business", (Object[])new Object[0]), comEtyDimSet), ErrorLevel.Error);
                return;
            }
            HashSet<String> sprEtyDimSet = new HashSet<String>(16);
            HashMap<String, AtomicInteger> indexMap = new HashMap<String, AtomicInteger>(16);
            for (CommonTemplateEntry entry : tmpl.getEntries()) {
                String groupNum;
                HashMap<String, Long> dimMemMap = new HashMap<String, Long>(comDimMap);
                for (SpreadDimensionEntry spreadDim : tmpl.getSpreadDimensionEntries()) {
                    if ("Year".equals(spreadDim.getDimension().getNumber()) || "Scenario".equals(spreadDim.getDimension().getNumber()) || "Period".equals(spreadDim.getDimension().getNumber()) || "Entity".equals(spreadDim.getDimension().getNumber())) continue;
                    IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)spreadDim.getDimension().getNumber(), (long)LongUtil.toLong((Object)entry.getRowData().get(spreadDim.getDimension().getNumber())));
                    if (memNode == IDNumberTreeNode.NotFoundTreeNode) {
                        sprEtyDimSet.add(spreadDim.getDimension().getName());
                        dimMemMap.putIfAbsent(spreadDim.getDimension().getNumber(), 0L);
                        continue;
                    }
                    dimMemMap.computeIfAbsent(spreadDim.getDimension().getNumber(), a -> memNode.getId());
                }
                if (!sprEtyDimSet.isEmpty()) {
                    this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(entry.getRow(), String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6%s\u6210\u5458\u4e3a\u7a7a\u6216\u8005\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5", (String)"CommonCheckPaperTmplValidator_2", (String)"fi-bcm-business", (Object[])new Object[0]), sprEtyDimSet)));
                    sprEtyDimSet.clear();
                    continue;
                }
                if (entry.isBalanceLine() && indexMap.computeIfAbsent(groupNum = Optional.ofNullable(entry.getRowData().get("groupnum")).orElseGet(() -> ResManager.loadKDString((String)"\u7a7a", (String)"CommonCheckPaperTmplValidator_3", (String)"fi-bcm-business", (Object[])new Object[0])).toString(), adjust -> new AtomicInteger()).getAndIncrement() > 0) {
                    this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(entry.getRow(), String.format(ResManager.loadKDString((String)"\u5206\u7ec4 %s \u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a\u5e73\u8861\u6570", (String)"CommonCheckPaperTmplValidator_4", (String)"fi-bcm-business", (Object[])new Object[0]), groupNum)));
                    continue;
                }
                Long accId = (Long)dimMemMap.get("Account");
                boolean bl = this.checkDimLabel(tmpl, entry.getRow(), dimMemMap) && this.checkAccountType(tmpl, entry.getRow(), accId) && this.checkMycompanyVar(tmpl, entry.getRow(), dimMemMap) && this.checkDimMemIsLeaf(tmpl, entry.getRow(), dimMemMap) && this.checkAccountCalc(tmpl, entry.getRow(), accId);
            }
        }
        this.getTempLogCache().forEach((pkId, logs) -> this.addMessage((long)pkId, logs.toString(), ErrorLevel.Error));
        this.getTempLogCache().clear();
    }

    @Override
    protected String getValidatorKey() {
        return "CommonCheckPaperTmplValidator";
    }

    protected boolean checkDimLabel(CommonAdjustTemplateModel tmpl, Integer row, Map<String, Long> dimMemMap) {
        for (Dimension dim : this._ctx().getSctx().getDimensions()) {
            Long membid = dimMemMap.get(dim.getNumber());
            IDNumberTreeNode dimTree = MemberReader.findMemberById((String)this._ctx().getModelNum(), (String)dim.getMembermodel(), (Long)membid);
            if (IDNumberTreeNode.NotFoundTreeNode == dimTree || StorageTypeEnum.LABEL != dimTree.getStorageType()) continue;
            this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, String.format(AdjustCheckDimMemValidator.labelTextMessage(), dim.getName())));
            return false;
        }
        return true;
    }

    protected boolean checkMycompanyVar(CommonAdjustTemplateModel tmpl, Integer row, Map<String, Long> dimMemMap) {
        for (Dimension dim : this._ctx().getSctx().getDimensions()) {
            if (!DimTypesEnum.MYCOMPANY.getNumber().equals(dim.getNumber())) continue;
            Long membid = dimMemMap.get(dim.getNumber());
            IDNumberTreeNode dimTree = MemberReader.findMemberById((String)this._ctx().getModelNum(), (String)dim.getMembermodel(), (Long)membid);
            if (!SystemVarsEnum.isDimVarsByNumber((String)dimTree.getNumber())) continue;
            if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(dimTree.getNumber())) {
                Long orgId = dimMemMap.getOrDefault(DimTypesEnum.ENTITY.getNumber(), 0L);
                if (orgId != null && orgId != 0L) {
                    dimTree = MemberReader.findMemberByNumber((String)this._ctx().getModelNum(), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)MemberReader.findEntityMemberById((Long)this._ctx().getModelId(), (Long)orgId).getNumber());
                }
            } else {
                dimTree = IDNumberTreeNode.NotFoundTreeNode;
            }
            if (IDNumberTreeNode.NotFoundTreeNode == dimTree) {
                this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, String.format(AdjustCheckDimMemValidator.varTestMessage(), dim.getName())));
                return false;
            }
            if (StorageTypeEnum.LABEL != dimTree.getStorageType()) continue;
            this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, String.format(AdjustCheckDimMemValidator.labelTextMessage(), dim.getName())));
            return false;
        }
        return true;
    }

    protected boolean checkAccountType(CommonAdjustTemplateModel tmpl, Integer row, Long accId) {
        IDNumberTreeNode accTree = MemberReader.findMemberById((long)this._ctx().getModelId(), (String)"bcm_accountmembertree", (Long)accId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(accTree)) {
            DataTypeEnum accountType = DataTypeEnum.getDataTypeEnumByIndex((String)((String)accTree.getProperty("datatype")));
            if (DataTypeEnum.TXT == accountType || DataTypeEnum.DATETP == accountType || DataTypeEnum.ENUMTP == accountType) {
                this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, ResManager.loadKDString((String)"\u79d1\u76ee\u662f%s\u6210\u5458\uff0c\u4e0d\u53ef\u8fdb\u884c\u64cd\u4f5c", (String)"CommonCheckPaperTmplValidator_6", (String)"fi-bcm-business", (Object[])new Object[]{accountType.getName()})));
                return false;
            }
            if (DrCRDirectEnum.NONE.getOIndex().equals(accTree.getProperty("drcrdirect"))) {
                this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, AdjustCheckDimMemValidator.acctDirectTextmessage()));
                return false;
            }
        }
        return true;
    }

    protected boolean checkDimMemIsLeaf(CommonAdjustTemplateModel tmpl, Integer row, Map<String, Long> dimMemMap) {
        String processNum = tmpl.getProcess();
        for (Map.Entry<String, Long> enrty : dimMemMap.entrySet()) {
            IDNumberTreeNode dimTree;
            String dimNum = enrty.getKey();
            if ("bcm_mergenode".equals(dimNum) || IDNumberTreeNode.NotFoundTreeNode.equals(dimTree = MemberReader.findMemberById((String)this._ctx().getModelNum(), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNum), (Long)enrty.getValue()))) continue;
            if (dimTree.isLeaf()) {
                if (!"Entity".equals(dimNum) || !"DADJ".equals(processNum) && !"DEJE".equals(processNum)) continue;
                this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, ResManager.loadKDString((String)"DADJ\u548cDEJE\u4e1a\u52a1\u7c7b\u578b\u4e0b\u4e0d\u80fd\u5b58\u5728\u660e\u7ec6\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5", (String)"CommonCheckPaperTmplValidator_7", (String)"fi-bcm-business", (Object[])new Object[0])));
                return false;
            }
            if ("Entity".equals(dimNum)) continue;
            this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u4e0d\u80fd\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff1a%2$s", (String)"CommonCheckPaperTmplValidator_8", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, dimTree.getName())));
            return false;
        }
        return true;
    }

    protected boolean checkAccountCalc(CommonAdjustTemplateModel tmpl, Integer row, Long accId) {
        IDNumberTreeNode accTree = MemberReader.findMemberById((String)this._ctx().getModelNum(), (String)"bcm_accountmembertree", (Long)accId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(accTree) && ("1".equals(accTree.getProperty("iscaltype").toString()) || "true".equals(accTree.getProperty("iscaltype").toString()))) {
            this.addTempLogCache(tmpl.getId(), AdjustOperationHelper.packRowPfix(row, AdjustCheckDimMemValidator.calAcctTextMessage()));
            return false;
        }
        return true;
    }
}

