/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.MergeControlTaskNode;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class MergeOrgOrientGraphBuilder {
    private final long orgId;
    private final ExecuteContext ctx;
    private final Set<MergeControlTaskNode> startList = new HashSet<MergeControlTaskNode>(10);
    private final Map<String, MergeControlTaskNode> canShareOrgMap = new HashMap<String, MergeControlTaskNode>(16);
    private Set<Long> effectOrgIds;

    public MergeOrgOrientGraphBuilder(ExecuteContext ctx, long orgId) {
        this.ctx = ctx;
        this.orgId = orgId;
    }

    private void orgVersionControl() {
        DynamicObjectCollection allOrgs = OrgServiceHelper.getAllOrgChildren((Long)this.ctx.getModel().getId(), this.orgId, true);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)((Long)this.ctx.getModel().getId()), (long)((Long)this.ctx.getScenario().getId()), this.ctx.getFy().getNumber(), (long)((Long)this.ctx.getPeriod().getId()));
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)allOrgs);
        this.effectOrgIds = allOrgs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    public Pair<MergeControlTaskNode, Set<MergeControlTaskNode>> getOrgOrientGraph() {
        this.orgVersionControl();
        IDNumberTreeNode lastOrgNode = MemberReader.findEntityMemberById((String)this.ctx.getModel().getNumber(), (Long)this.orgId);
        MergeControlTaskNode headNode = this.recursion(lastOrgNode, null);
        HashSet<MergeControlTaskNode> treeSet = new HashSet<MergeControlTaskNode>(this.startList);
        return Pair.onePair((Object)headNode, treeSet);
    }

    private MergeControlTaskNode recursion(IDNumberTreeNode currNode, MergeControlTaskNode parent) {
        MergeControlTaskNode mergeOrgNode = this.canShareOrgMap.get(currNode.getNumber());
        if (mergeOrgNode == null) {
            mergeOrgNode = new MergeControlTaskNode(currNode.getNumber());
            if (currNode.isShare() || !currNode.getShareNodes().isEmpty()) {
                this.canShareOrgMap.put(currNode.getNumber(), mergeOrgNode);
            }
        }
        mergeOrgNode.setLevel((byte)currNode.getLevel());
        List children = currNode.getChildren();
        ArrayList<MergeControlTaskNode> childs = new ArrayList<MergeControlTaskNode>(children.size());
        for (IDNumberTreeNode child : children) {
            if (!this.effectOrgIds.contains(child.getId())) continue;
            MergeControlTaskNode childMergeNode = this.recursion(child, mergeOrgNode);
            childs.add(childMergeNode);
        }
        if (childs.isEmpty()) {
            this.startList.add(mergeOrgNode);
            mergeOrgNode.addRef(currNode.getId(), parent, null);
        } else {
            mergeOrgNode.addRef(currNode.getId(), parent, childs.toArray(new MergeControlTaskNode[0]));
        }
        return mergeOrgNode;
    }
}

