/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class OrgBuilder {
    private final Long modelId;
    private final Long scenarioId;
    private final Long fyId;
    private final Long periodId;

    private OrgBuilder(Long modelId, Long scenarioId, Long fyId, Long periodId) {
        this.modelId = modelId;
        this.scenarioId = scenarioId;
        this.fyId = fyId;
        this.periodId = periodId;
    }

    public static OrgBuilder build(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return new OrgBuilder(modelId, scenarioId, yearId, periodId);
    }

    public OrgNode genOrgNode(Long orgId) {
        OrgNode org = this.convert2OrgNode(orgId);
        org.setSkipMerge(MergeControlHelper.isCancelMerge(this.modelId, this.scenarioId, this.fyId, this.periodId, orgId));
        if (!org.isLeaf()) {
            org.setMergeType(MergeControlHelper.getMergeSource((Object)this.modelId, (Object)this.scenarioId, (Object)this.fyId, (Object)this.periodId, orgId));
        }
        return org;
    }

    public void extendDirectChildren(OrgNode org) {
        if (!org.hasExtend()) {
            if (!org.isLeaf()) {
                org.setChildren(this.getDirectChildren(org.getId()));
            }
            if (org.isLeaf() && org.isShare()) {
                IDNumberTreeNode currOrg = MemberReader.findEntityMemberById((Long)this.modelId, (Long)org.getId());
                if (!currOrg.getBaseTreeNode().getChildren().isEmpty()) {
                    org.setChildren(this.getDirectChildren(currOrg.getBaseTreeNode().getId()));
                }
                org.setLeaf(org.getChildren().isEmpty());
            }
            org.setExtend(true);
        }
    }

    public void extendAllChildren(OrgNode org) {
        this.extendDirectChildren(org);
        org.getChildren().forEach(this::extendAllChildren);
    }

    private OrgNode convert2OrgNode(Long orgId) {
        IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)this.modelId, (Long)orgId);
        Long parentId = org.getParent().getId();
        String parentNumber = org.getParent().getNumber();
        OrgNode orgNode = new OrgNode(org.getId(), org.getNumber(), org.isLeaf(), StorageTypeEnum.isShare((StorageTypeEnum)org.getStorageType()), Long.valueOf(org.getLevel()), org.getCurrency(), org.getParent() == null ? null : org.getParent().getCurrency(), parentId, parentNumber);
        return orgNode;
    }

    private List<OrgNode> convert2OrgNode(List<Long> orgIds) {
        ArrayList<OrgNode> orgNodes = new ArrayList<OrgNode>(10);
        for (Long orgId : orgIds) {
            OrgNode orgNode = this.convert2OrgNode(orgId);
            orgNodes.add(orgNode);
        }
        return orgNodes;
    }

    private List<OrgNode> getDirectChildren(Long pid) {
        String yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)this.modelId), (Long)this.fyId).getNumber();
        DynamicObjectCollection orgs = OrgServiceHelper.getOrgChildren(this.modelId, pid);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam((long)this.modelId, (long)this.scenarioId, yearNum, (long)this.periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgs);
        List<Long> orgIds = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        Map<String, Boolean> mcMap = MergeControlHelper.getMergeMapByUnitOrg(this.modelId, this.scenarioId, this.fyId, this.periodId, pid);
        ArrayList<OrgNode> directChildren = new ArrayList<OrgNode>(orgIds.size());
        List<OrgNode> orgNodes = this.convert2OrgNode(orgIds);
        for (OrgNode org : orgNodes) {
            org.setSkipMerge(Boolean.FALSE.equals(mcMap.get(org.getNumber())));
            if (!org.isLeaf()) {
                org.setMergeType(MergeControlHelper.getMergeSource((Object)this.modelId, (Object)this.scenarioId, (Object)this.fyId, (Object)this.periodId, org.getId()));
            }
            directChildren.add(org);
        }
        return directChildren;
    }
}

