/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.dispatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.MergeOrgOrientGraphBuilder;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.dispatch.IServiceDispatcher;
import kd.fi.bcm.business.allinone.exception.BcmCslException;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.MergeControlTaskNode;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.ProgressCacheHelper;
import kd.fi.bcm.business.allinone.service.csl.DetailOrgCslExecuteService;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.allinone.service.thread.JVMShutdownHook;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.ThrowableHelper;

public class CslService2Dispatcher
implements IServiceDispatcher {
    private static final Log log = LogFactory.getLog(CslService2Dispatcher.class);
    private static final Semaphore semaphore = new Semaphore(500);
    private final AtomicBoolean isRunning = new AtomicBoolean(Boolean.TRUE);
    private final AtomicInteger leafCount = new AtomicInteger(0);
    private final AtomicInteger mergeCount = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchService(ExecuteContext ctx) {
        if (ctx.isEntryCtx()) {
            JVMShutdownHook.monitorProgress(ctx.getProgressId());
        }
        try {
            OrgBuilder build = OrgBuilder.build((Long)ctx.getModel().getId(), (Long)ctx.getScenario().getId(), (Long)ctx.getFy().getId(), (Long)ctx.getPeriod().getId());
            OrgNode node = build.genOrgNode((Long)ctx.getOrg().getId());
            if (ctx.isSingleCalc()) {
                build.extendDirectChildren(node);
                this.singleOrgCsl(node, ctx);
            } else if (ctx.isMergeAll()) {
                this.multiOrgCsl(node, ctx);
            } else {
                build.extendDirectChildren(node);
                this.directOrgCsl(node, ctx);
            }
        }
        catch (Exception e) {
            log.error("DispatchCslService Error: ", (Throwable)e);
            this.handleFailed(e, ctx);
        }
        finally {
            ProgressCacheHelper.resetProcessNoLock(ctx.getProgressId(), this.leafCount.get(), this.mergeCount.get());
        }
    }

    private void singleOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
            this.leafCount.incrementAndGet();
        } else {
            MsServiceHelper.invokeCslService((String)ctx.toString(), (String)node.toString());
            this.mergeCount.incrementAndGet();
        }
    }

    private Pair<MergeControlTaskNode, Set<MergeControlTaskNode>> getOrgOrientGraph(ExecuteContext ctx, Long orgId) {
        MergeOrgOrientGraphBuilder builder = new MergeOrgOrientGraphBuilder(ctx, orgId);
        return builder.getOrgOrientGraph();
    }

    private void consumerNode(ExecuteContext ctx, MergeControlTaskNode mergeOrgNode, OrgBuilder build) {
        try {
            semaphore.acquire();
            ThreadPoolService.runInThread4Unit(() -> {
                if (!this.isRunning.get() || AbortThreadHelper.isAbortMergerProcess(ctx.getProgressId())) {
                    return;
                }
                MergeControlTaskNode.ExecuteOrgNode refNode = null;
                try {
                    HashMap currency2NodeMap = new HashMap(16);
                    for (MergeControlTaskNode.ExecuteOrgNode ExecuteOrgNode2 : mergeOrgNode.getRef()) {
                        IDNumberTreeNode org = MemberReader.findEntityMemberById((String)ctx.getModel().getNumber(), (Long)ExecuteOrgNode2.getId());
                        currency2NodeMap.computeIfAbsent(org.getCurrency(), k -> new ArrayList(10)).add(ExecuteOrgNode2);
                    }
                    HashSet<String> org2ParentNums = new HashSet<String>(16);
                    MergeControlTaskNode.ExecuteOrgNode[] executeOrgNodeArray = mergeOrgNode.getRef();
                    int n = executeOrgNodeArray.length;
                    for (int i = 0; i < n; ++i) {
                        MergeControlTaskNode.ExecuteOrgNode tempRefNode;
                        refNode = tempRefNode = executeOrgNodeArray[i];
                        refNode.startRunning();
                        IDNumberTreeNode org = MemberReader.findEntityMemberById((String)ctx.getModel().getNumber(), (Long)refNode.getId());
                        long id = refNode.getId();
                        OrgNode temp = build.genOrgNode(id);
                        build.extendDirectChildren(temp);
                        if (!org2ParentNums.contains(org.getParent_SonNumber())) {
                            org2ParentNums.add(org.getParent_SonNumber());
                            ExecuteContext ctxcopy = this.copyContext(ctx, temp);
                            if (temp.isLeaf()) {
                                MsServiceHelper.invokeCslService((String)ctxcopy.toString(), (String)temp.toString());
                            } else if (!this.isRootNode(temp)) {
                                if (temp.getId().equals(ctx.getEntryOrgId())) {
                                    ctxcopy = ctx;
                                }
                                ctxcopy.setCsl(false);
                                MsServiceHelper.invokeCslService((String)ctxcopy.toString(), (String)temp.toString());
                            }
                        }
                        refNode.finish();
                        List<MergeControlTaskNode.ExecuteOrgNode> sameCurrencyOrgList = currency2NodeMap.getOrDefault(org.getCurrency(), Collections.emptyList());
                        int index = sameCurrencyOrgList.indexOf(tempRefNode);
                        if (index == -1 || index == sameCurrencyOrgList.size() - 1) {
                            sameCurrencyOrgList.forEach(MergeControlTaskNode.ExecuteOrgNode::finish);
                        }
                        if (temp.isLeaf()) {
                            this.leafCount.incrementAndGet();
                            continue;
                        }
                        this.mergeCount.incrementAndGet();
                    }
                }
                catch (BcmCslException e) {
                    this.handleFailed(e, ctx);
                    if (refNode != null) {
                        refNode.except();
                    }
                    this.isRunning.set(false);
                }
                catch (Exception e) {
                    this.handleFailed(e, ctx);
                    this.isRunning.set(false);
                    if (refNode != null) {
                        refNode.except();
                    }
                }
                finally {
                    semaphore.release();
                }
            });
        }
        catch (Exception e) {
            this.handleFailed(e, ctx);
            this.isRunning.set(false);
        }
    }

    private void multiOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
        } else {
            Pair<MergeControlTaskNode, Set<MergeControlTaskNode>> datas = this.getOrgOrientGraph(ctx, node.getId());
            Set pre = (Set)datas.p2;
            MergeControlTaskNode headNode = (MergeControlTaskNode)datas.p1;
            ArrayList<MergeControlTaskNode> orgOrientGraph = new ArrayList<MergeControlTaskNode>(10);
            OrgBuilder build = OrgBuilder.build((Long)ctx.getModel().getId(), (Long)ctx.getScenario().getId(), (Long)ctx.getFy().getId(), (Long)ctx.getPeriod().getId());
            try {
                while (!(orgOrientGraph.isEmpty() && pre.isEmpty() && headNode.isFinish() || !this.isRunning.get() || AbortThreadHelper.isAbortMergerProcess(ctx.getProgressId()))) {
                    pre.removeIf(mergeOrgNode -> {
                        if (mergeOrgNode.isFinishWithChilds() && semaphore.availablePermits() > 0) {
                            orgOrientGraph.add((MergeControlTaskNode)mergeOrgNode);
                            this.consumerNode(ctx, (MergeControlTaskNode)mergeOrgNode, build);
                            return true;
                        }
                        return false;
                    });
                    Thread.sleep(100L);
                    orgOrientGraph.removeIf(mergeOrgNode -> {
                        boolean flag = true;
                        for (MergeControlTaskNode.ExecuteOrgNode refNode : mergeOrgNode.getRef()) {
                            if (refNode.isSuc()) {
                                if (refNode.getParentNode() == null || !refNode.getParentNode().isFinishWithChilds()) continue;
                                pre.add(refNode.getParentNode());
                                continue;
                            }
                            flag = false;
                        }
                        return flag;
                    });
                    ProgressCacheHelper.resetProcessNoLock(ctx.getProgressId(), this.leafCount.get(), this.mergeCount.get());
                }
            }
            catch (Exception e) {
                this.handleFailed(e, ctx);
                this.isRunning.set(false);
            }
        }
    }

    private void directOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
        } else {
            CountDownLatch latch = new CountDownLatch(node.getChildren().size());
            AtomicInteger errorCount = new AtomicInteger(0);
            node.getChildren().forEach(child -> ThreadPoolService.runInThread4Detail(() -> {
                try {
                    MsServiceHelper.invokeCslService((String)this.copyContext(ctx, (OrgNode)child).toString(), (String)child.toString());
                }
                catch (BcmCslException e) {
                    if (!child.isSkipMerge()) {
                        errorCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    this.handleFailed(e, ctx);
                    if (!child.isSkipMerge()) {
                        errorCount.incrementAndGet();
                    }
                }
                finally {
                    latch.countDown();
                }
            }));
            try {
                latch.await();
                if (!this.isRootNode(node)) {
                    try {
                        ctx.setCsl(false);
                        MsServiceHelper.invokeCslService((String)ctx.toString(), (String)node.toString());
                    }
                    catch (BcmCslException e) {
                        this.handleFailed(e, ctx);
                    }
                    catch (Exception e) {
                        this.handleFailed(e, ctx);
                    }
                }
            }
            catch (InterruptedException e) {
                this.handleFailed(e, ctx);
            }
        }
    }

    private void handleFailed(Exception e, ExecuteContext ctx) {
        this.saveProcessRecord(e, ctx);
        log.warn("--bcm--allinone error-----" + e);
    }

    private void saveProcessRecord(Exception e, ExecuteContext ctx) {
        long progressId = ctx.getProgressId();
        if (progressId == 0L) {
            return;
        }
        DynamicObject updateObj = BusinessDataServiceHelper.loadSingle((Object)progressId, (String)"bcm_mergeprogressentity");
        updateObj.set("failedlog", (Object)(updateObj.getString("failedlog") + "\n CslServiceDispatcher error:" + ThrowableHelper.toString((Exception)e)));
        updateObj.set("fstatus", (Object)ProgressStatusEnum.FAIL.getCode());
        updateObj.set("endtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
    }

    private boolean isRootNode(OrgNode node) {
        return "Entity".equals(node.getNumber());
    }

    private ExecuteContext copyContext(ExecuteContext ctx, OrgNode org) {
        ExecuteContext executeContext = new ExecuteContext(ctx.getModel(), SimpleItem.newOne(org.getId(), org.getNumber()), ctx.getFy(), ctx.getPeriod(), ctx.getScenario(), ctx.isForceExec());
        executeContext.setCslInOne(true);
        this.syncCtx2New(ctx, executeContext);
        return executeContext;
    }

    private void syncCtx2New(ExecuteContext oldCtx, ExecuteContext newCtx) {
        newCtx.setEntryOrgId(oldCtx.getEntryOrgId());
        newCtx.setTempids(oldCtx.getTempids());
        newCtx.setFromRpt(oldCtx.isFromRpt());
        newCtx.setTmpscope(oldCtx.getTmpscope());
        newCtx.setSkipCheck(oldCtx.isSkipCheck());
        newCtx.setSkipEcRule(oldCtx.isSkipEcRule());
        newCtx.setSkipPcRule(oldCtx.isSkipPcRule());
        newCtx.setProgressId(oldCtx.getProgressId());
        newCtx.setSkipInvElim(oldCtx.isSkipInvElim());
        newCtx.setSkipCommPaperElim(oldCtx.isSkipCommPaperElim());
        newCtx.setSkipIntrElim(oldCtx.isSkipIntrElim());
        newCtx.setMergeAll(oldCtx.isMergeAll());
    }
}

