/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.dispatch;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.dispatch.IServiceDispatcher;
import kd.fi.bcm.business.allinone.exception.BcmCslException;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.csl.DetailOrgCslExecuteService;
import kd.fi.bcm.business.allinone.service.thread.JVMShutdownHook;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.ThrowableHelper;

public class CslServiceDispatcher
implements IServiceDispatcher {
    private static final Log log = LogFactory.getLog(CslServiceDispatcher.class);

    @Override
    public void dispatchService(ExecuteContext ctx) {
        if (ctx.isEntryCtx()) {
            JVMShutdownHook.monitorProgress(ctx.getProgressId());
        }
        try {
            OrgBuilder build = OrgBuilder.build((Long)ctx.getModel().getId(), (Long)ctx.getScenario().getId(), (Long)ctx.getFy().getId(), (Long)ctx.getPeriod().getId());
            OrgNode node = build.genOrgNode((Long)ctx.getOrg().getId());
            build.extendDirectChildren(node);
            if (ctx.isSingleCalc()) {
                this.singleOrgCsl(node, ctx);
            } else if (ctx.isMergeAll()) {
                this.multiOrgCsl(node, ctx);
            } else {
                this.directOrgCsl(node, ctx);
            }
        }
        catch (Exception e) {
            log.error("DispatchCslService Error: ", (Throwable)e);
            this.handleFailed(e, ctx);
        }
    }

    private void singleOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
        } else {
            MsServiceHelper.invokeCslService((String)ctx.toString(), (String)node.toString());
        }
    }

    private void multiOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
        } else {
            CountDownLatch latch = new CountDownLatch(node.getChildren().size());
            AtomicInteger errorCount = new AtomicInteger(0);
            node.getChildren().forEach(child -> {
                OrgBuilder build = OrgBuilder.build((Long)ctx.getModel().getId(), (Long)ctx.getScenario().getId(), (Long)ctx.getFy().getId(), (Long)ctx.getPeriod().getId());
                build.extendDirectChildren((OrgNode)child);
                if (child.isLeaf()) {
                    ThreadPoolService.runInThread4Detail(() -> {
                        try {
                            MsServiceHelper.invokeCslService((String)this.copyContext(ctx, (OrgNode)child).toString(), (String)child.toString());
                        }
                        catch (BcmCslException e) {
                            if (!child.isSkipMerge()) {
                                errorCount.incrementAndGet();
                            }
                        }
                        catch (Exception e) {
                            this.handleFailed(e, ctx);
                            if (!child.isSkipMerge()) {
                                errorCount.incrementAndGet();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                } else {
                    ThreadPoolService.waitInThread4Unit(() -> {
                        try {
                            this.dispatchService(this.copyContext(ctx, (OrgNode)child));
                        }
                        catch (BcmCslException e) {
                            if (!child.isSkipMerge()) {
                                errorCount.incrementAndGet();
                            }
                        }
                        catch (Exception e) {
                            this.handleFailed(e, ctx);
                            if (!child.isSkipMerge()) {
                                errorCount.incrementAndGet();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
            });
            try {
                latch.await();
                if (!this.isRootNode(node)) {
                    try {
                        ctx.setCsl(false);
                        MsServiceHelper.invokeCslService((String)ctx.toString(), (String)node.toString());
                    }
                    catch (BcmCslException e) {
                        this.handleFailed(e, ctx);
                    }
                    catch (Exception e) {
                        this.handleFailed(e, ctx);
                    }
                }
            }
            catch (InterruptedException e) {
                this.handleFailed(e, ctx);
            }
        }
    }

    private void directOrgCsl(OrgNode node, ExecuteContext ctx) {
        if (node.isLeaf() && !this.isRootNode(node)) {
            new DetailOrgCslExecuteService(node).executeService(ctx);
        } else {
            CountDownLatch latch = new CountDownLatch(node.getChildren().size());
            AtomicInteger errorCount = new AtomicInteger(0);
            node.getChildren().forEach(child -> ThreadPoolService.runInThread4Detail(() -> {
                try {
                    MsServiceHelper.invokeCslService((String)this.copyContext(ctx, (OrgNode)child).toString(), (String)child.toString());
                }
                catch (BcmCslException e) {
                    if (!child.isSkipMerge()) {
                        errorCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    this.handleFailed(e, ctx);
                    if (!child.isSkipMerge()) {
                        errorCount.incrementAndGet();
                    }
                }
                finally {
                    latch.countDown();
                }
            }));
            try {
                latch.await();
                if (!this.isRootNode(node)) {
                    try {
                        ctx.setCsl(false);
                        MsServiceHelper.invokeCslService((String)ctx.toString(), (String)node.toString());
                    }
                    catch (BcmCslException e) {
                        this.handleFailed(e, ctx);
                    }
                    catch (Exception e) {
                        this.handleFailed(e, ctx);
                    }
                }
            }
            catch (InterruptedException e) {
                this.handleFailed(e, ctx);
            }
        }
    }

    private void handleFailed(Exception e, ExecuteContext ctx) {
        this.saveProcessRecord(e, ctx);
        log.warn("--bcm--allinone error-----" + e);
    }

    private void saveProcessRecord(Exception e, ExecuteContext ctx) {
        long progressId = ctx.getProgressId();
        if (progressId == 0L) {
            return;
        }
        DynamicObject updateObj = BusinessDataServiceHelper.loadSingle((Object)progressId, (String)"bcm_mergeprogressentity");
        updateObj.set("failedlog", (Object)(updateObj.getString("failedlog") + "\n CslServiceDispatcher error:" + ThrowableHelper.toString((Exception)e)));
        updateObj.set("fstatus", (Object)ProgressStatusEnum.FAIL.getCode());
        updateObj.set("endtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
    }

    private boolean isRootNode(OrgNode node) {
        return "Entity".equals(node.getNumber());
    }

    private ExecuteContext copyContext(ExecuteContext ctx, OrgNode org) {
        ExecuteContext executeContext = new ExecuteContext(ctx.getModel(), SimpleItem.newOne(org.getId(), org.getNumber()), ctx.getFy(), ctx.getPeriod(), ctx.getScenario(), ctx.isForceExec());
        executeContext.setCslInOne(true);
        this.syncCtx2New(ctx, executeContext);
        return executeContext;
    }

    private void syncCtx2New(ExecuteContext oldCtx, ExecuteContext newCtx) {
        newCtx.setEntryOrgId(oldCtx.getEntryOrgId());
        newCtx.setTempids(oldCtx.getTempids());
        newCtx.setFromRpt(oldCtx.isFromRpt());
        newCtx.setTmpscope(oldCtx.getTmpscope());
        newCtx.setSkipCheck(oldCtx.isSkipCheck());
        newCtx.setSkipEcRule(oldCtx.isSkipEcRule());
        newCtx.setSkipPcRule(oldCtx.isSkipPcRule());
        newCtx.setProgressId(oldCtx.getProgressId());
        newCtx.setSkipInvElim(oldCtx.isSkipInvElim());
        newCtx.setSkipCommPaperElim(oldCtx.isSkipCommPaperElim());
        newCtx.setSkipIntrElim(oldCtx.isSkipIntrElim());
        newCtx.setMergeAll(oldCtx.isMergeAll());
    }
}

