/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.fi.bcm.business.allinone.dispatch.AbstractMcDispatcher;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.LongUtil;

public class McCalculateDispatcher
extends AbstractMcDispatcher {
    @Override
    public void doDispatchService(ExecuteContext ctx) {
        List<SimpleItem> orgs = this.parseCustomParams(ctx);
        if (orgs.isEmpty()) {
            orgs.add(ctx.getOrg());
        }
        orgs.forEach(t -> {
            ctx.setOrg((SimpleItem)t);
            ctx.setSingleCalc(true);
            this.setProgressId(ctx, (Long)t.getId());
            MsServiceHelper.invokeMcCalculateService((String)ctx.toString());
        });
        orgs.clear();
    }

    private List<SimpleItem> parseCustomParams(ExecuteContext ctx) {
        ArrayList<SimpleItem> results = new ArrayList<SimpleItem>(10);
        String orgstr = (String)ctx.get("orgs");
        if (orgstr != null) {
            String[] orgsarr;
            for (String org : orgsarr = orgstr.split(";")) {
                String[] orgarr = org.split(",");
                results.add(SimpleItem.newOne(Long.parseLong(orgarr[0]), orgarr[1]));
            }
        }
        return results;
    }

    private void setProgressId(ExecuteContext ctx, Long orgId) {
        Map progressIds = (Map)ctx.get("progressIds");
        if (Objects.isNull(orgId) || Objects.isNull(progressIds)) {
            return;
        }
        Long progressId = (Long)progressIds.get(orgId);
        if (LongUtil.isvalidLong((Object)progressId)) {
            ctx.setProgressId(progressId);
        }
    }
}

