/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.model;

import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.common.enums.StageOpTypeEnum;

public class MergeControlStatus {
    String action;
    long flowTaskId;
    String orgMergeStatus;
    String archive;
    Map<String, String> stageMergeStatusMapForNumber = new HashMap<String, String>(16);
    Map<Long, String> stageMergeStatusMapForId = new HashMap<Long, String>(16);

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public long getFlowTaskId() {
        return this.flowTaskId;
    }

    public void setFlowTaskId(long flowTaskId) {
        this.flowTaskId = flowTaskId;
    }

    public String getOrgMergeStatus() {
        return this.orgMergeStatus;
    }

    public void setOrgMergeStatus(String orgMergeStatus) {
        this.orgMergeStatus = orgMergeStatus;
    }

    public String getArchive() {
        return this.archive;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public Map<String, String> getStageMergeStatusMapForNumber() {
        return this.stageMergeStatusMapForNumber;
    }

    public void setStageMergeStatusMapForNumber(Map<String, String> stageMergeStatusMapForNumber) {
        this.stageMergeStatusMapForNumber = stageMergeStatusMapForNumber;
    }

    public Map<Long, String> getStageMergeStatusMapForId() {
        return this.stageMergeStatusMapForId;
    }

    public void setStageMergeStatusMapForId(Map<Long, String> stageMergeStatusMapForId) {
        this.stageMergeStatusMapForId = stageMergeStatusMapForId;
    }

    public MergeControlStatus buildDefault() {
        MergeControlStatus mergeControlStatus = new MergeControlStatus();
        mergeControlStatus.setOrgMergeStatus("B");
        mergeControlStatus.setStageMergeStatusMapForId(new HashMap<Long, String>(16));
        mergeControlStatus.setStageMergeStatusMapForNumber(new HashMap<String, String>(16));
        return mergeControlStatus;
    }

    public boolean isApproval() {
        return StageOpTypeEnum.APPR.getCode().equals(this.action) && "B".equals(this.orgMergeStatus);
    }

    public String getFlowStepName() {
        return FlowStepServiceHelper.getFlowTaskStatus(this.flowTaskId);
    }

    public String getFlowStepSort() {
        return FlowStepServiceHelper.getFlowTaskSort(this.flowTaskId);
    }

    public boolean isSubmit() {
        return "C".equals(this.orgMergeStatus);
    }

    public boolean isArchive() {
        return "D".equals(this.archive);
    }

    public boolean isSubmitByStageId(long stageId) {
        return "C".equals(this.stageMergeStatusMapForId.get(stageId)) || StageOpTypeEnum.APPR.getCode().equals(this.action) && "B".equals(this.orgMergeStatus);
    }

    public boolean isSubmitByStageNumber(String stageNumber) {
        return "C".equals(this.stageMergeStatusMapForNumber.get(stageNumber)) || StageOpTypeEnum.APPR.getCode().equals(this.action) && "B".equals(this.stageMergeStatusMapForNumber.get(stageNumber));
    }

    public Map<String, Boolean> queryStageCommitNumber() {
        HashMap<String, Boolean> stageMap = new HashMap<String, Boolean>(16);
        for (Map.Entry<String, String> entry : this.stageMergeStatusMapForNumber.entrySet()) {
            stageMap.put(entry.getKey(), "C".equals(entry.getValue()) || StageOpTypeEnum.APPR.getCode().equals(this.action) && "B".equals(entry.getValue()));
        }
        return stageMap;
    }
}

