/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.model;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MergeControlTaskNode
implements Comparable {
    private String number;
    private ExecuteOrgNode[] ref;
    private byte level = 1;

    public MergeControlTaskNode(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public byte getLevel() {
        return this.level;
    }

    public void setLevel(byte level) {
        if (this.level < level) {
            this.level = level;
        }
    }

    public void addRef(long id, MergeControlTaskNode parent, MergeControlTaskNode[] childs) {
        ExecuteOrgNode refNode = new ExecuteOrgNode(id, parent, childs);
        if (this.ref == null) {
            this.ref = new ExecuteOrgNode[]{refNode};
        } else {
            ExecuteOrgNode[] dest = new ExecuteOrgNode[this.ref.length + 1];
            System.arraycopy(this.ref, 0, dest, 0, this.ref.length);
            dest[this.ref.length] = refNode;
            this.ref = dest;
        }
    }

    public boolean isFinishWithChilds() {
        boolean flag = true;
        for (ExecuteOrgNode refNode : this.getRef()) {
            if (refNode.getChilds() == null) continue;
            for (MergeControlTaskNode child : refNode.getChilds()) {
                if (child.isFinish()) continue;
                flag = false;
            }
        }
        return flag;
    }

    public boolean isFinish() {
        boolean flag = true;
        for (ExecuteOrgNode refNode : this.ref) {
            if (refNode.isSuc()) continue;
            flag = false;
        }
        return flag;
    }

    public ExecuteOrgNode[] getRef() {
        return this.ref;
    }

    public int compareTo(@NotNull Object o) {
        if (o instanceof MergeControlTaskNode) {
            byte newLevel = ((MergeControlTaskNode)o).getLevel();
            if (newLevel > this.level) {
                return 1;
            }
            if (newLevel == this.level) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.number + "->" + this.level;
    }

    public static class ExecuteOrgNode {
        private long id;
        private MergeControlTaskNode parentNode;
        private MergeControlTaskNode[] childs;
        private volatile byte status = 0;

        public ExecuteOrgNode(long id, MergeControlTaskNode parentNode, MergeControlTaskNode[] childs) {
            this.id = id;
            this.parentNode = parentNode;
            this.childs = childs;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public MergeControlTaskNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(MergeControlTaskNode parentNode) {
            this.parentNode = parentNode;
        }

        public MergeControlTaskNode[] getChilds() {
            return this.childs;
        }

        public void setChilds(MergeControlTaskNode[] childs) {
            this.childs = childs;
        }

        public void finish() {
            this.status = (byte)99;
        }

        public boolean isSuc() {
            return this.status == 99;
        }

        public void except() {
            this.status = (byte)-1;
        }

        public boolean isRunning() {
            return this.status == 2;
        }

        public void waiting() {
            this.status = 1;
        }

        public void startRunning() {
            this.status = (byte)2;
        }

        public String toString() {
            return "RefNode{id=" + this.id + ", parentNode=" + this.parentNode + ", childs=" + Arrays.toString(this.childs) + ", status=" + this.status + '}';
        }
    }
}

