/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.StageMcStatus;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.StageOpTypeEnum;

public class MergeData {
    IDNumberTreeNode orgNode;
    DynamicObject ecData;
    DynamicObject pcData;
    List<DynamicObject> allConvertData;
    McStatus mergeStatus;
    Map<Long, StageMcStatus> stageMergeStatusMap = new HashMap<Long, StageMcStatus>(16);
    Map<Long, DynamicObject> ecStageDataMap = new HashMap<Long, DynamicObject>(16);
    Map<Long, DynamicObject> pcStageDataMap = new HashMap<Long, DynamicObject>(16);
    Map<Long, List<DynamicObject>> stageAllConvertDataMap = new HashMap<Long, List<DynamicObject>>(16);
    List<DynamicObject> ecStageMergeDataList = new ArrayList<DynamicObject>(5);
    List<DynamicObject> pcStageMergeDataList = new ArrayList<DynamicObject>(5);

    public MergeData(DynamicObject ecDyn, DynamicObject pcDyn, List<DynamicObject> allConvertData, IDNumberTreeNode orgNode, Map<Long, List<DynamicObject>> stageMergeControlMap) {
        this.orgNode = orgNode;
        this.ecData = ecDyn;
        this.pcData = pcDyn;
        this.allConvertData = allConvertData;
        String convertStatus = "";
        boolean isAny = allConvertData.stream().anyMatch(o -> "C".equals(o.getString("flowstatus")) || StageOpTypeEnum.APPR.getCode().equals(o.getString("flowtask.action")) && "B".equals(o.getString("flowstatus")));
        if (isAny) {
            convertStatus = "C";
        } else {
            isAny = allConvertData.stream().anyMatch(o -> !StageOpTypeEnum.APPR.getCode().equals(o.getString("flowtask.action")) || !"B".equals(o.getString("flowstatus")));
            if (isAny) {
                convertStatus = "B";
            }
        }
        String pcStatus = orgNode.getParent() != null && "Entity".equals(orgNode.getParent().getNumber()) ? "A" : (this.pcData != null ? this.pcData.getString("calculatestatus") : "B");
        this.mergeStatus = new McStatus(this.ecData == null ? "B" : this.ecData.getString("mergestatus"), this.ecData == null ? "B" : this.ecData.getString("calculatestatus"), pcStatus, this.ecData == null ? "" : this.ecData.getString("flowtask.action"), this.ecData == null ? null : this.ecData.getString("flowstatus"), this.pcData == null ? "" : this.pcData.getString("flowtask.action"), this.pcData == null ? null : this.pcData.getString("flowstatus"), convertStatus, this.ecData == null ? null : this.ecData.getString("archivestatus"), this.ecData == null ? "B" : this.ecData.getString("chkstatus"), this.pcData == null ? "B" : this.pcData.getString("chkstatus"));
        if (this.ecData != null) {
            this.ecStageMergeDataList = stageMergeControlMap.getOrDefault(this.ecData.getLong("id"), new ArrayList(5));
        }
        if (this.pcData != null) {
            this.pcStageMergeDataList = stageMergeControlMap.getOrDefault(this.pcData.getLong("id"), new ArrayList(5));
        }
        this.stageAllConvertDataMap = this.buildStageAllConvertDataMap(allConvertData, stageMergeControlMap);
        this.stageMergeStatusMap = this.buildStageMergeStatus(this.ecData, this.pcData, stageMergeControlMap, this.stageAllConvertDataMap);
        this.ecStageDataMap = this.ecStageMergeDataList.stream().collect(Collectors.toMap(e -> e.getLong("lockstage.id"), v -> v, (v1, v2) -> v1));
        this.pcStageDataMap = this.pcStageMergeDataList.stream().collect(Collectors.toMap(e -> e.getLong("lockstage.id"), v -> v, (v1, v2) -> v1));
    }

    private Map<Long, List<DynamicObject>> buildStageAllConvertDataMap(List<DynamicObject> allConvertData, Map<Long, List<DynamicObject>> stageMergeControlMap) {
        HashMap<Long, List<DynamicObject>> returnDataMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject convertRecord : allConvertData) {
            long mergeStatusId = convertRecord.getLong("id");
            List stageControlList = stageMergeControlMap.getOrDefault(mergeStatusId, new ArrayList());
            Map<Long, List<DynamicObject>> stageDataMap = stageControlList.stream().collect(Collectors.groupingBy(m -> m.getLong("lockstage.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : stageDataMap.entrySet()) {
                long lockStageId = entry.getKey();
                List tmpList = returnDataMap.getOrDefault(lockStageId, new ArrayList());
                tmpList.addAll((Collection)entry.getValue());
                returnDataMap.put(lockStageId, tmpList);
            }
        }
        return returnDataMap;
    }

    private Map<Long, StageMcStatus> buildStageMergeStatus(DynamicObject ecData, DynamicObject pcData, Map<Long, List<DynamicObject>> stageMergeControlMap, Map<Long, List<DynamicObject>> stageAllConvertDataMap) {
        long pcMergeStatusId;
        StageMcStatus stageMcStatus;
        String lockStageNumber;
        long lockStageId;
        List stageControlList;
        long ecMergeStatusId;
        HashMap<Long, StageMcStatus> stageMcStatusMap = new HashMap<Long, StageMcStatus>(16);
        if (stageMergeControlMap.isEmpty()) {
            return stageMcStatusMap;
        }
        if (ecData != null && (ecMergeStatusId = ecData.getLong("id")) > 0L) {
            stageControlList = stageMergeControlMap.getOrDefault(ecMergeStatusId, new ArrayList());
            for (DynamicObject stageControl : stageControlList) {
                lockStageId = stageControl.getLong("lockstage.id");
                lockStageNumber = stageControl.getString("lockstage.number");
                stageMcStatus = (StageMcStatus)stageMcStatusMap.get(lockStageId);
                if (stageMcStatus == null) {
                    stageMcStatus = new StageMcStatus(lockStageId);
                }
                String ecStageFlow = stageControl.getString("flowstatus");
                stageMcStatus.setStageNumber(lockStageNumber);
                stageMcStatus.setEcAction(stageControl.getString("flowtask.action"));
                stageMcStatus.setEcFlowStatus(ecStageFlow);
                stageMcStatus.setEcFlowTaskId(stageControl.getLong("flowtask.id"));
                stageMcStatusMap.put(lockStageId, stageMcStatus);
            }
        }
        if (pcData != null && (pcMergeStatusId = pcData.getLong("id")) > 0L) {
            stageControlList = stageMergeControlMap.getOrDefault(pcMergeStatusId, new ArrayList());
            for (DynamicObject stageControl : stageControlList) {
                lockStageId = stageControl.getLong("lockstage.id");
                lockStageNumber = stageControl.getString("lockstage.number");
                stageMcStatus = (StageMcStatus)stageMcStatusMap.get(lockStageId);
                if (stageMcStatus == null) {
                    stageMcStatus = new StageMcStatus(lockStageId);
                }
                String pcStageFlow = stageControl.getString("flowstatus");
                stageMcStatus.setStageNumber(lockStageNumber);
                stageMcStatus.setPcAction(stageControl.getString("flowtask.action"));
                stageMcStatus.setPcFlowStatus(pcStageFlow);
                stageMcStatus.setPcFlowTaskId(stageControl.getLong("flowtask.id"));
                stageMcStatusMap.put(lockStageId, stageMcStatus);
            }
        }
        if (!stageAllConvertDataMap.isEmpty()) {
            for (Map.Entry entry : stageMcStatusMap.entrySet()) {
                Long lockStageId2 = (Long)entry.getKey();
                StageMcStatus stageMcStatus2 = (StageMcStatus)entry.getValue();
                List convertDataList = stageAllConvertDataMap.getOrDefault(lockStageId2, new ArrayList(10));
                boolean isAny = convertDataList.stream().anyMatch(o -> "C".equals(o.getString("flowstatus")) || StageOpTypeEnum.APPR.getCode().equals(o.getString("flowtask.action")) && "B".equals(o.getString("flowstatus")));
                stageMcStatus2.setExistOneConvertSubmit(isAny);
            }
        }
        return stageMcStatusMap;
    }

    public DynamicObject getEcData() {
        return this.ecData;
    }

    public DynamicObject getPcData() {
        return this.pcData;
    }

    public List<DynamicObject> getAllConvertData() {
        return this.allConvertData;
    }

    public Map<Long, StageMcStatus> getStageMergeStatusMap() {
        return this.stageMergeStatusMap;
    }

    public Map<Long, DynamicObject> getEcStageDataMap() {
        return this.ecStageDataMap;
    }

    public Map<Long, DynamicObject> getPcStageDataMap() {
        return this.pcStageDataMap;
    }

    public Map<Long, List<DynamicObject>> getStageAllConvertDataMap() {
        return this.stageAllConvertDataMap;
    }

    public McStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public IDNumberTreeNode getOrgNode() {
        return this.orgNode;
    }

    public List<DynamicObject> getEcStageMergeDataList() {
        return this.ecStageMergeDataList;
    }

    public List<DynamicObject> getPcStageMergeDataList() {
        return this.pcStageMergeDataList;
    }
}

