/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;

public class OrgNode {
    private Long id;
    private String number;
    private Long cslscheme = 0L;
    private boolean isLeaf = false;
    private boolean isShare = false;
    private Long level;
    private String EC;
    private String PC;
    private boolean hasExtend = false;
    private List<OrgNode> directChildren = new ArrayList<OrgNode>(0);
    private Object parentId;
    private String parent;
    @JsonProperty(value="isSkipMerge")
    private boolean isSkipMerge = false;
    @JsonProperty(value="mergeType")
    private MergeDataSourceEnum mergeType = MergeDataSourceEnum.SIRpt;
    @JsonIgnore
    public static final String SELECTOR = "id,number,isleaf,storagetype,level,currency.number,parent.id,parent.number,aggoprt,cslscheme.id";

    @JsonCreator
    public OrgNode(@JsonProperty(value="id") Long id, @JsonProperty(value="number") String number, @JsonProperty(value="isLeaf") boolean isLeaf, @JsonProperty(value="isShare") boolean isShare, @JsonProperty(value="level") Long level, @JsonProperty(value="EC") String EC, @JsonProperty(value="PC") String PC, @JsonProperty(value="parentId") Object parentId, @JsonProperty(value="parent") String parent) {
        this.id = id;
        this.number = number;
        this.isLeaf = isLeaf;
        this.isShare = isShare;
        this.level = level;
        this.EC = EC;
        this.PC = PC;
        this.parentId = parentId;
        this.parent = parent;
    }

    @JsonIgnore
    public String getRelaWithParent() {
        return this.parent + "_" + this.number;
    }

    @JsonIgnore
    public String[] getChildrenRelaWithParent() {
        return Lists.transform(this.directChildren, OrgNode::getRelaWithParent).toArray(new String[0]);
    }

    @JsonIgnore
    public PairList<Long, String> getMergeChildrenRelaWithParentPair() {
        PairList plist = new PairList();
        for (OrgNode n : this.directChildren) {
            if (n.isSkipMerge()) continue;
            plist.addPair((Object)n.getId(), (Object)n.getRelaWithParent());
        }
        return plist;
    }

    @JsonIgnore
    public String[] getNoSkipAggOprtChildrenRelaWithParent() {
        ArrayList pNumbers = new ArrayList();
        this.directChildren.forEach(c -> {
            if (!c.isSkipMerge) {
                pNumbers.add(c.getRelaWithParent());
            }
        });
        return pNumbers.toArray(new String[0]);
    }

    @JsonIgnore
    public String[] getChildrenNums() {
        return Lists.transform(this.directChildren, OrgNode::getNumber).toArray(new String[0]);
    }

    @JsonIgnore
    public String[] getNoSkipAggOprtChildrenNums() {
        ArrayList pNumbers = new ArrayList();
        this.directChildren.forEach(c -> {
            if (!c.isSkipMerge) {
                pNumbers.add(c.getNumber());
            }
        });
        return pNumbers.toArray(new String[0]);
    }

    @JsonProperty(value="id")
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="number")
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="isLeaf")
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @JsonProperty(value="children")
    public List<OrgNode> getChildren() {
        return this.directChildren;
    }

    public void setChildren(List<OrgNode> children) {
        this.directChildren = children;
    }

    @JsonProperty(value="isShare")
    public boolean isShare() {
        return this.isShare;
    }

    @JsonProperty(value="level")
    public Long getLevel() {
        return this.level;
    }

    @JsonProperty(value="EC")
    public String getEC() {
        return this.EC;
    }

    @JsonProperty(value="PC")
    public String getPC() {
        return this.PC;
    }

    public void setCslscheme(Long cslscheme) {
        this.cslscheme = cslscheme;
    }

    public Long getCslscheme() {
        return this.cslscheme;
    }

    @JsonIgnore
    public String getCslCurrency() {
        return this.PC == null ? this.EC : this.PC;
    }

    @JsonProperty(value="parent")
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parentNum) {
        this.parent = parentNum;
    }

    @JsonProperty(value="parentId")
    public Object getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="isSkipMerge")
    public boolean isSkipMerge() {
        return this.isSkipMerge;
    }

    public void setSkipMerge(boolean isSkipMerge) {
        this.isSkipMerge = isSkipMerge;
    }

    public MergeDataSourceEnum getMergeType() {
        return this.mergeType;
    }

    public void setMergeType(MergeDataSourceEnum mergeType) {
        this.mergeType = mergeType;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean hasExtend() {
        return this.hasExtend;
    }

    public void setExtend(boolean hasExtend) {
        this.hasExtend = hasExtend;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static OrgNode cast2Self(String json) {
        try {
            return (OrgNode)JSONUtils.cast((String)json, OrgNode.class);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

