/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.model;

import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class Status {
    private String statusCode;
    private String action;

    protected Status(String statusCode) {
        this.statusCode = statusCode;
    }

    public Status(String statusCode, String action) {
        this.statusCode = statusCode;
        this.action = action;
    }

    public String getStatus() {
        return this.statusCode;
    }

    public boolean isNone() {
        return StringUtils.isBlank((CharSequence)this.statusCode);
    }

    public boolean isNeeded() {
        return "B".equals(this.statusCode) || "A".equals(this.statusCode) || "E".equals(this.statusCode) || "F".equals(this.statusCode) || StringUtils.isBlank((CharSequence)this.statusCode);
    }

    public boolean isSuccess() {
        return "C".equals(this.statusCode);
    }

    public boolean isProcessing() {
        return "Z".equals(this.statusCode);
    }

    public boolean isFlowSubmit() {
        return "C".equals(this.statusCode);
    }

    public boolean isApproval() {
        return StageOpTypeEnum.APPR.getCode().equals(this.action) && "B".equals(this.statusCode);
    }

    public boolean isArchive() {
        return "D".equals(this.statusCode);
    }

    public boolean isSubmitOrApproval() {
        return "C".equals(this.statusCode) || this.isApproval();
    }

    public boolean isSubmitOrArchive() {
        return "C".equals(this.statusCode) || this.isArchive();
    }

    public boolean isSubmit() {
        return this.isDataLock();
    }

    private boolean isDataLock() {
        return "C".equals(this.statusCode) || this.isApproval();
    }
}

