/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service;

import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.exception.BcmCslException;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.allinone.service.IAggSpecialScopeAdd;
import kd.fi.bcm.business.allinone.service.IExecuteService;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.allinone.service.thread.ProcessStatusHeartBeatChecker;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.script.AggScriptBuilder;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.ScriptDebugLogInfoUtil;

public abstract class AbstractExecuteService
implements IExecuteService {
    protected WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());
    protected static final String KEY_SCOPE = "SCOPE_4_AllInOne";
    protected ExecuteContext _ctx;
    protected McStatus status;
    protected MergeData mergeData;
    protected OrgNode orgNode;
    private BizRuleExecuteService bizRuleSrv;
    protected boolean isExistMultiGAAP = false;
    protected boolean isExistDataSort = false;
    protected boolean isExistMyCompany = false;
    public StringBuilder logCollector = new StringBuilder();
    protected boolean isExistExtDimension = false;
    private DynamicObject processObj = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeService(ExecuteContext ctx) {
        this._ctx = ctx;
        this.logger.startWatch();
        ThreadCache.put((Object)"cache_node_prefix", (Object)("" + ctx.getProgressId()));
        ThreadCache.put((Object)"all_in_one_thread", (Object)true);
        try {
            this.initEnv();
            this.initMergeControlData();
            if (!this.willSkipExecuteService()) {
                this.beforeExecuteService();
                this.doExecuteService();
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]-\u8d22\u5e74[%s]\u671f\u95f4[%2$s]\u8df3\u8fc7\u6267\u884c\u3002", (String)"AbstractExecuteService_6", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getOrg().getNumber(), this._ctx.getFy().getNumber(), this._ctx.getPeriod().getNumber()));
            }
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u6267\u884c\u65f6\u51fa\u73b0\u5f02\u5e38\u3002 ", (String)"AbstractExecuteService_7", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getOrg().getNumber());
            this.logger.error(msg, (Throwable)e);
            this.collectLog(e);
            throw new BcmCslException(msg, e);
        }
        finally {
            block39: {
                this.afterExecuteService();
                if (ctx.isNeedOutputLog() && (ctx.getBizRuleLogInfos().length() > 0 || this.logCollector.length() > 0 || ctx.isEntryCtx() || ctx.isSingleCalc())) {
                    try (DLock currentLock = DLock.create((String)("Process-Lock" + ctx.getProgressId()));){
                        if (!currentLock.tryLock(3000L)) break block39;
                        try {
                            this.saveProcessRecord(ctx);
                        }
                        finally {
                            currentLock.unlock();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("All_in_One get DLock Exception.-" + ctx.getOrg().number, (Throwable)e);
                        this.saveProcessRecord(ctx);
                    }
                }
            }
            if (!ctx.isEntryCtx()) {
                ProcessStatusHeartBeatChecker.updateHeartBeat(ctx.getProgressId());
            }
        }
        this.logger.infoEnd(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u6574\u4e2a\u6267\u884c\u8017\u65f6\u3002", (String)"AbstractExecuteService_8", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getOrg().number));
    }

    protected abstract void beforeExecuteService();

    protected abstract void afterExecuteService();

    protected abstract void doExecuteService();

    protected boolean willSkipExecuteService() {
        long progressId = this._ctx.getProgressId();
        String number = this._ctx.getOrg().number;
        return (Boolean)ThreadCache.get((Object)(number + "" + progressId), () -> {
            boolean isAbort = AbortThreadHelper.isAbortMergerProcess(progressId);
            if (isAbort) {
                String log = this.getRuleLogInfo(number);
                log = log + "\n ###############" + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u8fdb\u7a0b\u5df2\u88ab\u7ec8\u6b62", (String)"AbstractExecuteService_3", (String)"fi-bcm-business", (Object[])new Object[0]), number) + "##############\n";
                AppCacheServiceHelper.put(this.packCacheKey(number), log);
            }
            return isAbort;
        });
    }

    protected void initEnv() {
        if (this.orgNode == null) {
            OrgBuilder build = OrgBuilder.build((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
            this.orgNode = build.genOrgNode((Long)this._ctx.getOrg().getId());
        }
        if (this.orgNode.getEC() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u9ed8\u8ba4\u5e01\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u9ed8\u8ba4\u5e01\u3002", (String)"AbstractExecuteService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
        }
        if (this.orgNode.getLevel() > 2L && this.orgNode.getPC() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7%s\u6298\u7b97\u5e01\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e0a\u7ea7\u9ed8\u8ba4\u5e01\u3002", (String)"AbstractExecuteService_5", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getParent()));
        }
        this.status = this.getStatus();
        List<String> dimensionNums = QueryDimensionServiceHelper.getDimensionNums((Long)this._ctx.getModel().getId());
        for (String number : dimensionNums) {
            if (PresetConstant.RULE_DIM.equals(number)) {
                this.isExistMultiGAAP = true;
                continue;
            }
            if (PresetConstant.DATASORT_DIM.equals(number)) {
                this.isExistDataSort = true;
                continue;
            }
            if (!PresetConstant.MYCOMPANY_DIM.equals(number)) continue;
            this.isExistMyCompany = true;
        }
        QFilter qf = new QFilter("model", "=", this._ctx.getModel().getId());
        this.isExistExtDimension = QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])qf.toArray());
    }

    protected void initMergeControlData() {
        this.mergeData = this.loadMergeData();
    }

    public McStatus getStatus() {
        return this.loadMergeData().getMergeStatus();
    }

    protected MergeData loadMergeData() {
        Long modelId = (Long)this._ctx.getModel().getId();
        Long scenarioId = (Long)this._ctx.getScenario().getId();
        Long fyId = (Long)this._ctx.getFy().getId();
        Long periodId = (Long)this._ctx.getPeriod().getId();
        Long orgId = (Long)this._ctx.getOrg().getId();
        return MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, fyId, periodId, orgId);
    }

    protected boolean executeBizRule(List<String> processes, String currency) {
        return this.getBizRuleExecuteService().executeRule(processes, currency);
    }

    protected boolean executeBizRule(String process, String currency) {
        return this.getBizRuleExecuteService().executeRule(process, currency);
    }

    protected boolean executeMultiOrgBizRule(List<String> processes, String currency, PairList<Long, String> orgNums) {
        return this.getBizRuleExecuteService().executeMultiOrgRule(processes, currency, orgNums);
    }

    protected BizRuleExecuteService getBizRuleExecuteService() {
        if (this.bizRuleSrv == null) {
            this.bizRuleSrv = new BizRuleExecuteService(this._ctx, this.orgNode);
        }
        return this.bizRuleSrv;
    }

    protected void executeAggRule(PairList<String, String> aggDims, IAggSpecialScopeAdd specialScope) {
        AggScriptBuilder builder = this.buildAggScript(aggDims, specialScope);
        builder.setNeedUpdateDataStatus(false);
        OlapServiceHelper.excuteAggScript(this._ctx.getModel().getNumber(), builder);
    }

    protected PairList<String, String> getNormalAggDims(boolean isOnlyAggAt, String modelNum) {
        PairList aggDims = new PairList();
        if (MemberReader.isExistAuditTrailDimension((String)modelNum)) {
            aggDims.addPair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)PresetConstant.AUDITTRIAL_DIM);
        }
        if (!isOnlyAggAt) {
            if (MemberReader.isExistChangeTypeDimension((String)modelNum)) {
                aggDims.addPair((Object)PresetConstant.CHANGETYPE_DIM, (Object)PresetConstant.CHANGETYPE_DIM);
            }
            aggDims.addPair((Object)PresetConstant.INTERNALCOMPANY_DIM, (Object)PresetConstant.INTERNALCOMPANY_DIM);
            DimensionServiceHelper.getUserDefineDimensionNumListByModel(this._ctx.getModel().getId()).forEach(e -> aggDims.addPair(e, e));
            if (this.isExistMultiGAAP) {
                aggDims.addPair((Object)PresetConstant.RULE_DIM, (Object)PresetConstant.RULE_DIM);
            }
            if (this.isExistDataSort) {
                aggDims.addPair((Object)PresetConstant.DATASORT_DIM, (Object)PresetConstant.DATASORT_DIM);
            }
            if (this.isExistMyCompany) {
                aggDims.addPair((Object)PresetConstant.MYCOMPANY_DIM, (Object)PresetConstant.MYCOMPANY_DIM);
            }
            aggDims.addPair((Object)PresetConstant.ACCOUNT_DIM, (Object)PresetConstant.ACCOUNT_DIM);
        }
        return aggDims;
    }

    protected void collectLog(Throwable exception) {
        if (this.logCollector.length() > 10000) {
            return;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]\u6267\u884c\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a %2$s", (String)"AbstractExecuteService_9", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getOrg().getNumber(), ThrowableHelper.toString((Throwable)exception));
        this.logCollector.append(msg).append("\n\r");
    }

    public void saveProcessRecord(ExecuteContext ctx) {
        long progressId = ctx.getProgressId();
        if (progressId == 0L) {
            return;
        }
        DynamicObject updateObj = null;
        String operateLogResult = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        if (this.logCollector.length() > 0) {
            updateObj = this.getMergeProcessDynamic(progressId);
            if (!this.isLimitMaxSize(progressId)) {
                updateObj.set("failedlog", (Object)(updateObj.getString("failedlog") + this.logCollector.toString()));
            }
            updateObj.set("fstatus", (Object)ProgressStatusEnum.FAIL.getCode());
            operateLogResult = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        if (ctx.getBizRuleLogInfos().length() > 0) {
            String log = this.getRuleLogInfo(ctx.getOrg().number);
            AppCacheServiceHelper.put(this.packCacheKey(ctx.getOrg().number), log + ctx.getBizRuleLogInfos());
            ctx.removeBizRuleLogInfos();
        }
        if (ctx.isEntryCtx() || ctx.isSingleCalc()) {
            updateObj = this.getMergeProcessDynamic(progressId);
            StringBuilder ruleLogs = new StringBuilder(500);
            OrgBuilder build = OrgBuilder.build((Long)ctx.getModel().getId(), (Long)ctx.getScenario().getId(), (Long)ctx.getFy().getId(), (Long)ctx.getPeriod().getId());
            OrgNode rootNode = build.genOrgNode((Long)ctx.getOrg().getId());
            build.extendAllChildren(rootNode);
            this.buildRuleLog(rootNode, !ctx.isSingleCalc(), ruleLogs);
            String s = ruleLogs.toString();
            updateObj.set("bizrulelog", (Object)(updateObj.getString("bizrulelog") + s));
            if (AbortThreadHelper.isAbortMergerProcess(this._ctx.getProgressId())) {
                updateObj.set("fstatus", (Object)ProgressStatusEnum.TERMINATION.getCode());
                operateLogResult = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ec8\u6b62", (String)"AbstractExecuteService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
            } else {
                updateObj.set("fstatus", (Object)(StringUtils.isNotEmpty((String)updateObj.getString("failedlog")) ? ProgressStatusEnum.FAIL.getCode() : ProgressStatusEnum.SUCCESS.getCode()));
            }
            this.removeCacheLog(rootNode);
            updateObj.set("endtime", (Object)TimeServiceHelper.now());
            MergeTaskTypeEnum taskTypeEnum = MergeTaskTypeEnum.getEnumByValue((String)updateObj.getString("tasktype"));
            if (taskTypeEnum == MergeTaskTypeEnum.OneKeyMerge) {
                String mergeScope = ctx.isMergeAll() ? ResManager.loadKDString((String)"\u5408\u5e76\u6267\u884c\u8303\u56f4\uff08\u6240\u6709\u4e0b\u7ea7\uff09", (String)"AbstractExecuteService_10", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u5e76\u6267\u884c\u8303\u56f4\uff08\u5f53\u524d\u7ec4\u7ec7\u53ca\u76f4\u63a5\u4e0b\u7ea7\uff09", (String)"AbstractExecuteService_11", (String)"fi-bcm-business", (Object[])new Object[0]);
                String opDescription = updateObj.getString("orgid.number") + updateObj.getString("orgid.name") + " " + ctx.getFy().number + " " + ctx.getPeriod().number + " " + mergeScope + taskTypeEnum.getText() + operateLogResult;
                OperationLogUtil.writeOperationLog(taskTypeEnum.getText(), opDescription, updateObj.getLong("issueid.id"), "bcm_mergecontrollist");
            }
        }
        if (updateObj != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
        }
    }

    private DynamicObject getMergeProcessDynamic(long progressId) {
        if (this.processObj == null) {
            this.processObj = BusinessDataServiceHelper.loadSingle((Object)progressId, (String)"bcm_mergeprogressentity");
        }
        return this.processObj;
    }

    private boolean isLimitMaxSize(long progressId) {
        DynamicObject updateObj = this.getMergeProcessDynamic(progressId);
        String failedlog = updateObj.getString("failedlog");
        return StringUtils.isNotEmpty((String)failedlog) && failedlog.length() >= 100000;
    }

    protected String packCacheKey(String orgNumber) {
        return this._ctx.getProgressId() + "|" + orgNumber;
    }

    private void removeCacheLog(OrgNode rootNode) {
        if (rootNode.isLeaf()) {
            AppCacheServiceHelper.remove(this.packCacheKey(rootNode.getNumber()));
            ScriptDebugLogInfoUtil.removeCollectLogs((String)this.packCacheKey(rootNode.getNumber()));
        } else {
            rootNode.getChildren().forEach(this::removeCacheLog);
        }
    }

    private void buildRuleLog(OrgNode node, boolean isRoot, StringBuilder ruleLogs) {
        if (node.isLeaf() && !isRoot) {
            ruleLogs.append(this.getRuleLogInfo(node.getNumber()));
        } else {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)((Long)this._ctx.getModel().getId()), (Long)((Long)this._ctx.getOrg().getId()));
            if (node.getNumber().equals(org.getNumber())) {
                String condition = String.format("isMergeAll[%s], isForceExec[%s], isSkipEcRule[%s], isSkipPcRule[%s], isSkipCheck[%s], isSkipInvElim[%s], isSkipCommPaperElim[%s], isSkipIntrElim[%s]", this._ctx.isMergeAll(), this._ctx.isForceExec(), this._ctx.isSkipEcRule(), this._ctx.isSkipPcRule(), this._ctx.isSkipCheck(), this._ctx.isSkipInvElim(), this._ctx.isSkipCommPaperElim(), this._ctx.isSkipIntrElim());
                ruleLogs.append("******").append(condition).append("******").append("\n\n");
                this.addLineFlag(ruleLogs, false);
                ruleLogs.append(String.format("Entry Org Longnumber[%s]", org.getLongNumber()));
                this.addLineFlag(ruleLogs, true);
                ruleLogs.append("\n");
            }
            this.addLineFlag(ruleLogs, false);
            ruleLogs.append(String.format("all_in_one[%s,%s,%s,%s]start", org.getNumber(), this._ctx.getFy().number, this._ctx.getPeriod().number, this._ctx.getScenario().number));
            this.addLineFlag(ruleLogs, true);
            node.getChildren().forEach(n -> this.buildRuleLog((OrgNode)n, false, ruleLogs));
            ruleLogs.append(this.getRuleLogInfo(node.getNumber()));
            this.addLineFlag(ruleLogs, false);
            ruleLogs.append(String.format("all_in_one[%s,%s,%s,%s]end", node.getNumber(), this._ctx.getFy().number, this._ctx.getPeriod().number, this._ctx.getScenario().number));
            this.addLineFlag(ruleLogs, true);
        }
    }

    private void addLineFlag(StringBuilder ruleLogs, boolean withNewLine) {
        ruleLogs.append("********************************");
        if (withNewLine) {
            ruleLogs.append("\n");
        }
    }

    private String getRuleLogInfo(String orgNum) {
        String log = AppCacheServiceHelper.get(this.packCacheKey(orgNum), String.class);
        return StringUtils.isNotEmpty((String)log) ? log : "";
    }

    private AggScriptBuilder buildAggScript(PairList<String, String> aggDims, IAggSpecialScopeAdd specialScope) {
        AggScriptBuilder builder = new AggScriptBuilder(KEY_SCOPE, aggDims);
        builder.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getFy().number);
        builder.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number);
        builder.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenario().number);
        specialScope.accept(builder);
        return builder;
    }
}

