/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.IBizRuleExecuteService;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BizRuleCatalogEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BcmTransferException;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.util.ScriptDebugLogInfoUtil;

public class BizRuleExecuteService
implements IBizRuleExecuteService {
    private ExecuteContext ctx;
    private OrgNode orgNode;
    private List<Pair<Long, String>> commonRuleList;
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BizRuleExecuteService.class);
    private boolean isAllInOneTask = false;

    public BizRuleExecuteService(ExecuteContext ctx, OrgNode orgNode) {
        this.ctx = ctx;
        this.orgNode = orgNode;
        this.isAllInOneTask = this.isAllInOneTask();
    }

    public BizRuleExecuteService(ExecuteContext ctx) {
        this.ctx = ctx;
        this.isAllInOneTask = this.isAllInOneTask();
    }

    @Override
    public boolean executeCommonRule(String process, String currency) {
        return this.executeMultiOrgCommonRule(process, currency, (PairList<Long, String>)PairList.newWithParam((Object)this.getOrgId(), (Object)this.getOrgNumber()));
    }

    @Override
    public boolean executeMultiOrgCommonRule(String process, String currency, PairList<Long, String> orgNums) {
        ArrayList<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>(10);
        bizRuleList.addAll(this.getCommonRuleList());
        if (bizRuleList.isEmpty()) {
            return false;
        }
        this.doExecute(bizRuleList, process, currency, orgNums);
        return true;
    }

    @Override
    public boolean executeRule(List<String> processes, String currency) {
        return this.executeMultiOrgRule(processes, currency, (PairList<Long, String>)PairList.newWithParam((Object)this.getOrgId(), (Object)this.getOrgNumber()));
    }

    @Override
    public boolean executeRule(List<String> processes, String currency, BizRuleExecuteTypeEnum executeType) {
        return this.executeMultiOrgRule(processes, currency, (PairList<Long, String>)PairList.newWithParam((Object)this.getOrgId(), (Object)this.getOrgNumber()), Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{executeType}));
    }

    @Override
    public boolean executeRuleMultiRuleExecuteType(List<String> processes, String currency, Set<BizRuleExecuteTypeEnum> bizRuleExecuteTypeSet) {
        if (bizRuleExecuteTypeSet.isEmpty()) {
            return this.executeMultiOrgRule(processes, currency, (PairList<Long, String>)PairList.newWithParam((Object)this.getOrgId(), (Object)this.getOrgNumber()), Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{BizRuleExecuteTypeEnum.ALL}));
        }
        return this.executeMultiOrgRule(processes, currency, (PairList<Long, String>)PairList.newWithParam((Object)this.getOrgId(), (Object)this.getOrgNumber()), bizRuleExecuteTypeSet);
    }

    private String getOrgNumber() {
        if (this.orgNode == null) {
            return this.ctx.getOrg().getNumber();
        }
        return this.orgNode.getNumber();
    }

    private Long getOrgId() {
        if (this.orgNode == null) {
            return (Long)this.ctx.getOrg().getId();
        }
        return this.orgNode.getId();
    }

    @Override
    public boolean executeRule(String process, String currency) {
        return this.executeRule(Lists.newArrayList((Object[])new String[]{process}), currency);
    }

    @Override
    public boolean executeMultiOrgRule(List<String> processes, String currency, PairList<Long, String> orgNums, Set<BizRuleExecuteTypeEnum> executeTypeSet) {
        boolean hasExecuteRule = false;
        for (String process : processes) {
            ArrayList<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>(10);
            if (BizRuleCatalogEnum.Normal.getNumber().equals(process)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u901a\u7528\u89c4\u5219\u8bf7\u4f7f\u7528executeCommonRule()\u63a5\u53e3\u3002", (String)"BizRuleExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            bizRuleList.addAll(this.getBizRuleList(this.ctx, process, executeTypeSet));
            if (bizRuleList.isEmpty()) continue;
            this.doExecute(bizRuleList, process, currency, orgNums);
            hasExecuteRule = true;
        }
        return hasExecuteRule;
    }

    @Override
    public boolean executeMultiOrgRule(List<String> processes, String currency, PairList<Long, String> orgNums) {
        return this.executeMultiOrgRule(processes, currency, orgNums, Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{BizRuleExecuteTypeEnum.ALL}));
    }

    public boolean executeSpecialRule(String queryCatalog, String usedCatalog, String currency, PairList<Long, String> orgNums) {
        boolean hasExecuteRule = false;
        ArrayList<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>(10);
        bizRuleList.addAll(this.getBizRuleList(this.ctx, queryCatalog));
        if (!bizRuleList.isEmpty()) {
            hasExecuteRule = true;
            this.doExecute(bizRuleList, usedCatalog, currency, orgNums);
        }
        return hasExecuteRule;
    }

    private void doExecute(List<Pair<Long, String>> bizRuleList, String process, String currency, PairList<Long, String> orgNums) {
        HashMap num2IdMap = Maps.newHashMapWithExpectedSize((int)orgNums.size());
        boolean isRelaProcess = OrgRelaProcessMembPool.isRelaProcess((String)process);
        for (Pair p : orgNums.toList()) {
            String orgNum = (String)p.p2;
            if (isRelaProcess && !((String)p.p2).contains("_")) {
                orgNum = MemberReader.findEntityMemberById((String)this.ctx.getModel().number, (Long)((Long)p.p1)).getVirtualEntity();
            }
            num2IdMap.put(orgNum, p.p1);
        }
        BizRuleExecParam param = null;
        StringBuffer err = new StringBuffer();
        ArrayList<List<BizRuleExecParam>> excuteParamList = new ArrayList<List<BizRuleExecParam>>(num2IdMap.size());
        for (Map.Entry e : num2IdMap.entrySet()) {
            ArrayList<BizRuleExecParam> excuteParams = new ArrayList<BizRuleExecParam>(num2IdMap.size());
            param = new BizRuleExecParam(this.ctx.getModel().number);
            param.setBizRuleList(bizRuleList);
            param.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, (Long)e.getValue(), (String)e.getKey()).addCommonParamPair(PresetConstant.FY_DIM, (Long)this.ctx.getFy().id, this.ctx.getFy().number).addCommonParamPair(PresetConstant.PERIOD_DIM, (Long)this.ctx.getPeriod().id, this.ctx.getPeriod().number).addCommonParamPair(PresetConstant.SCENE_DIM, (Long)this.ctx.getScenario().id, this.ctx.getScenario().number).addCommonParamPair(PresetConstant.CURRENCY_DIM, MemberReader.findCurrencyMemberByNum((String)this.ctx.getModel().number, (String)currency).getId(), currency);
            param.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findMemberByNumber((String)this.ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)process).getId(), process);
            excuteParams.add(param);
            excuteParamList.add(excuteParams);
        }
        this.runInThread(excuteParamList, err, bizRuleList);
        if (err.length() > 0) {
            throw new BcmTransferException(err.toString());
        }
    }

    private void runInThread(List<List<BizRuleExecParam>> bizRuleParamList, StringBuffer errMsg, List<Pair<Long, String>> bizRuleList) {
        StringBuffer logInfos = new StringBuffer();
        if (bizRuleParamList.size() > 1) {
            CountDownLatch latch = new CountDownLatch(bizRuleParamList.size());
            for (List<BizRuleExecParam> p : bizRuleParamList) {
                ThreadPoolService.runInSyncThread(() -> {
                    try {
                        this.executeScript(p, errMsg, logInfos, bizRuleList);
                    }
                    catch (Exception e) {
                        errMsg.append(ThrowableHelper.toString((Exception)e));
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                errMsg.append(ThrowableHelper.toString((Exception)e));
            }
        } else if (bizRuleParamList.size() == 1) {
            this.executeScript(bizRuleParamList.get(0), errMsg, logInfos, bizRuleList);
        }
        String processId = (String)ThreadCache.get((Object)"cache_node_prefix");
        if (this.isAllInOneTask && logInfos.length() > 0) {
            ScriptDebugLogInfoUtil.collectLog2Cache((String)(processId + "|" + this.ctx.getOrg().number), (String)logInfos.toString());
        }
    }

    private void executeScript(List<BizRuleExecParam> excuteParams, StringBuffer err, StringBuffer logInfos, List<Pair<Long, String>> bizRuleList) {
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(this.ctx.getModel().number, excuteParams, null, true);
        if (result != null && !result.isEmpty()) {
            result.forEach((key, value) -> err.append((String)value));
        }
        if (this.isAllInOneTask) {
            String logInfo = ScriptDebugLogInfoUtil.formatBizLogInfo((String)excuteParams.get(0).getCommonParam().toString(), (Collection)Lists.transform(bizRuleList, br -> (Long)br.p1));
            logInfos.append(logInfo);
        }
    }

    private boolean isAllInOneTask() {
        String processId = (String)ThreadCache.get((Object)"cache_node_prefix");
        return StringUtils.isNotEmpty((String)processId);
    }

    private List<Pair<Long, String>> getCommonRuleList() {
        if (this.commonRuleList == null) {
            this.commonRuleList = this.getBizRuleList(this.ctx, "Normal");
        }
        return this.commonRuleList;
    }

    private List<Pair<Long, String>> getBizRuleList(ExecuteContext ctx, String process) {
        return this.getBizRuleList(ctx, process, Sets.newHashSet((Object[])new BizRuleExecuteTypeEnum[]{BizRuleExecuteTypeEnum.ALL}));
    }

    private List<Pair<Long, String>> getBizRuleList(ExecuteContext ctx, String process, Set<BizRuleExecuteTypeEnum> executeTypeSet) {
        boolean isFalse = false;
        ArrayList<Pair<Long, String>> list = new ArrayList<Pair<Long, String>>(10);
        QFilter filter = new QFilter("bizrule.deletestatus", "=", (Object)isFalse);
        Set executeTypeCodeSet = executeTypeSet.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toSet());
        filter.and("bizrule.executetype", "in", executeTypeCodeSet);
        if (ctx.isFromRpt() && (SysMembConstant.isEquals((String)"EIRpt", (String)process) || SysMembConstant.isEquals((String)"IRpt", (String)process))) {
            filter.and(new QFilter("bizrule.id", "in", BizRuleExecStarter.getRuleByTmp(ctx.getTempids())));
        }
        QFilter filter2 = filter;
        Collection rules = BizRuleServiceHelper.getBizRule((String)ctx.getModel().number, f -> f.add(filter2), (String[])new String[]{process});
        rules.forEach(e -> {
            if (StringUtils.isNotEmpty((String)e.getString("bizrule.content"))) {
                list.add(Pair.onePair((Object)e.getLong("bizrule.id"), (Object)e.getString("bizrule.content")));
            }
        });
        return list;
    }

    public void setTemplateIds(List<Long> templateIds) {
        this.ctx.setTempids(templateIds);
    }

    public void setFromRpt(boolean isFromRpt) {
        this.ctx.setFromRpt(isFromRpt);
    }
}

