/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.ProgressCacheHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class MergeProgressHelper {
    private MergeProgressHelper() {
        throw new IllegalStateException("Illegal Class Constructor");
    }

    public static void updateStatus(String status, List<Long> ids) {
        StringBuilder sql = new StringBuilder();
        sql.append("update t_bcm_mergeprogress set fstatus =");
        sql.append(status);
        if (ProgressStatusEnum.TERMINATION.getCode().equals(status)) {
            String errmsg = ResManager.loadKDString((String)"'\u7a0b\u5e8f\u610f\u5916\u7ec8\u6b62\uff0c\u8bf7\u91cd\u8bd5\u3002'", (String)"PlatformPermUpgradeService_8", (String)"fi-bcm-business", (Object[])new Object[0]);
            sql.append(",ffailedlog=").append(errmsg);
            sql.append(",fbizrulelog=").append(errmsg);
        }
        sql.append(" where fid in (");
        for (Long lr : ids) {
            sql.append(lr).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        DB.update((DBRoute)DBRoute.of((String)"bcm"), (String)sql.toString());
    }

    public static Pair<Integer, Integer> getFinishedCount(Long progressId) {
        return ProgressCacheHelper.getProcess(progressId);
    }

    public static ResultBox checkTipsUser(String userName, String orgNumber, String orgName) {
        ResultBox result = ResultBox.of();
        result.add(String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u6267\u884c\u201c %2$s: %3$s\u201d\u7ec4\u7ec7\u7684\u5408\u5e76\u4efb\u52a1\uff0c\u4e0e\u5f53\u524d\u5408\u5e76\u4efb\u52a1\u91cd\u53e0\u65e0\u6cd5\u6267\u884c", (String)"MergeProgressHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), userName, orgNumber, orgName));
        return result;
    }

    public static DynamicObjectCollection queryProgress(String select, QFBuilder qf) {
        return QueryServiceHelper.query((String)"bcm_mergeprogressentity", (String)select, (QFilter[])qf.toArray());
    }

    public static boolean hasMergeExecute(long modelId) {
        QFilter qf = new QFilter("issueid", "=", (Object)modelId);
        qf.and("fstatus", "in", Arrays.asList(ProgressStatusEnum.PROCESSING.getCode(), ProgressStatusEnum.TERMING.getCode()));
        qf.and("deletestatus", "!=", (Object)1);
        qf.and("tasktype", "=", (Object)MergeTaskTypeEnum.OneKeyMerge.getCode());
        qf.and("begintime", ">=", (Object)MergeProgressHelper.getCurrentTimeBeforeDayByConfig());
        return QueryServiceHelper.exists((String)"bcm_mergeprogressentity", (QFilter[])new QFilter[]{qf});
    }

    public static ResultBox checkOnProcessing(long modelId, long orgId, long scenarioId, long yearId, long periodId) {
        ResultBox result = ResultBox.of();
        DynamicObjectCollection executeRecords = MergeProgressHelper.findExecuteRecord(modelId, scenarioId, yearId, periodId);
        if (CollectionUtils.isEmpty((Collection)executeRecords)) {
            return result;
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String longNumber = orgNode.getLongNumber();
        String baseLongNumber = orgNode.getBaseTreeNode() == null ? longNumber : orgNode.getBaseTreeNode().getLongNumber();
        String compareCopyLongNumber = null;
        for (DynamicObject record : executeRecords) {
            long execOrgId = record.getLong("orgid.id");
            IDNumberTreeNode execOrgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)execOrgId);
            String compareLongNumber = execOrgNode.getLongNumber();
            if (execOrgNode.getCopyfromId() > 0L) {
                compareCopyLongNumber = execOrgNode.getBaseTreeNode().getLongNumber();
            }
            if (longNumber.contains(compareLongNumber) || baseLongNumber.contains(compareLongNumber) || compareLongNumber.contains(longNumber) || compareLongNumber.contains(baseLongNumber)) {
                result.append(MergeProgressHelper.checkTipsUser(record.getString("userid.name"), record.getString("orgid.number"), record.getString("orgid.name")));
            }
            if (!StringUtils.isNotEmpty((String)compareCopyLongNumber) || !longNumber.contains(compareCopyLongNumber) && !baseLongNumber.contains(compareCopyLongNumber) && !compareCopyLongNumber.contains(longNumber) && !compareCopyLongNumber.contains(baseLongNumber)) continue;
            result.append(MergeProgressHelper.checkTipsUser(record.getString("userid.name"), record.getString("orgid.number"), record.getString("orgid.name")));
        }
        return result;
    }

    private static DynamicObjectCollection findExecuteRecord(long modelId, long scenarioId, long yearId, long periodId) {
        QFilter filter = new QFilter("issueid", "=", (Object)modelId);
        filter.and("scenarioid", "=", (Object)scenarioId);
        filter.and("yearid", "=", (Object)yearId);
        filter.and("periodid", "=", (Object)periodId);
        filter.and("fstatus", "in", Arrays.asList(ProgressStatusEnum.PROCESSING.getCode(), ProgressStatusEnum.TERMING.getCode()));
        filter.and("tasktype", "=", (Object)Character.valueOf('1'));
        filter.and("deletestatus", "!=", (Object)1);
        filter.and("begintime", ">=", (Object)MergeProgressHelper.getCurrentTimeBeforeDayByConfig());
        return QueryServiceHelper.query((String)"bcm_mergeprogressentity", (String)"id,orgid.id,orgid.number,orgid.longnumber,orgid.name,userid.id,userid.name", (QFilter[])filter.toArray());
    }

    public static DynamicObject getMergeProgress(long progressId) {
        QFBuilder qf = new QFBuilder("id", "=", (Object)progressId);
        return QueryServiceHelper.queryOne((String)"bcm_mergeprogressentity", (String)"id,fstatus,begintime,endtime", (QFilter[])qf.toArray());
    }

    public static Date getCurrentTimeBeforeDayByConfig() {
        Date now = TimeServiceHelper.now();
        String days = ConfigServiceHelper.getStringParamNoModel("checkBeforeDay");
        if (StringUtils.isEmpty((String)days)) {
            return DateTimeUtils.getDayAround((Date)now, (int)-1);
        }
        return DateTimeUtils.getDayAround((Date)now, (int)(-Integer.parseInt(days)));
    }
}

