/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service;

import kd.bos.dlock.DLock;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ThrowableHelper;

public class ProgressCacheHelper {
    public static final String KEY_PROCESS = "MergeCount$";

    public static void initProcess(long id) {
        String key = KEY_PROCESS + id;
        if (AppCacheServiceHelper.get(key) == null) {
            AppCacheServiceHelper.put(key, "0,0");
        }
    }

    public static void setProcess(long id, boolean isLeaf) {
        try {
            ProgressCacheHelper.resetProcess(id, isLeaf);
        }
        catch (Exception ex) {
            try {
                ProgressCacheHelper.resetProcess(id, isLeaf);
            }
            catch (Exception e) {
                ErrorLogServiceHelper.saveErrorLog(id, "MergeSetProcess", "", ThrowableHelper.getThreadTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetProcess(long id, boolean isLeaf) {
        block19: {
            String key = KEY_PROCESS + id;
            try (DLock lock = DLock.create((String)key);){
                if (!lock.tryLock(3000L)) break block19;
                try {
                    if (AppCacheServiceHelper.get(key) == null) {
                        int leafCount = isLeaf ? 1 : 0;
                        int orgCount = isLeaf ? 0 : 1;
                        AppCacheServiceHelper.put(key, leafCount + "," + orgCount);
                    } else {
                        String value = (String)AppCacheServiceHelper.get(key);
                        String[] split = value.split(",");
                        int leafCount = Integer.parseInt(split[0]);
                        int orgCount = Integer.parseInt(split[1]);
                        if (isLeaf) {
                            ++leafCount;
                        } else {
                            ++orgCount;
                        }
                        AppCacheServiceHelper.put(key, leafCount + "," + orgCount);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public static void resetProcessNoLock(long id, int leafCount, int mergeCount) {
        String key = KEY_PROCESS + id;
        AppCacheServiceHelper.put(key, leafCount + "," + mergeCount);
    }

    public static void removeProcess(Long id) {
        AppCacheServiceHelper.remove(KEY_PROCESS + id);
    }

    public static Pair<Integer, Integer> getProcess(Long id) {
        String key = KEY_PROCESS + id;
        if (AppCacheServiceHelper.get(key) != null) {
            String value = (String)AppCacheServiceHelper.get(key);
            String[] split = value.split(",");
            int leafFinishedCount = Integer.parseInt(split[0]);
            int subFinishedCount = Integer.parseInt(split[1]);
            return Pair.onePair((Object)leafFinishedCount, (Object)subFinishedCount);
        }
        return Pair.onePair((Object)-1, (Object)-1);
    }
}

