/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.csl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.AbstractExecuteService;
import kd.fi.bcm.business.allinone.service.IAggSpecialScopeAdd;
import kd.fi.bcm.business.allinone.service.ProgressCacheHelper;
import kd.fi.bcm.business.allinone.service.thread.AbortThreadHelper;
import kd.fi.bcm.business.allinone.service.thread.JVMShutdownHook;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.business.script.AggScriptBuilder;
import kd.fi.bcm.business.script.ScopeBuilder;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.util.BcmTransferException;
import kd.fi.bcm.computing.ScopeInfo;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractCslExecuteService
extends AbstractExecuteService {
    protected boolean willBeSkipExecute = false;
    protected boolean willBeSkipExecuteNotUpdateStatus = false;
    protected DynamicObject ecData;
    protected DynamicObject pcData;
    protected boolean needDoCvt;
    private static Set<String> setMergeDimNumberSet = new HashSet<String>(Arrays.asList(PresetConstant.ACCOUNT_DIM, PresetConstant.CHANGETYPE_DIM, PresetConstant.RULE_DIM, PresetConstant.DATASORT_DIM));

    protected AbstractCslExecuteService(OrgNode orgNode) {
        this.orgNode = orgNode;
    }

    @Override
    public void executeService(ExecuteContext ctx) {
        this._ctx = ctx;
        if (MergeControlHelper.isQuoteLocked((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), (Long)this._ctx.getOrg().getId())) {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)this._ctx.getModel().getNumber(), (Long)((Long)this._ctx.getScenario().getId()));
            Long quoteSceneId = (Long)sceneNode.getProperty("scenequote.id");
            if (quoteSceneId != null && quoteSceneId > 0L) {
                IDNumberTreeNode quoteSceneNode = MemberReader.findScenaMemberById((String)this._ctx.getModel().getNumber(), (Long)quoteSceneId);
                if (quoteSceneNode != IDNumberTreeNode.NotFoundTreeNode) {
                    ctx.setScenario(SimpleItem.newOne(quoteSceneNode.getId(), quoteSceneNode.getNumber()));
                }
            } else {
                return;
            }
        }
        String traceKey = String.format("AllMerge:%s|%s|%s|%s", ctx.getFy().getNumber(), ctx.getPeriod().getNumber(), ctx.getScenario().getNumber(), ctx.getOrg().getNumber());
        TraceSpan span = Tracer.create((String)traceKey, (String)"AllMerge");
        Throwable throwable = null;
        if (span != null) {
            if (throwable != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                span.close();
            }
        }
        super.executeService(ctx);
    }

    @Override
    protected void initMergeControlData() {
        super.initMergeControlData();
        if (this.mergeData != null) {
            this.ecData = this.mergeData.getEcData();
            this.pcData = this.mergeData.getPcData();
        }
    }

    @Override
    protected void beforeExecuteService() {
        if (this._ctx.isMergeAll() && !ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().getId(), "isNewDispatcher")) {
            try {
                this.wait4Processing();
            }
            catch (Exception e) {
                this.logger.error("wait4Processing error: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void afterExecuteService() {
        this.logger.startWatch();
        try {
            if (this.willSkipExecuteService() && this.willBeSkipExecute) {
                if (this.logCollector.length() == 0) {
                    this.updateStatusWhenSkill("C");
                } else {
                    this.updateStatusWhenSkill("E");
                }
            }
            this.updateMergeControlData();
        }
        catch (Exception e) {
            this.logger.error("All_in_One updateStatus Exception.-" + this._ctx.getOrg().number, (Throwable)e);
            this.collectLog(e);
        }
        finally {
            if (!(ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().getId(), "isNewDispatcher") || !this.orgNode.isLeaf() && this._ctx.isCsl())) {
                ProgressCacheHelper.setProcess(this._ctx.getProgressId(), this.orgNode.isLeaf());
            }
        }
        if (this._ctx.isEntryCtx()) {
            try {
                ProgressCacheHelper.removeProcess(this._ctx.getProgressId());
                JVMShutdownHook.removeMonitorProgress(this._ctx.getProgressId());
                MsServiceHelper.invalidateAllCurrOutlineCache((String)String.valueOf(this._ctx.getProgressId()));
                MsServiceHelper.invokeInvalidateOutlineCache((String)String.valueOf(this._ctx.getProgressId()));
                if (ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().getId(), "CM029")) {
                    this.checkUp();
                }
                this.sendMessageByCalc();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                this.collectLog(e);
            }
        }
        this.logger.infoEnd(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c[afterExecuteService]\u8017\u65f6", (String)"AbstractCslExecuteService_11", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
    }

    @Override
    protected boolean willSkipExecuteService() {
        this.willBeSkipExecute = !this.isExistsData4DetailEntity();
        this.willBeSkipExecuteNotUpdateStatus = super.willSkipExecuteService() || this.status.getPcFlow().isSubmit() || this.status.getArchive().isArchive() || this.status.getFlow().isSubmit() && this.orgNode.getEC().equals(this.orgNode.getPC()) || !OlapDataVerifyServiceHelper.checkPeriodOpenStatus((Long)this._ctx.getModel().getId(), this._ctx.getModel().getNumber(), this._ctx.getOrg().getNumber(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
        return this.willBeSkipExecute || this.willBeSkipExecuteNotUpdateStatus;
    }

    protected IAggSpecialScopeAdd addSpecialDimensionScope() {
        return this::addCslCommonScope;
    }

    protected void addCslCommonScope(AggScriptBuilder ss) {
        if (this.orgNode.isLeaf()) {
            ss.addDimensionScope(PresetConstant.CURRENCY_DIM, this.orgNode.getCslCurrency());
            ss.addDimensionScope(PresetConstant.ENTITY_DIM, this.orgNode.getRelaWithParent());
        } else {
            ss.addDimensionScope(PresetConstant.CURRENCY_DIM, this._ctx.isCsl() ? this.orgNode.getCslCurrency() : this.orgNode.getEC());
            ss.addDimensionScope(PresetConstant.ENTITY_DIM, this._ctx.isCsl() ? this.orgNode.getRelaWithParent() : this.orgNode.getNumber());
        }
    }

    protected void calculateContribution() {
        this.calculateARpt();
        if (MemberReader.isDynamicStorageType((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"CC")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String relaWithParent = this.orgNode.getRelaWithParent();
        PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"CC"), relaWithParent);
        ArrayList<PairList<String, String>> combine = new ArrayList<PairList<String, String>>(3);
        List<PairList<String, String>> eje = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EJE"), relaWithParent);
        combine.addAll(eje);
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"ARPT") == IDNumberTreeNode.NotFoundTreeNode) {
            List<PairList<String, String>> pc = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"PC"), relaWithParent);
            List<PairList<String, String>> adj = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ADJ"), relaWithParent);
            combine.addAll(pc);
            combine.addAll(adj);
        } else {
            List<PairList<String, String>> arpt = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ARPT"), relaWithParent);
            List<PairList<String, String>> cadj = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"CADJ"), relaWithParent);
            combine.addAll(arpt);
            combine.addAll(cadj);
        }
        sb.append(this.wrapRunFunction(this.buildEquation(left, combine))).append(';');
        this.executeTheRunScript(sb.toString());
    }

    protected void calculateRpt() {
        if (MemberReader.isDynamicStorageType((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"Rpt")) {
            return;
        }
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"Rpt") != IDNumberTreeNode.NotFoundTreeNode) {
            this.executeAggRule((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"Rpt"), ss -> {});
        }
    }

    private void calculateARpt() {
        if (MemberReader.isDynamicStorageType((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"ARPT")) {
            return;
        }
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"ARPT") != IDNumberTreeNode.NotFoundTreeNode) {
            String relaWithParent = this.orgNode.getRelaWithParent();
            PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ARPT"), relaWithParent);
            List<PairList<String, String>> adj = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ADJ"), relaWithParent);
            List<PairList<String, String>> rpt = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"Rpt"), this.orgNode.getNumber());
            ArrayList<PairList<String, String>> combine = new ArrayList<PairList<String, String>>(2);
            combine.addAll(adj);
            combine.addAll(rpt);
            this.executeTheRunScript(this.wrapRunFunction(this.buildEquation(left, combine)) + ';');
        }
    }

    private boolean isExistsData4DetailEntity() {
        if (ConfigServiceHelper.getGlobalBoolParam("notSkipNoDataOrg")) {
            return true;
        }
        if (!this.orgNode.isLeaf()) {
            return true;
        }
        SQLBuilder sql = new SQLBuilder(this._ctx.getModel().number);
        sql.addFilter(PresetConstant.ENTITY_DIM, this.orgNode.getNumber(), this.orgNode.getRelaWithParent());
        sql.addFilter(PresetConstant.FY_DIM, this._ctx.getFy().number);
        sql.addFilter(PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number);
        sql.addFilter(PresetConstant.SCENE_DIM, this._ctx.getScenario().number);
        sql.setTop(1);
        sql.addSelectField(PresetConstant.ENTITY_DIM);
        return OlapServiceHelper.queryData(sql).getFetchSize() > 0;
    }

    protected void doCalcBizRule() {
        if (this.willExecByStatus(true, this._ctx.isSkipEcRule())) {
            WatchLoggerUtil.logTime(this.logger, () -> this.getBizRuleExecuteService().executeRule(Lists.newArrayList((Object[])new String[]{"EIRpt", "ERAdj"}), this.orgNode.getEC()), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u5408\u5e76\u6267\u884c[\u62a5\u8868\u8ba1\u7b97]\u8017\u65f6", (String)"AbstractCslExecuteService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            this.saveOrgCacheByCalc();
        }
    }

    protected void doConvert() {
        if (this.needDoCvt || !this._ctx.isSkipPcRule() || this.willExecByStatus(false, this._ctx.isSkipPcRule())) {
            BaseData baseData;
            boolean isAutoConvert;
            this.executeConvert();
            if (ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().getId(), "isPeriodOrYDT") && this.orgNode.getPC() != null && !this.orgNode.getEC().equals(this.orgNode.getPC()) && this.status.getPcFlow().isNeeded() && (isAutoConvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData = new BaseData((Long)this._ctx.getModel().getId(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod()), SimpleVo.newOne(this._ctx.getOrg())).booleanValue())) {
                ConvertServiceHelper.generateDataOfCurrPeriodOrYDT(SimpleItem.toPair(this._ctx.getModel()), SimpleItem.toPair(this._ctx.getOrg()), SimpleItem.toPair(this._ctx.getFy()), SimpleItem.toPair(this._ctx.getPeriod()), SimpleItem.toPair(this._ctx.getScenario()), (Pair<Long, String>)Pair.onePair(null, (Object)this.orgNode.getPC()), false);
            }
        }
    }

    protected String wrapRunFunction(String script) {
        return "run(SCOPE_4_AllInOne,\"" + script + "\")";
    }

    protected List<PairList<String, String>> buildRight(PairList<String, String> vs, String ... orgs) {
        return this.buildV(vs, orgs);
    }

    protected PairList<String, String> buildLeft(PairList<String, String> vs, String ... orgs) {
        return this.buildV(vs, orgs).get(0);
    }

    protected List<PairList<String, String>> buildV(PairList<String, String> vs, String ... orgs) {
        ArrayList<PairList<String, String>> pairs = new ArrayList<PairList<String, String>>(orgs.length);
        for (String org : orgs) {
            PairList p = new PairList();
            p.addPair((Object)PresetConstant.ENTITY_DIM, (Object)org);
            vs.forEach(e -> p.addPair(e.p1, e.p2));
            pairs.add((PairList<String, String>)p);
        }
        return pairs;
    }

    protected String buildEquation(PairList<String, String> left, List<PairList<String, String>> right) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildVParameter(left));
        sb.append('=');
        for (PairList<String, String> v : right) {
            sb.append(this.buildVParameter(v));
            sb.append('+');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    protected void executeTheRunScript(String script) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("SCOPE_4_AllInOne", this.getFullScopeInfo());
        params.put("sourceType", OlapSourceEnum.C1.getType());
        OlapServiceHelper.excuteScript(this._ctx.getModel().number, script, params);
    }

    protected ScopeInfo getFullScopeInfo() {
        boolean isNotFilterMember;
        ScopeBuilder ss = this.genRunScriptScope();
        Long modelId = (Long)this._ctx.getModel().getId();
        Set<String> allDimNumberSet = this.getAllDimNumberByModel(modelId);
        Recorder changeTypeRecorder = new Recorder((Object)Boolean.TRUE);
        ArrayList<String> mergeChangeTypes = new ArrayList<String>(MergeControlHelper.getMergeChangeType(modelId));
        List<String> allUserDefineDimNumList = MergeControlHelper.getUserDefineDimensionNumListByModel(modelId);
        if (this._ctx.isFromRpt() && this._ctx.isContainNotMergeMember()) {
            ss.getScopes().forEach(scope -> {
                if (scope.getDimNum().equals(PresetConstant.CHANGETYPE_DIM)) {
                    changeTypeRecorder.setRecord((Object)Boolean.FALSE);
                    mergeChangeTypes.retainAll(Arrays.asList(scope.getScope()));
                    scope.setScope(mergeChangeTypes.toArray(new String[0]));
                }
            });
            if (allDimNumberSet.contains(PresetConstant.CHANGETYPE_DIM) && ((Boolean)changeTypeRecorder.getRecord()).booleanValue()) {
                ss.addDimensionScope(PresetConstant.CHANGETYPE_DIM, mergeChangeTypes.toArray(new String[0]));
            }
            this.removeEmptyScopeDim(ss, allUserDefineDimNumList);
            return ss.genScopeInfo();
        }
        ArrayList<String> mergeAccounts = new ArrayList<String>(MergeControlHelper.getMergeAccounts(modelId));
        Recorder accountRecorder = new Recorder((Object)Boolean.TRUE);
        Recorder mgRecorder = new Recorder((Object)Boolean.TRUE);
        Recorder dsRecorder = new Recorder((Object)Boolean.TRUE);
        HashSet hasDealUserDefineDimSet = new HashSet(6);
        ss.getScopes().forEach(scope -> {
            boolean isNotFilterMember;
            if (scope.getDimNum().equals(PresetConstant.ACCOUNT_DIM)) {
                accountRecorder.setRecord((Object)Boolean.FALSE);
                mergeAccounts.retainAll(Arrays.asList(scope.getScope()));
                scope.setScope(mergeAccounts.toArray(new String[0]));
            }
            if (scope.getDimNum().equals(PresetConstant.CHANGETYPE_DIM)) {
                changeTypeRecorder.setRecord((Object)Boolean.FALSE);
                mergeChangeTypes.retainAll(Arrays.asList(scope.getScope()));
                scope.setScope(mergeChangeTypes.toArray(new String[0]));
            }
            if (!(isNotFilterMember = ConfigServiceHelper.getBoolParam(modelId, "isNotFilterMember"))) {
                if (scope.getDimNum().equals(PresetConstant.RULE_DIM)) {
                    mgRecorder.setRecord((Object)Boolean.FALSE);
                    ArrayList<String> mergeMultiGAAP = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), PresetConstant.RULE_DIM));
                    mergeMultiGAAP.retainAll(Arrays.asList(scope.getScope()));
                    scope.setScope(mergeMultiGAAP.toArray(new String[0]));
                }
                if (scope.getDimNum().equals(PresetConstant.DATASORT_DIM)) {
                    dsRecorder.setRecord((Object)Boolean.FALSE);
                    ArrayList<String> mergeDataSort = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), PresetConstant.DATASORT_DIM));
                    mergeDataSort.retainAll(Arrays.asList(scope.getScope()));
                    scope.setScope(mergeDataSort.toArray(new String[0]));
                }
                if (allUserDefineDimNumList.contains(scope.getDimNum())) {
                    hasDealUserDefineDimSet.add(scope.getDimNum());
                    ArrayList<String> mergeUserDefine = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), scope.getDimNum()));
                    mergeUserDefine.retainAll(Arrays.asList(scope.getScope()));
                    scope.setScope(mergeUserDefine.toArray(new String[0]));
                }
            }
        });
        if (((Boolean)accountRecorder.getRecord()).booleanValue() && this.checkDimExistNoMergeMember(this._ctx.getModel().getNumber(), PresetConstant.ACCOUNT_DIM)) {
            ss.addDimensionScope(PresetConstant.ACCOUNT_DIM, mergeAccounts.toArray(new String[0]));
        }
        if (allDimNumberSet.contains(PresetConstant.CHANGETYPE_DIM) && ((Boolean)changeTypeRecorder.getRecord()).booleanValue()) {
            ss.addDimensionScope(PresetConstant.CHANGETYPE_DIM, mergeChangeTypes.toArray(new String[0]));
        }
        if (!(isNotFilterMember = ConfigServiceHelper.getBoolParam(modelId, "isNotFilterMember"))) {
            ArrayList<String> dataSortMergeMembers;
            ArrayList<String> ruleMergeMembers;
            if (allDimNumberSet.contains(PresetConstant.RULE_DIM) && ((Boolean)mgRecorder.getRecord()).booleanValue() && this.checkDimExistNoMergeMember(this._ctx.getModel().getNumber(), PresetConstant.RULE_DIM) && !(ruleMergeMembers = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), PresetConstant.RULE_DIM))).isEmpty()) {
                ss.addDimensionScope(PresetConstant.RULE_DIM, ruleMergeMembers.toArray(new String[0]));
            }
            if (allDimNumberSet.contains(PresetConstant.DATASORT_DIM) && ((Boolean)dsRecorder.getRecord()).booleanValue() && this.checkDimExistNoMergeMember(this._ctx.getModel().getNumber(), PresetConstant.DATASORT_DIM) && !(dataSortMergeMembers = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), PresetConstant.DATASORT_DIM))).isEmpty()) {
                ss.addDimensionScope(PresetConstant.DATASORT_DIM, dataSortMergeMembers.toArray(new String[0]));
            }
            for (String userDefineDim : allUserDefineDimNumList) {
                ArrayList<String> userDefineMergeMembers;
                if (hasDealUserDefineDimSet.contains(userDefineDim) || !this.checkDimExistNoMergeMember(this._ctx.getModel().getNumber(), userDefineDim) || (userDefineMergeMembers = new ArrayList<String>(MergeControlHelper.getMergeMembers(this._ctx.getModel().getNumber(), userDefineDim))).isEmpty()) continue;
                ss.addDimensionScope(userDefineDim, userDefineMergeMembers.toArray(new String[0]));
            }
        }
        if (this._ctx.isFromRpt()) {
            this.removeEmptyScopeDim(ss, allUserDefineDimNumList);
        }
        return ss.genScopeInfo();
    }

    private void removeEmptyScopeDim(ScopeBuilder scopeBuilder, List<String> allUserDefineDimNumList) {
        Iterator<ScopeBuilder.DimensionScopeInfo> iterator = scopeBuilder.getScopes().iterator();
        while (iterator.hasNext()) {
            int scopeCount;
            ScopeBuilder.DimensionScopeInfo scope = iterator.next();
            if (setMergeDimNumberSet.contains(scope.getDimNum()) || allUserDefineDimNumList.contains(scope.getDimNum()) || (scopeCount = scope.getScope().length) != 0) continue;
            iterator.remove();
        }
    }

    private Set<String> getAllDimNumberByModel(long modelId) {
        Pair modelDimIDAndNumberMapPair = MemberReader.getModelDimIDAndNumberMap((long)modelId);
        Map idToNumberMap = (Map)modelDimIDAndNumberMapPair.p1;
        return new HashSet<String>(idToNumberMap.values());
    }

    private boolean checkDimExistNoMergeMember(String modelNumber, String dimNumber) {
        List<String> noMergeMembers = MergeControlHelper.getNoMergeMembersForAllInOneMerge(modelNumber, dimNumber);
        return !noMergeMembers.isEmpty();
    }

    protected abstract ScopeBuilder genRunScriptScope();

    protected PairList<String, String> getAggDims(String modelNumber) {
        PairList<String, String> aggDims = this.getNormalAggDims(true, modelNumber);
        if (this.orgNode.isLeaf()) {
            aggDims.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"EJE");
        } else {
            aggDims.addPair((Object)PresetConstant.PROCESS_DIM, (Object)(this._ctx.isCsl() ? "EJE" : "CT"));
        }
        return aggDims;
    }

    protected void executeAdjAndElimBizRule() {
        if (!"Entity".equals(this.orgNode.getParent())) {
            this.executeBizRule(MergeControlHelper.getUnitProcess((Long)this._ctx.getModel().getId()), this.orgNode.getPC());
        }
    }

    private boolean willExecByStatus(boolean isEC, boolean isSkipExec) {
        boolean isCalcNeed;
        boolean isFlowNeed;
        if (isEC) {
            isFlowNeed = !this.status.getFlow().isSubmitOrApproval();
            isCalcNeed = this.status.getCalculate().isNeeded();
        } else {
            isFlowNeed = !this.status.getPcFlow().isSubmitOrApproval();
            isCalcNeed = this.status.getConvert().isNeeded();
        }
        this.logger.info(String.format("org[%s] willExecByStatus params: isEC=%s,isFlowNeed=%s,isCalcNeed=%s,isSkipExec=%s", this.orgNode.getNumber(), isEC, isFlowNeed, isCalcNeed, isSkipExec));
        if (isFlowNeed) {
            if (isCalcNeed) {
                return true;
            }
            return !isSkipExec;
        }
        return false;
    }

    private String buildVParameter(PairList<String, String> p) {
        StringBuilder str = new StringBuilder();
        str.append("v('");
        p.forEach(e -> str.append(String.format("%s%s%s,", e.p1, "@", e.p2)));
        str.deleteCharAt(str.length() - 1);
        str.append("')");
        return str.toString();
    }

    private void executeConvert() {
        if (this.orgNode.getLevel() <= 2L) {
            this.logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u9876\u7ea7\u8282\u70b9\u4e0d\u6298\u7b97\u3002", (String)"AbstractCslExecuteService_14", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            return;
        }
        if (this.orgNode.getEC().equals(this.orgNode.getPC())) {
            this.logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u76f8\u540c\u5e01\u79cd\u4e0d\u6298\u7b97", (String)"AbstractCslExecuteService_15", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            return;
        }
        this.updateConvertStatus("Z", true);
        BaseData baseData = new BaseData((Long)this._ctx.getModel().getId(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod());
        PairList<Long, String> cvtPaths = ConvertServiceHelper.getOrgConvertPath(baseData, SimpleVo.newOne(this._ctx.getOrg()));
        this._ctx.setNowPaths(cvtPaths.toList());
        try {
            if (CollectionUtils.isEmpty((Collection)cvtPaths.toList())) {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u5408\u5e76\u4e0d\u5b58\u5728\u6298\u7b97\u8def\u5f84\uff0c\u53ea\u6267\u884c\u89c4\u5219", (String)"AbstractCslExecuteService_17", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                this.getBizRuleExecuteService().executeRule(Arrays.asList("IRpt", "RAdj"), this.orgNode.getPC());
            } else {
                Pair<Long, String> model = SimpleItem.toPair(this._ctx.getModel());
                Pair<Long, String> entity = SimpleItem.toPair(this._ctx.getOrg());
                Pair<Long, String> fy = SimpleItem.toPair(this._ctx.getFy());
                Pair<Long, String> period = SimpleItem.toPair(this._ctx.getPeriod());
                Pair<Long, String> scenario = SimpleItem.toPair(this._ctx.getScenario());
                if (CollectionUtils.isNotEmpty(this._ctx.getTempids())) {
                    for (long tmplId : this._ctx.getTempids()) {
                        Set<String> msg = ConvertServiceHelper.convertByPath(tmplId, (List<Pair<Long, String>>)cvtPaths.toList(), model, entity, fy, period, scenario);
                        this._ctx.appendErrorMsg(msg);
                    }
                } else {
                    Set<String> msg = ConvertServiceHelper.convertByPath(cvtPaths.toList(), model, entity, fy, period, scenario, false, this._ctx.isForceExec());
                    this._ctx.appendErrorMsg(msg);
                }
            }
            this.updateConvertStatus("C", false);
        }
        catch (Exception e) {
            this.collectLog(e);
            this.logger.error(e.getMessage(), (Throwable)e);
            this.updateConvertStatus("E", false);
        }
    }

    private void checkUp() {
        if (this.logCollector.length() == 0 && !AbortThreadHelper.isAbortMergerProcess(this._ctx.getProgressId())) {
            ThreadPoolService.runInThreadForMergeChk(() -> {
                FixedItem fixedItem = FixedItem.newOne(this._ctx.getModel(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod());
                DynamicObject obj = MergeControlService.getInstance().saveProgressInfo(fixedItem, (Long)this._ctx.getOrg().getId(), MergeTaskTypeEnum.CheckUp.getCode(), true, this._ctx.isMergeAll());
                MergeControlService.getInstance().checkUpChk(fixedItem, this._ctx.getOrg(), obj.getLong("id"), true, "0", this._ctx.isMergeAll());
            });
        }
    }

    protected void generateDataOfCurrPeriodOrYDT() {
        if (this.orgNode.getEC() != null && this.status.getFlow().isNeeded()) {
            ConvertServiceHelper.generateDataOfCurrPeriodOrYDT(SimpleItem.toPair(this._ctx.getModel()), SimpleItem.toPair(this._ctx.getOrg()), SimpleItem.toPair(this._ctx.getFy()), SimpleItem.toPair(this._ctx.getPeriod()), SimpleItem.toPair(this._ctx.getScenario()), (Pair<Long, String>)Pair.onePair(null, (Object)this.orgNode.getEC()), false);
        }
    }

    protected void updateCalculateStatus(String status, boolean isBegin) {
        if (this.ecData != null) {
            if (!this.orgNode.isLeaf()) {
                this.ecData.set("mergestatus", (Object)status);
            }
            this.ecData.set("calculatestatus", (Object)status);
            if (isBegin) {
                this.ecData.set("begintime", (Object)TimeServiceHelper.now());
                this.ecData.set("endtime", null);
            } else {
                this.ecData.set("chkstatus", (Object)"B");
                this.ecData.set("endtime", (Object)TimeServiceHelper.now());
            }
            this.ecData.set("progressid", (Object)this._ctx.getProgressId());
        }
    }

    protected void updateConvertStatus(String status, boolean isBegin) {
        if (this.pcData != null) {
            if (!this.orgNode.isLeaf()) {
                this.pcData.set("mergestatus", (Object)status);
            }
            this.pcData.set("calculatestatus", (Object)status);
            if (isBegin) {
                this.pcData.set("begintime", (Object)TimeServiceHelper.now());
                this.pcData.set("endtime", null);
            } else {
                this.pcData.set("chkstatus", (Object)"B");
                this.pcData.set("endtime", (Object)TimeServiceHelper.now());
            }
            this.pcData.set("progressid", (Object)this._ctx.getProgressId());
        }
    }

    private void updateStatusWhenSkill(String status) {
        if (this.ecData != null && this.needUpdateCalStatus()) {
            if (!this.orgNode.isLeaf()) {
                this.ecData.set("mergestatus", (Object)status);
            }
            this.ecData.set("calculatestatus", (Object)status);
            this.ecData.set("progressid", (Object)this._ctx.getProgressId());
        }
        if (this.pcData != null) {
            if (!this.orgNode.isLeaf()) {
                this.pcData.set("mergestatus", (Object)status);
            }
            this.pcData.set("calculatestatus", (Object)status);
            this.pcData.set("progressid", (Object)this._ctx.getProgressId());
        }
    }

    private void updateMergeControlData() {
        boolean isNeedPc;
        boolean isNeedEc;
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(2);
        boolean bl = isNeedEc = !this.status.getFlow().isSubmitOrApproval();
        if (this.ecData != null && isNeedEc) {
            updateList.add(this.ecData);
        }
        boolean bl2 = isNeedPc = !this.status.getPcFlow().isSubmitOrApproval();
        if (this.pcData != null && isNeedPc) {
            updateList.add(this.pcData);
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    private void updateCalculateStatusForSameControl() {
        if (this.ecData != null) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(2);
            if (!this.orgNode.isLeaf()) {
                this.ecData.set("mergestatus", (Object)"Z");
            }
            this.ecData.set("calculatestatus", (Object)"Z");
            this.ecData.set("progressid", (Object)this._ctx.getProgressId());
            updateList.add(this.ecData);
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    protected void doExtDataConvert() {
        ResultBox resultBox;
        long modelId = (Long)this._ctx.getModel().getId();
        boolean isConvertExtend = ConfigServiceHelper.getBoolParam(modelId, "isConvertExtend");
        if (isConvertExtend && this.isExistExtDimension && (resultBox = ExtConvertServiceHelper.convertExtModelsForMerge(this._ctx)).isNotSuccess()) {
            String errorExtMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u5408\u5e76\u6267\u884c\u62d3\u5c55\u7ef4\u6298\u7b97\u5f02\u5e38:", (String)"AbstractCslExecuteService_16", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.collectLog((Throwable)new BcmTransferException(errorExtMsg + resultBox.getMessageText()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait4Processing() {
        if (!this._ctx.isForceExec() && (!this.orgNode.isLeaf() && this.status.getMergeStatus().isSuccess() && this.status.getCalculate().isSuccess() || this.orgNode.isLeaf() && this.status.getCalculate().isSuccess())) {
            return;
        }
        long modelId = (Long)this._ctx.getModel().getId();
        long scenarioId = (Long)this._ctx.getScenario().getId();
        long fyId = (Long)this._ctx.getFy().getId();
        long periodId = (Long)this._ctx.getPeriod().getId();
        long entryOrgId = this._ctx.getEntryOrgId();
        long orgId = (Long)this._ctx.getOrg().getId();
        long progressId = this._ctx.getProgressId();
        String orgNumber = this._ctx.getOrg().getNumber();
        Set<String> allShareNumbers = MergeControlHelper.getAllShareNumbers(modelId, entryOrgId, scenarioId, fyId, periodId);
        if (!allShareNumbers.contains(orgNumber)) {
            return;
        }
        IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        List shareNodes = org.getBaseTreeNode().getShareNodes();
        shareNodes.add(org.getBaseTreeNode());
        Set parentNumbers = shareNodes.stream().map(o -> o.getParent().getNumber()).collect(Collectors.toSet());
        Set childrenNumbers = org.getChildren().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        HashSet<String> allNumbers = new HashSet<String>(16);
        allNumbers.add(orgNumber);
        allNumbers.addAll(parentNumbers);
        allNumbers.addAll(childrenNumbers);
        int maxTimes = 50;
        long millis = 10000L;
        int i = 0;
        while (i++ < maxTimes) {
            Set<Object> onNumbers;
            block25: {
                boolean isAbort = AbortThreadHelper.isAbortMergerProcess(progressId);
                if (isAbort) {
                    return;
                }
                onNumbers = new HashSet(16);
                try (DLock lock = DLock.create((String)("MergeControlWait4Processing-" + progressId + modelId + scenarioId + fyId + periodId + orgNumber));){
                    if (!lock.tryLock(millis)) break block25;
                    try {
                        onNumbers = MergeControlHelper.batchGetMcDataInProgress(modelId, scenarioId, fyId, periodId, allNumbers, progressId);
                        if (onNumbers.isEmpty()) {
                            this.updateCalculateStatusForSameControl();
                            this.status = this.getStatus();
                            return;
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            String msg = String.format("Org [%s-%d] waiting for [%s] has on processing %d times", orgNumber, this.orgNode.getId(), Joiner.on((String)",").join(onNumbers), i);
            AppCacheServiceHelper.put(this.packCacheKey(orgNumber), "\n###############" + msg + "##############\n");
            this.logger.info(msg);
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    protected void saveOrgCacheByCalc() {
        MergeControlService.getInstance().saveOrgCacheByCalc(this._ctx.getProgressId(), this._ctx.getOrg().getNumber(), (Long)this._ctx.getModel().getId());
    }

    private void sendMessageByCalc() {
        MergeControlService.getInstance().sendMessageByCalc(this._ctx.getProgressId(), this._ctx.getEntryOrgId(), FixedItem.newOne(this._ctx.getModel(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod()));
    }

    protected boolean needUpdateCalStatus() {
        return this._ctx.isMergeAll() || !this._ctx.isMergeAll() && this._ctx.isEntryCtx();
    }
}

