/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.csl;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.csl.AbstractCslExecuteService;
import kd.fi.bcm.business.script.ScopeBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DetailOrgCslExecuteService
extends AbstractCslExecuteService {
    protected WatchLogger detailOrgLog = BcmLogFactory.getWatchLogInstance(DetailOrgCslExecuteService.class);

    public DetailOrgCslExecuteService(OrgNode orgNode) {
        super(orgNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecuteService() {
        this.detailOrgLog.startWatch();
        boolean isCsl = this._ctx.isCsl();
        if (isCsl) {
            long modelId = (Long)this._ctx.getModel().getId();
            boolean isContribution = ConfigServiceHelper.getBoolParam(modelId, "isContribution");
            if (isContribution) {
                WatchLoggerUtil.logTime(this.detailOrgLog, this::executeAdjAndElimBizRule, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u7236_\u5b50\u4e1a\u52a1\u89c4\u5219\u8017\u65f6", (String)"DetailOrgCslExecuteService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            }
        } else {
            if (this._ctx.isMergeAll() && !this.status.getFlow().isSubmitOrApproval() && (this._ctx.isForceExec() || !this._ctx.isSkipEcRule() || !this._ctx.isForceExec() && !this.status.getCalculate().isSuccess())) {
                try {
                    this.updateCalculateStatus("Z", true);
                    this.doCalcBizRule();
                    WatchLoggerUtil.logTime(this.detailOrgLog, this::generateDataOfCurrPeriodOrYDT, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u5012\u6324\u8017\u65f6", (String)"DetailOrgCslExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                    this.updateCalculateStatus("C", false);
                }
                catch (Exception e) {
                    this.detailOrgLog.error(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u8ba1\u7b97\u5931\u8d25", (String)"DetailOrgCslExecuteService_6", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()), (Throwable)e);
                    this.collectLog(e);
                    this.updateCalculateStatus("E", false);
                }
                finally {
                    this.needDoCvt = true;
                }
            }
            WatchLoggerUtil.logTime(this.detailOrgLog, this::doExtDataConvert, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u62d3\u5c55\u7ef4\u6298\u7b97\u8017\u65f6", (String)"DetailOrgCslExecuteService_5", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            if (!this.status.getPcFlow().isSubmitOrApproval()) {
                WatchLoggerUtil.logTime(this.detailOrgLog, this::doConvert, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u6298\u7b97\u8017\u65f6", (String)"DetailOrgCslExecuteService_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            }
        }
        this.detailOrgLog.infoEnd(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c[doExecuteService]\u603b\u8017\u65f6", (String)"DetailOrgCslExecuteService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
    }

    @Override
    protected ScopeBuilder genRunScriptScope() {
        ScopeBuilder ss = new ScopeBuilder();
        ss.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getFy().number);
        ss.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number);
        ss.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenario().number);
        ss.addDimensionScope(PresetConstant.CURRENCY_DIM, this.orgNode.getCslCurrency());
        return ss;
    }
}

