/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.csl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustBatchCreateCommonEntryOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.csl.AbstractCslExecuteService;
import kd.fi.bcm.business.allinone.service.helper.UnitOrgTextDataServiceHelper;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.helper.CheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.innertrade.adjust.AdjustRecordHelper;
import kd.fi.bcm.business.innertrade.report.IntrMergeHelper;
import kd.fi.bcm.business.invest.changecase.InvChangeHandleServiceHelper;
import kd.fi.bcm.business.invest.elimination.InvElimGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimPaperGenerateService;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.script.MultiDimAggCommandBuilder;
import kd.fi.bcm.business.script.ScopeBuilder;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.encrypt.Encrypt;
import kd.fi.bcm.common.encrypt.EncryptFactory;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BcmTransferException;
import kd.fi.bcm.common.util.OlapCommandUtil;

public class UnitOrgCslExecuteService
extends AbstractCslExecuteService {
    protected WatchLogger unitOrgLog = BcmLogFactory.getWatchLogInstance(UnitOrgCslExecuteService.class);

    public UnitOrgCslExecuteService(OrgNode orgNode) {
        super(orgNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecuteService() {
        this.unitOrgLog.startWatch();
        boolean isCsl = this._ctx.isCsl();
        if (isCsl) {
            long modelId = (Long)this._ctx.getModel().getId();
            boolean isContribution = ConfigServiceHelper.getBoolParam(modelId, "isContribution");
            if (isContribution && !this.orgNode.isSkipMerge()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, this::executeAdjAndElimBizRule, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u8c03\u6574\u62b5\u9500\u89c4\u5219\u8017\u65f6", (String)"UnitOrgCslExecuteService_32", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            }
        } else {
            if (!this.status.getFlow().isSubmitOrApproval() && this.needUpdateCalStatus()) {
                try {
                    boolean isExecMerge = false;
                    if (this._ctx.isForceExec() || !this._ctx.isForceExec() && !this.status.getMergeStatus().isSuccess()) {
                        block24: {
                            this.updateCalculateStatus("Z", true);
                            WatchLoggerUtil.logTime(this.unitOrgLog, this::doSum, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u8ba1\u7b97\u62a5\u8868\u6c47\u8017\u65f6", (String)"UnitOrgCslExecuteService_22", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                            Encrypt encrypt = EncryptFactory.getInstance((String)"Encrypt_Five");
                            String encryptKey = encrypt.ecode(String.format("/UnitOrgCslExecuteService/%s/%s/%s/%s/%s", this._ctx.getModel().getNumber(), this._ctx.getScenario().getNumber(), this._ctx.getFy().getNumber(), this._ctx.getPeriod().getNumber(), this.orgNode.getNumber()));
                            try (DLock lock = DLock.create((String)encryptKey);){
                                if (!lock.tryLock(36000L)) break block24;
                                try {
                                    WatchLoggerUtil.logTime(this.unitOrgLog, this::doElim, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u751f\u6210\u8c03\u6574\u62b5\u9500\u5206\u5f55\u8017\u65f6", (String)"UnitOrgCslExecuteService_23", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        }
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::doJournalContribution, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u8ba1\u7b97\u5206\u5f55\u8d21\u732e\u8017\u65f6", (String)"UnitOrgCslExecuteService_24", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::doDAdjAndDeje, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u8fc7\u7a0bDADJ\u548cDEJE\u8c03\u6574\u62b5\u9500\u8017\u65f6", (String)"UnitOrgCslExecuteService_25", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::doCsl, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u8ba1\u7b97\u51fa\u5408\u5e76\u62a5\u8868\u8017\u65f6", (String)"UnitOrgCslExecuteService_26", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        isExecMerge = true;
                        this.needDoCvt = true;
                    }
                    if (this._ctx.isForceExec() || isExecMerge || !this._ctx.isSkipEcRule() || !this._ctx.isForceExec() && !this.status.getCalculate().isSuccess()) {
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::doExecuteCsRptRule, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u5408\u5e76\u62a5\u8868\u89c4\u5219\u8017\u65f6", (String)"UnitOrgCslExecuteService_27", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::dealCwpText, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u5220\u9664CWP\u7684\u6570\u636e\u8017\u65f6", (String)"UnitOrgCslExecuteService_28", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        WatchLoggerUtil.logTime(this.unitOrgLog, this::generateDataOfCurrPeriodOrYDT, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u9ed8\u8ba4\u5e01\u5012\u6324\u8017\u65f6", (String)"UnitOrgCslExecuteService_29", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                        this.updateCalculateStatus("C", false);
                        this.needDoCvt = true;
                    }
                }
                catch (Exception e) {
                    this.unitOrgLog.error(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7[%s]\u6267\u884c\u672c\u4f4d\u5e01\u8ba1\u7b97\u5931\u8d25", (String)"UnitOrgCslExecuteService_43", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()), (Throwable)e);
                    this.collectLog(e);
                    this.updateCalculateStatus("E", false);
                }
            }
            if (!this._ctx.isEntryCtx()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, this::doExtDataConvert, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u62d3\u5c55\u7ef4\u6298\u7b97\u8017\u65f6", (String)"UnitOrgCslExecuteService_30", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                WatchLoggerUtil.logTime(this.unitOrgLog, this::doConvert, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c\u6298\u7b97\u8017\u65f6", (String)"UnitOrgCslExecuteService_31", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
            }
        }
        this.unitOrgLog.infoEnd(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\uff1a\u7ec4\u7ec7[%s]\u6267\u884c[doExecuteService]\u603b\u8017\u65f6", (String)"UnitOrgCslExecuteService_17", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
    }

    @Override
    protected ScopeBuilder genRunScriptScope() {
        ScopeBuilder ss = new ScopeBuilder();
        ss.addDimensionScope(PresetConstant.FY_DIM, this._ctx.getFy().number);
        ss.addDimensionScope(PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number);
        ss.addDimensionScope(PresetConstant.SCENE_DIM, this._ctx.getScenario().number);
        ss.addDimensionScope(PresetConstant.CURRENCY_DIM, this._ctx.isCsl() ? this.orgNode.getCslCurrency() : this.orgNode.getEC());
        if (this._ctx.isFromRpt()) {
            for (String k : this._ctx.getTmpscope().keySet()) {
                ss.addDimensionScope(k, this._ctx.getTmpscope().get(k).toArray(new String[0]));
            }
        }
        return ss;
    }

    protected void doSum() {
        if (this.orgNode.getMergeType() == MergeDataSourceEnum.CSTE) {
            if (!this._ctx.isFromRpt() && !this._ctx.isMergeSum()) {
                this.executeBizRule("CSTE", this.orgNode.getEC());
            }
            return;
        }
        String[] childrenNums = this.orgNode.getNoSkipAggOprtChildrenNums();
        if (childrenNums.length > 0) {
            this.executeSumCommand();
        } else {
            RunScriptBuilder runs = new RunScriptBuilder(this._ctx.getModel().getNumber());
            ArrayList<String> processes = new ArrayList<String>(6);
            processes.add("SRPT");
            processes.forEach(p -> this.buildEqualsNullRunScript(runs, (String)p));
            this.getFullScopeInfo().getFilters().forEach(f -> runs.addDimensionScope(f.getName(), f.getValues().toArray(new String[0])));
            runs.setSourceEnum(OlapSourceEnum.C1);
            runs.runScript();
        }
    }

    protected void doJournalContribution() {
        if (this.orgNode.getMergeType() == MergeDataSourceEnum.CSTE) {
            return;
        }
        String[] childrenNums = this.orgNode.getNoSkipAggOprtChildrenNums();
        if (childrenNums.length > 0) {
            StringBuilder script = new StringBuilder();
            script.append(this.buildEliminationScript());
            script.append(this.buildAdjustScript());
            script.append(this.buildSCADJScript());
            script.append(this.buildSCCADJScript());
            this.executeTheRunScript(script.toString());
        } else {
            RunScriptBuilder runs = new RunScriptBuilder(this._ctx.getModel().getNumber());
            ArrayList<String> processes = new ArrayList<String>(6);
            if (DimensionServiceHelper.isCM02Model((Long)this._ctx.getModel().getId())) {
                processes.add("SEJE");
            } else {
                processes.add("SECF");
                processes.add("SEIC");
                processes.add("SEIT");
                processes.add("SEOE");
                processes.add("SEOther");
            }
            processes.add("SADJ");
            processes.add("SCADJ");
            processes.add("SCCADJ");
            processes.forEach(p -> this.buildEqualsNullRunScript(runs, (String)p));
            this.getFullScopeInfo().getFilters().forEach(f -> runs.addDimensionScope(f.getName(), f.getValues().toArray(new String[0])));
            runs.setSourceEnum(OlapSourceEnum.C1);
            runs.runScript();
        }
    }

    protected void doCsl() {
        this.doCslRpt();
    }

    private List<List<String>> getUnitProcessForMerge(long modelId) {
        ArrayList<List<String>> elimProcess = new ArrayList<List<String>>(16);
        elimProcess.add(Collections.singletonList("ADJ"));
        elimProcess.add(Collections.singletonList("CADJ"));
        if (DimensionServiceHelper.isCM02Model(modelId)) {
            elimProcess.add(Collections.singletonList("EJE"));
        } else {
            elimProcess.add(Arrays.asList("EJE", "EICA", "EIT", "EOE", "ECF", "EOther"));
        }
        elimProcess.add(Collections.singletonList("CCADJ"));
        return elimProcess;
    }

    private List<List<String>> getUnitDADJAndDEJEProcesses() {
        ArrayList<List<String>> DADJAndDEJEProcess = new ArrayList<List<String>>(16);
        DADJAndDEJEProcess.add(Collections.singletonList("DADJ"));
        DADJAndDEJEProcess.add(Collections.singletonList("DEJE"));
        return DADJAndDEJEProcess;
    }

    private void doElim() {
        this.calculateRpt();
        if (!this._ctx.isSkipIntrElim()) {
            WatchLoggerUtil.logTime(this.unitOrgLog, this::doGenIntrElim, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%s]\u751f\u6210\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u8017\u65f6", (String)"UnitOrgCslExecuteService_33", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
        }
        long modelId = (Long)this._ctx.getModel().getId();
        PairList<Long, String> pair = this.orgNode.getMergeChildrenRelaWithParentPair();
        List<List<String>> elimProcess = this.getUnitProcessForMerge(modelId);
        elimProcess.forEach(p -> {
            WatchLoggerUtil.logTime(this.unitOrgLog, () -> InvChangeHandleServiceHelper.handleAfterMerge(this._ctx, p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u7ec4\u7ec7\u53d8\u52a8\u6570\u636e\u5904\u7406\u8017\u65f6", (String)"UnitOrgCslExecuteService_34", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            if (!this._ctx.isSkipCommPaperElim()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.doGenCommonPaperTmp(1, (List<String>)p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u901a\u7528\u5206\u5f55\u8017\u65f6", (String)"UnitOrgCslExecuteService_35", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            }
            if (p.contains("EJE") && !this._ctx.isSkipCheck()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, this::doChecking, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u5bf9\u8d26\u8017\u65f6", (String)"UnitOrgCslExecuteService_36", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            }
            if (!this._ctx.isSkipIntrElim()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.doGenInnerTransaction((List<String>)p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u5185\u90e8\u4ea4\u6613\u751f\u6210\u5206\u5f55\u8017\u65f6", (String)"UnitOrgCslExecuteService_37", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            }
            if (!this._ctx.isSkipInvElim()) {
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.doGenInvElim(1, (List<String>)p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u6743\u76ca\u8001\u5e95\u7a3f\u751f\u6210\u5206\u5f55\u8017\u65f6", (String)"UnitOrgCslExecuteService_38", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.doGenInvSheet((List<String>)p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u751f\u6210\u8017\u65f6", (String)"UnitOrgCslExecuteService_39", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.doGenInvSheetElim((List<String>)p), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u6743\u76ca\u5e95\u7a3f\u5206\u5f55\u751f\u6210\u8017\u65f6", (String)"UnitOrgCslExecuteService_40", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            }
            if (p.contains("ADJ") || p.contains("CADJ") || p.contains("EJE") || p.contains("CCADJ")) {
                if (p.contains("EJE") && !DimensionServiceHelper.isCM02Model((Long)this._ctx.getModel().getId())) {
                    WatchLoggerUtil.logTime(this.unitOrgLog, this::doCalcEJE, String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u6267\u884c\u62b5\u9500\u805a\u5408\u8017\u65f6", (String)"UnitOrgCslExecuteService_42", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber()));
                }
                WatchLoggerUtil.logTime(this.unitOrgLog, () -> this.executeMultiOrgBizRule((List<String>)p, this.orgNode.getEC(), pair), String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u6267\u884c\u8c03\u6574\u62b5\u9500\uff1a\u7ec4\u7ec7[%1$s]\u8fc7\u7a0b%2$s\u6267\u884c\u89c4\u5219\u8017\u65f6", (String)"UnitOrgCslExecuteService_41", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), p));
            }
        });
    }

    private void doDAdjAndDeje() {
        List<List<String>> dadjAndDejeProcesses = this.getUnitDADJAndDEJEProcesses();
        dadjAndDejeProcesses.forEach(p -> {
            InvChangeHandleServiceHelper.handleAfterMerge(this._ctx, p);
            if (!this._ctx.isSkipCommPaperElim()) {
                this.doGenCommonPaperTmp(1, (List<String>)p);
            }
            if (!this._ctx.isFromRpt() && !this._ctx.isMergeSum()) {
                this.executeBizRule((List<String>)p, this.orgNode.getEC());
            }
        });
    }

    private void doCalcEJE() {
        PairList aggList = new PairList();
        aggList.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"EJE");
        this.executeAggRule((PairList<String, String>)aggList, ss -> {
            ss.addDimensionScope(PresetConstant.CURRENCY_DIM, this.orgNode.getEC());
            ss.addDimensionScope(PresetConstant.ENTITY_DIM, this.orgNode.getChildrenRelaWithParent());
        });
    }

    private void doChecking() {
        try {
            CheckResult checkResult = CheckServiceHelper.check(SimpleItem.toPair(this._ctx.getModel()), SimpleItem.toPair(this._ctx.getScenario()), SimpleItem.toPair(this._ctx.getFy()), SimpleItem.toPair(this._ctx.getPeriod()), (Pair<Long, String>)Pair.onePair((Object)this.orgNode.getId(), (Object)this.orgNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)0L, (Object)this.orgNode.getEC()));
            if (!checkResult.getSuccess()) {
                this.collectLog((Throwable)new BcmTransferException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5bf9\u8d26\u53d1\u751f\u5f02\u5e38\uff1a%2$s\u3002", (String)"UnitOrgCslExecuteService_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), checkResult.getMessage())));
            }
        }
        catch (Exception e) {
            String errmsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5bf9\u8d26\u53d1\u751f\u5f02\u5e38:", (String)"UnitOrgCslExecuteService_11", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(errmsg, (Throwable)e);
            if (e instanceof KDBizException) {
                String code = ((KDBizException)((Object)e)).getErrorCode().getCode();
                if (!"inner_chk_100".equals(code)) {
                    this.collectLog((Throwable)new BcmTransferException(errmsg, (Throwable)e));
                }
            }
            this.collectLog((Throwable)new BcmTransferException(errmsg, (Throwable)e));
        }
    }

    private void doCslRpt() {
        this.executeTheRunScript(this.buildCslScript());
    }

    private void buildEqualsNullRunScript(RunScriptBuilder runs, String process) {
        runs.appendV((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)process).addPair((Object)PresetConstant.ENTITY_DIM, (Object)this.orgNode.getNumber()));
        runs.appendEqualSign();
        runs.appendStr("null");
        runs.endRunExpress();
    }

    private void doExecuteCsRptRule() {
        this.getBizRuleExecuteService().executeRule(Lists.newArrayList((Object[])new String[]{"EIRpt", "ERAdj"}), this.orgNode.getEC());
        this.saveOrgCacheByCalc();
    }

    private String buildCslScript() {
        StringBuilder script = new StringBuilder();
        PairList dimpairList = PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"IRpt");
        if (MemberReader.isExistAuditTrailDimension((String)this._ctx.getModel().number)) {
            dimpairList.addPair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)"EntityInput");
        }
        PairList<String, String> left = this.buildLeft((PairList<String, String>)dimpairList, this.orgNode.getNumber());
        ArrayList<PairList<String, String>> rightList = new ArrayList<PairList<String, String>>(10);
        MergeDataSourceEnum mergeType = this.orgNode.getMergeType();
        Pair atPair = Pair.onePair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)"ATTotal");
        switch (mergeType) {
            case SIRpt: {
                PairList tempPair1 = new PairList();
                PairList tempPair2 = new PairList();
                PairList tempPair3 = new PairList();
                tempPair1.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"SRPT");
                tempPair2.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"ADJT");
                tempPair3.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"EJET");
                if (MemberReader.isExistAuditTrailDimension((String)this._ctx.getModel().number)) {
                    tempPair1.add(atPair);
                    tempPair2.add(atPair);
                    tempPair3.add(atPair);
                }
                rightList.add(this.buildLeft((PairList<String, String>)tempPair1, this.orgNode.getNumber()));
                rightList.add(this.buildLeft((PairList<String, String>)tempPair2, this.orgNode.getNumber()));
                rightList.add(this.buildLeft((PairList<String, String>)tempPair3, this.orgNode.getNumber()));
                break;
            }
            case CSTE: {
                PairList tempPair4 = new PairList();
                tempPair4.addPair((Object)PresetConstant.PROCESS_DIM, (Object)"CSTE");
                if (MemberReader.isExistAuditTrailDimension((String)this._ctx.getModel().number)) {
                    tempPair4.add(atPair);
                }
                rightList.add(this.buildLeft((PairList<String, String>)tempPair4, this.orgNode.getNumber()));
                break;
            }
            default: {
                throw new KDBizException("Invalidata MergeType:" + mergeType);
            }
        }
        script.append(this.wrapRunFunction(this.buildEquation(left, rightList))).append(';');
        return script.toString();
    }

    private void executeSumCommand() {
        MultiDimAggCommandBuilder builder = new MultiDimAggCommandBuilder(this._ctx.getModel().number, OlapSourceEnum.C1);
        builder.builtAggAxis().setMainDimensionName(PresetConstant.ENTITY_DIM).setLeftAggExpressionItem(this.orgNode.getNumber()).setRightAggExpressionItemsByDefaultAddOprt(this.orgNode.getNoSkipAggOprtChildrenNums()).endBuilt();
        builder.builtAggAxis().setMainDimensionName(PresetConstant.PROCESS_DIM).setLeftAggExpressionItem("SRPT").setRightAggExpressionItemsByDefaultAddOprt("Rpt").endBuilt();
        builder.builtFilter().setDimensionFilter(new ArrayList<DimensionFilterItem>(this.getFullScopeInfo().getFilters())).endBuilt();
        builder.postCommand();
    }

    private String buildAdjustScript() {
        StringBuilder script = new StringBuilder();
        PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SADJ"), this.orgNode.getNumber());
        List<PairList<String, String>> right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ADJ"), this.orgNode.getNoSkipAggOprtChildrenRelaWithParent());
        script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
        return script.toString();
    }

    private String buildSCADJScript() {
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"SCADJ") == IDNumberTreeNode.NotFoundTreeNode) {
            return "";
        }
        StringBuilder script = new StringBuilder();
        PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SCADJ"), this.orgNode.getNumber());
        List<PairList<String, String>> right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"CADJ"), this.orgNode.getNoSkipAggOprtChildrenRelaWithParent());
        script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
        return script.toString();
    }

    private String buildSCCADJScript() {
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.PROCESS_DIM, (String)"SCCADJ") == IDNumberTreeNode.NotFoundTreeNode) {
            return "";
        }
        StringBuilder script = new StringBuilder();
        PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SCCADJ"), this.orgNode.getNumber());
        List<PairList<String, String>> right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"CCADJ"), this.orgNode.getNoSkipAggOprtChildrenRelaWithParent());
        script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
        return script.toString();
    }

    private String buildEliminationScript() {
        String[] orgRelaWithParent = this.orgNode.getNoSkipAggOprtChildrenRelaWithParent();
        StringBuilder script = new StringBuilder();
        if (DimensionServiceHelper.isCM02Model((Long)this._ctx.getModel().getId())) {
            PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SEJE"), this.orgNode.getNumber());
            List<PairList<String, String>> right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EJE"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
        } else {
            PairList<String, String> left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SECF"), this.orgNode.getNumber());
            List<PairList<String, String>> right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ECF"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
            left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SEIC"), this.orgNode.getNumber());
            right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EICA"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
            left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SEIT"), this.orgNode.getNumber());
            right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EIT"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
            left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SEOE"), this.orgNode.getNumber());
            right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EOE"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
            left = this.buildLeft((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"SEOther"), this.orgNode.getNumber());
            right = this.buildRight((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"EOther"), orgRelaWithParent);
            script.append(this.wrapRunFunction(this.buildEquation(left, right))).append(';');
        }
        return script.toString();
    }

    protected void dealTextData() {
        UnitOrgTextDataServiceHelper.resetTextDataByNumber((Long)this._ctx.getModel().getId(), this.orgNode.getNumber(), this._ctx.getScenario().getNumber(), this._ctx.getFy().getNumber(), this._ctx.getPeriod().getNumber(), this.orgNode.getEC());
    }

    private void dealCwpText() {
        if (MemberReader.findMemberByNumber((String)this._ctx.getModel().number, (String)PresetConstant.AUDITTRIAL_DIM, (String)"CWP") == IDNumberTreeNode.NotFoundTreeNode) {
            return;
        }
        SQLBuilder sql = new SQLBuilder(this._ctx.getModel().number);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.addFilter(PresetConstant.SCENE_DIM, this._ctx.getScenario().number);
        sql.addFilter(PresetConstant.FY_DIM, this._ctx.getFy().number);
        sql.addFilter(PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number);
        sql.addFilter(PresetConstant.ENTITY_DIM, this._ctx.getOrg().number);
        sql.addFilter(PresetConstant.PROCESS_DIM, "IRpt");
        sql.addFilter(PresetConstant.AUDITTRIAL_DIM, "CWP");
        ArrayList<String> dimNumList = new ArrayList<String>(QueryDimensionServiceHelper.getDimensionNums((Long)this._ctx.getModel().getId()));
        sql.addSelectField(dimNumList.toArray(new String[0]));
        MDResultSet set = OlapServiceHelper.queryData(sql);
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        info.addfixedDimension(new String[]{PresetConstant.SCENE_DIM, this._ctx.getScenario().number});
        info.addfixedDimension(new String[]{PresetConstant.FY_DIM, this._ctx.getFy().number});
        info.addfixedDimension(new String[]{PresetConstant.PERIOD_DIM, this._ctx.getPeriod().number});
        info.addfixedDimension(new String[]{PresetConstant.ENTITY_DIM, this._ctx.getOrg().number});
        info.addfixedDimension(new String[]{PresetConstant.PROCESS_DIM, "IRpt"});
        info.addfixedDimension(new String[]{PresetConstant.AUDITTRIAL_DIM, "ATTotal"});
        List<String> fixDim = Arrays.asList(PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.ENTITY_DIM, PresetConstant.PROCESS_DIM, PresetConstant.AUDITTRIAL_DIM);
        dimNumList.removeAll(fixDim);
        info.addDimensions(dimNumList.toArray(new String[0]));
        CellSet cellSets = new CellSet(dimNumList.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        while (set.next()) {
            Row row = set.getRow();
            Object value = row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (value instanceof Number) continue;
            if (value != null && value.toString().endsWith(ResManager.loadKDString((String)"\u5df2\u5220\u9664", (String)"UnitOrgCslExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]))) {
                cellSets.set(this.buildKey(row, dimNumList), FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                continue;
            }
            cellSets.set(this.buildKey(row, dimNumList), FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
        }
        OlapCommandUtil.addSourceMeasure((String)this._ctx.getModel().number, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.C1);
        OlapServiceHelper.saveData(info, cellSets, this._ctx.getModel().number, true, true);
    }

    private String[] buildKey(Row row, List<String> dim) {
        String[] key = new String[dim.size()];
        for (int i = 0; i < dim.size(); ++i) {
            key[i] = row.getString(dim.get(i));
        }
        return key;
    }

    private void doGenInvSheet(List<String> process) {
        try {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)this._ctx.getModel().number, (Long)this.orgNode.getId());
            long unitId = org.getId();
            if (this.orgNode.isLeaf()) {
                IDNumberTreeNode parent = org.getParent();
                unitId = parent.getId();
            }
            InvElimPaperGenerateService paperGenService = new InvElimPaperGenerateService((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), (Long)unitId, InvLimSheetLogConstant.Operation.GENERATE_MERGE);
            paperGenService.setElimTemplateType(1);
            paperGenService.setSpecifiedProcess(process);
            paperGenService.generatePaper();
            this.unitOrgLog.error(String.format(ResManager.loadKDString((String)"\u751f\u6210\u6743\u76ca\u62b5\u9500\u5e95\u7a3f : %s", (String)"UnitOrgCslExecuteService_47", (String)"fi-bcm-business", (Object[])new Object[0]), paperGenService.getErrMsg()));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u751f\u6210\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_15", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(msg, (Throwable)e);
            this.collectLog((Throwable)new BcmTransferException(msg, (Throwable)e));
        }
    }

    private void doGenInvSheetElim(List<String> process) {
        try {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)this._ctx.getModel().getNumber(), (Long)this.orgNode.getId());
            long unitId = org.getId();
            if (this.orgNode.isLeaf()) {
                IDNumberTreeNode parent = org.getParent();
                unitId = parent.getId();
            }
            InvElimSpreadGenerateService elimGenService = new InvElimSpreadGenerateService((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), unitId);
            elimGenService.setSpecifiedProcess(process);
            Tuple<Integer, Set<Long>, String> result = elimGenService.generate();
            this.unitOrgLog.error(String.format(ResManager.loadKDString((String)"\u751f\u6210\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u5206\u5f55 : %s", (String)"UnitOrgCslExecuteService_48", (String)"fi-bcm-business", (Object[])new Object[0]), result.p3));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u751f\u6210\u6743\u76ca\u62b5\u9500\u5e95\u7a3f\u5206\u5f55\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_16", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(msg, (Throwable)e);
            this.collectLog((Throwable)new BcmTransferException(msg, (Throwable)e));
        }
    }

    private void doGenInvElim(int genType, List<String> processes) {
        try {
            long unitId = this.orgNode.getId();
            IDNumberTreeNode unitNode = MemberReader.findEntityMemberById((String)this._ctx.getModel().getNumber(), (Long)unitId);
            if (this.orgNode.isLeaf()) {
                IDNumberTreeNode parent = unitNode.getParent();
                unitId = parent.getId();
            }
            long schemeId = (Long)unitNode.getProperty("cslscheme.id");
            InvElimGenerateService service = new InvElimGenerateService((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), unitId, schemeId, true);
            service.setElimTemplateType(genType);
            service.setSpecifiedProcess(processes);
            if (this.orgNode.isLeaf()) {
                service.setDetailEntity((Pair<Long, String>)Pair.onePair((Object)this.orgNode.getId(), (Object)this.orgNode.getNumber()));
                service.setDetailEntityCurrency((Pair<Long, String>)Pair.onePair((Object)MemberReader.findCurrencyMemberByNum((String)this._ctx.getModel().getNumber(), (String)this.orgNode.getEC()).getId(), (Object)this.orgNode.getEC()));
            }
            Pair<Integer, String> resultPair = service.generate();
            this.unitOrgLog.error(String.format(ResManager.loadKDString((String)"\u751f\u6210\u6743\u76ca\u62b5\u9500\u5206\u5f55 : %s", (String)"UnitOrgCslExecuteService_49", (String)"fi-bcm-business", (Object[])new Object[0]), resultPair.p2));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u751f\u6210\u6743\u76ca\u62b5\u9500\u5206\u5f55\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_13", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(msg, (Throwable)e);
            this.collectLog((Throwable)new BcmTransferException(msg, (Throwable)e));
        }
    }

    private void doGenCommonPaperTmp(int genType, List<String> processes) {
        try {
            AdjustOperationContext actx = new AdjustOperationContext((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
            AdjustBatchCreateCommonEntryOperation commonEntryOperation = new AdjustBatchCreateCommonEntryOperation(actx, this.orgNode.getId());
            commonEntryOperation.setElimTemplateType(genType);
            if (genType == 1) {
                commonEntryOperation.setSpecifiedProcess(processes);
            }
            commonEntryOperation.generate();
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u751f\u6210\u666e\u901a\u62b5\u9500\u5e95\u7a3f\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_14", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(msg, (Throwable)e);
            this.collectLog((Throwable)new BcmTransferException(msg, (Throwable)e));
        }
    }

    private void doGenIntrElim() {
        try {
            SimpleItem entity = SimpleItem.newOne(this.orgNode.getId(), this.orgNode.getNumber());
            IntrMergeHelper.generate4SmartMerge(UserServiceHelper.getCurrentUserId(), this._ctx.getModel(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod(), entity);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u751f\u6210\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_20", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber());
            this.unitOrgLog.error(errorMsg, (Throwable)e);
            this.collectLog((Throwable)new BcmTransferException(errorMsg, (Throwable)e));
        }
    }

    private void doGenInnerTransaction(List<String> processes) {
        if (processes.contains("ADJ") || processes.contains("CADJ") || processes.contains("EJE") || processes.contains("CCADJ")) {
            String processNumber = processes.get(0);
            try {
                long modelId = (Long)this._ctx.getModel().getId();
                String modelNumber = this._ctx.getModel().getNumber();
                long scenarioId = (Long)this._ctx.getScenario().getId();
                long fyId = (Long)this._ctx.getFy().getId();
                long periodId = (Long)this._ctx.getPeriod().getId();
                long orgId = this.orgNode.getId();
                Long ecId = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)this.orgNode.getEC()).getId();
                Long processId = MemberReader.findProcessMemberByNum((String)modelNumber, (String)processNumber).getId();
                AdjustRecordHelper.generateAdj4SmartMerge(modelId, scenarioId, fyId, periodId, ecId, orgId, processId);
            }
            catch (Exception e) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u5728\u8fc7\u7a0b %2$s \u4e0a\u751f\u6210\u5185\u90e8\u4ea4\u6613\u5206\u5f55\u53d1\u751f\u5f02\u5e38\u3002", (String)"UnitOrgCslExecuteService_19", (String)"fi-bcm-business", (Object[])new Object[0]), this.orgNode.getNumber(), processNumber);
                this.unitOrgLog.error(errorMsg, (Throwable)e);
                this.collectLog((Throwable)new BcmTransferException(errorMsg, (Throwable)e));
            }
        }
    }
}

