/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.olap.OlapSaveBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class UnitOrgTextDataServiceHelper {
    private static final Log logger = LogFactory.getLog(UnitOrgTextDataServiceHelper.class);

    public static void resetTextDataById(Long modelId, Long orgId, Long sceneId, Long yearId, Long periodId, Long currencyId) {
        String cubeNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId);
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)cubeNumber, (Long)currencyId);
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode) {
            logger.error("resetTextData orgNode is null, modelId = {}, id = {}", (Object)modelId, (Object)orgId);
            return;
        }
        if (sceneNode == IDNumberTreeNode.NotFoundTreeNode) {
            logger.error("resetTextData sceneNode is null, modelId = {}, id = {}", (Object)modelId, (Object)sceneId);
            return;
        }
        if (yearNode == IDNumberTreeNode.NotFoundTreeNode) {
            logger.error("resetTextData yearNode is null, modelId = {}, id = {}", (Object)modelId, (Object)yearId);
            return;
        }
        if (periodNode == IDNumberTreeNode.NotFoundTreeNode) {
            logger.error("resetTextData periodNode is null, modelId = {}, id = {}", (Object)modelId, (Object)periodId);
            return;
        }
        if (currencyNode == IDNumberTreeNode.NotFoundTreeNode) {
            logger.error("resetTextData currencyNode is null, modelId = {}, id = {}", (Object)modelId, (Object)currencyId);
            return;
        }
        UnitOrgTextDataServiceHelper.resetTextDataByNumber(modelId, orgNode.getNumber(), sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), currencyNode.getNumber());
    }

    public static void resetTextDataByNumber(Long modelId, String orgNumber, String sceneNumber, String yearNumber, String periodNumber, String currencyNumber) {
        String cubeNumber = MemberReader.findModelNumberById((Object)modelId);
        QFilter filter = new QFilter("cube", "=", (Object)cubeNumber);
        filter.and("org", "=", (Object)orgNumber);
        filter.and("scene", "=", (Object)sceneNumber);
        filter.and("year", "=", (Object)yearNumber);
        filter.and("period", "=", (Object)periodNumber);
        filter.and("currency", "=", (Object)currencyNumber);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_datacoverrecord", (String)"id,json,data", (QFilter[])filter.toArray());
        if (!doc.isEmpty()) {
            OlapSaveBuilder saveBuilder = new OlapSaveBuilder(cubeNumber);
            saveBuilder.setSourceEnum(OlapSourceEnum.C1);
            saveBuilder.setNeedMonitorDataStatus(false);
            saveBuilder.setMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
            saveBuilder.addFixedDimension("Entity", orgNumber);
            saveBuilder.addFixedDimension("Scenario", sceneNumber);
            saveBuilder.addFixedDimension("Year", yearNumber);
            saveBuilder.addFixedDimension("Period", periodNumber);
            saveBuilder.addFixedDimension("Currency", currencyNumber);
            List<String> seq_dims = DimensionServiceHelper.getAllDim(modelId);
            seq_dims.remove("Entity");
            seq_dims.remove("Scenario");
            seq_dims.remove("Year");
            seq_dims.remove("Period");
            seq_dims.remove("Currency");
            saveBuilder.setCrossDimensions(seq_dims.toArray(new String[0]));
            ArrayList<Pair<String[], Object>> cellSet = new ArrayList<Pair<String[], Object>>(16);
            for (DynamicObject textData : doc) {
                String json = textData.getString("json");
                String textValue = textData.getString("data");
                if (StringUtils.isBlank((CharSequence)json)) continue;
                JSONObject jsonObject = JSONObjectUtil.parseObjectOrder((String)json);
                ArrayList<String> crossDimValue = new ArrayList<String>(seq_dims.size());
                for (String seqDim : seq_dims) {
                    String dimValue = jsonObject.getString(seqDim);
                    if (StringUtils.isBlank((CharSequence)json)) {
                        String defaultNoneMember = UnitOrgTextDataServiceHelper.getDimensionDefaultNoneMember(cubeNumber, seqDim);
                        if (StringUtils.isBlank((CharSequence)defaultNoneMember)) {
                            logger.error("dim\uff1a{} is not exist short number", (Object)seqDim);
                            break;
                        }
                        crossDimValue.add(defaultNoneMember);
                        continue;
                    }
                    crossDimValue.add(dimValue);
                }
                if (seq_dims.size() != crossDimValue.size()) continue;
                cellSet.add((Pair<String[], Object>)Pair.onePair((Object)crossDimValue.toArray(new String[0]), (Object)textValue));
            }
            if (!cellSet.isEmpty()) {
                saveBuilder.setCellSet(cellSet);
                saveBuilder.doSave();
            }
        }
    }

    private static String getDimensionDefaultNoneMember(String cubeNumber, String dimNumber) {
        String memberNumber = "";
        Map shortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)cubeNumber);
        for (Map.Entry entry : shortNumber2NumberMap.entrySet()) {
            if (!dimNumber.equals(entry.getValue())) continue;
            return (String)entry.getKey() + "None";
        }
        return memberNumber;
    }
}

