/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.mc;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.service.AbstractExecuteService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public abstract class AbstractMcExecuteService
extends AbstractExecuteService {
    @Override
    public void executeService(ExecuteContext ctx) {
        this._ctx = ctx;
        if (MergeControlHelper.isQuoteLocked((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), (Long)this._ctx.getOrg().getId())) {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)this._ctx.getModel().getNumber(), (Long)((Long)this._ctx.getScenario().getId()));
            Long quoteSceneId = (Long)sceneNode.getProperty("scenequote.id");
            if (quoteSceneId != null && quoteSceneId > 0L) {
                IDNumberTreeNode quoteSceneNode = MemberReader.findScenaMemberById((String)this._ctx.getModel().getNumber(), (Long)quoteSceneId);
                if (quoteSceneNode != IDNumberTreeNode.NotFoundTreeNode) {
                    ctx.setScenario(SimpleItem.newOne(quoteSceneNode.getId(), quoteSceneNode.getNumber()));
                }
            } else {
                return;
            }
        }
        super.executeService(ctx);
    }

    @Override
    protected void afterExecuteService() {
        Long modelId = (Long)this._ctx.getModel().getId();
        String orgNumber = this._ctx.getOrg().getNumber();
        IDNumberTreeNode org = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)this._ctx.getOrg().getId()));
        String orgName = org.getName();
        String opDescription = this.logCollector.length() > 0 ? String.format(ResManager.loadKDString((String)"%1$s %2$s \u64cd\u4f5c\u5931\u8d25:%3$s", (String)"AbstractMcExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumber, orgName, this.logCollector.toString()) : String.format(ResManager.loadKDString((String)"%1$s %2$s \u64cd\u4f5c\u6210\u529f", (String)"AbstractMcExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumber, orgName);
        OperationLogUtil.writeOperationLog(this.operateType(), opDescription, modelId, "bcm_mergecontrollist");
    }

    protected abstract String operateType();

    protected void updateParentStatus(String currencyNumber) {
        MergeStatusService.getInstance().updateParentMergeStatusByCurrencyNum((Long)this._ctx.getModel().getId(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId(), this._ctx.getOrg().getNumber(), currencyNumber);
    }
}

