/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.mc;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.service.mc.AbstractMcExecuteService;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;

public class McCalculateExecuteService
extends AbstractMcExecuteService {
    @Override
    protected void beforeExecuteService() {
        if (!this._ctx.isCslInOne()) {
            this.updateEcStatus("Z", true);
        }
    }

    @Override
    protected void doExecuteService() {
        try {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)this._ctx.getModel().getNumber(), (Long)((Long)this._ctx.getOrg().getId()));
            this.executeBizRule(Lists.newArrayList((Object[])new String[]{"EIRpt", "ERAdj"}), org.getCurrency());
            if (!this._ctx.isCslInOne()) {
                Long ecId = MemberReader.findCurrencyMemberByNum((String)this._ctx.getModel().getNumber(), (String)org.getCurrency()).getId();
                Pair<Long, String> model = SimpleItem.toPair(this._ctx.getModel());
                Pair<Long, String> scenario = SimpleItem.toPair(this._ctx.getScenario());
                Pair<Long, String> fy = SimpleItem.toPair(this._ctx.getFy());
                Pair<Long, String> period = SimpleItem.toPair(this._ctx.getPeriod());
                Pair<Long, String> entity = SimpleItem.toPair(this._ctx.getOrg());
                Pair currency = Pair.onePair((Object)ecId, (Object)org.getCurrency());
                ConvertServiceHelper.generateDataOfCurrPeriodOrYDT(model, entity, fy, period, scenario, (Pair<Long, String>)currency, false);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.collectLog(e);
        }
    }

    @Override
    protected void afterExecuteService() {
        if (!this._ctx.isCslInOne() && !this.willSkipExecuteService()) {
            super.afterExecuteService();
            boolean isSuccess = true;
            if (this.logCollector.length() == 0) {
                this.updateEcStatus("C", false);
            } else {
                isSuccess = false;
                this.updateEcStatus("E", false);
            }
            this.updateAllConvertStatus();
            this.updateParentStatus(this.orgNode.getEC());
            if (isSuccess) {
                FixedItem fixedItem = FixedItem.newOne(this._ctx.getModel(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod());
                DynamicObject obj = MergeControlService.getInstance().saveProgressInfo(fixedItem, (Long)this._ctx.getOrg().getId(), MergeTaskTypeEnum.CheckUp.getCode(), false);
                MergeControlService.getInstance().checkUpChk(fixedItem, this._ctx.getOrg(), obj.getLong("id"), false, "1");
            }
        }
    }

    @Override
    protected String operateType() {
        return OpItemEnum.EXEC_CALCULATE.getName();
    }

    @Override
    protected boolean willSkipExecuteService() {
        return this.status.getFlow().isSubmit() || this._ctx.isSkipEcRule() && this.status.getCalculate().isSuccess() || !OlapDataVerifyServiceHelper.checkPeriodOpenStatus((Long)this._ctx.getModel().getId(), this._ctx.getModel().getNumber(), this._ctx.getOrg().getNumber(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
    }

    private void updateEcStatus(String status, boolean isBegin) {
        MergeData mergeData = this.loadMergeData();
        DynamicObject ecData = mergeData.getEcData();
        if (ecData != null && !mergeData.getMergeStatus().getFlow().isSubmit()) {
            ecData.set("calculatestatus", (Object)status);
            ecData.set("chkstatus", (Object)"B");
            if (isBegin) {
                ecData.set("begintime", (Object)TimeServiceHelper.now());
                ecData.set("endtime", null);
            } else {
                ecData.set("endtime", (Object)TimeServiceHelper.now());
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ecData});
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.logger.error("calculate update mergestatus error: ", (Throwable)e);
                }
            }
        }
    }

    private void updateAllConvertStatus() {
        MergeData mergeData = this.loadMergeData();
        List<DynamicObject> allConvertList = mergeData.getAllConvertData();
        for (DynamicObject convertData : allConvertList) {
            convertData.set("calculatestatus", (Object)"B");
            convertData.set("chkstatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])allConvertList.toArray(new DynamicObject[0]));
    }
}

