/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.mc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.service.mc.AbstractMcExecuteService;
import kd.fi.bcm.business.allinone.service.mc.McCalculateExecuteService;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.MergeTaskTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.util.BcmTransferException;

public class McConvertExecuteService
extends AbstractMcExecuteService {
    private String cvtCurrencyNumber = null;

    @Override
    protected void beforeExecuteService() {
        if (!this._ctx.isCslInOne()) {
            if (this._ctx.getNowPaths() != null && this._ctx.getNowPaths().size() == 2 && !((String)this._ctx.getNowPaths().get((int)0).p2).equals(this._ctx.getNowPaths().get((int)1).p2)) {
                this.cvtCurrencyNumber = (String)this._ctx.getNowPaths().get((int)1).p2;
            }
            this.updatePcStatus("Z", true);
        }
    }

    @Override
    protected void doExecuteService() {
        if (!this.status.getCalculate().isSuccess()) {
            new McCalculateExecuteService().executeService(this._ctx);
        }
        if (this._ctx.getNowPaths() == null) {
            BaseData baseData = new BaseData((Long)this._ctx.getModel().getId(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod());
            PairList<Long, String> cvtPaths = ConvertServiceHelper.getOrgConvertPath(baseData, SimpleVo.newOne(this._ctx.getOrg()));
            this._ctx.setNowPaths(cvtPaths.toList());
        }
        try {
            if (this._ctx.getNowPaths() == null || this._ctx.getNowPaths().size() == 0) {
                if (!Objects.equals(this.orgNode.getEC(), this.orgNode.getPC()) && this.orgNode.getPC() != null) {
                    this.cvtCurrencyNumber = this.orgNode.getPC();
                    this.getBizRuleExecuteService().executeRule(Arrays.asList("IRpt", "RAdj"), this.cvtCurrencyNumber);
                }
            } else {
                Set<String> msg;
                Pair<Long, String> model = SimpleItem.toPair(this._ctx.getModel());
                Pair<Long, String> scenario = SimpleItem.toPair(this._ctx.getScenario());
                Pair<Long, String> fy = SimpleItem.toPair(this._ctx.getFy());
                Pair<Long, String> period = SimpleItem.toPair(this._ctx.getPeriod());
                Pair<Long, String> entity = SimpleItem.toPair(this._ctx.getOrg());
                if (this._ctx.getNowPaths().size() == 2 && !((String)this._ctx.getNowPaths().get((int)0).p2).equals(this._ctx.getNowPaths().get((int)1).p2)) {
                    this.cvtCurrencyNumber = (String)this._ctx.getNowPaths().get((int)1).p2;
                }
                if (!(msg = ConvertServiceHelper.convertByPath(this._ctx.getNowPaths(), model, entity, fy, period, scenario, false, !this._ctx.isSkipPcRule())).isEmpty()) {
                    StringBuilder errorTip = new StringBuilder();
                    msg.forEach(m -> errorTip.append((String)m).append('\n'));
                    this.collectLog((Throwable)new BcmTransferException(errorTip.toString()));
                    this._ctx.appendErrorMsg(msg);
                }
            }
        }
        catch (Exception e) {
            HashSet<String> errorMsg = new HashSet<String>(2);
            errorMsg.add(e.getMessage());
            this._ctx.appendErrorMsg(errorMsg);
            this.collectLog(e);
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void afterExecuteService() {
        if (!this._ctx.isCslInOne() && !this.willSkipExecuteService()) {
            super.afterExecuteService();
            boolean isSuccess = true;
            if (this.logCollector.length() == 0) {
                this.updatePcStatus("C", false);
            } else {
                isSuccess = false;
                this.updatePcStatus("E", false);
            }
            if (null != this.cvtCurrencyNumber) {
                this.updateParentStatus(this.cvtCurrencyNumber);
            }
            if (isSuccess) {
                FixedItem fixedItem = FixedItem.newOne(this._ctx.getModel(), this._ctx.getScenario(), this._ctx.getFy(), this._ctx.getPeriod());
                DynamicObject obj = MergeControlService.getInstance().saveProgressInfo(fixedItem, (Long)this._ctx.getOrg().getId(), MergeTaskTypeEnum.CheckUp.getCode(), false);
                MergeControlService.getInstance().checkUpChk(fixedItem, this._ctx.getOrg(), obj.getLong("id"), false, "2");
            }
        }
    }

    @Override
    protected String operateType() {
        return OpItemEnum.EXEC_CONVERT.getName();
    }

    @Override
    protected boolean willSkipExecuteService() {
        return this.status.getPcFlow().isSubmit() || this._ctx.isSkipPcRule() && this.status.getConvert().isSuccess() || !OlapDataVerifyServiceHelper.checkPeriodOpenStatus((Long)this._ctx.getModel().getId(), this._ctx.getModel().getNumber(), this._ctx.getOrg().getNumber(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
    }

    @Override
    public McStatus getStatus() {
        Long modelId = (Long)this._ctx.getModel().getId();
        Long scenarioId = (Long)this._ctx.getScenario().getId();
        Long fyId = (Long)this._ctx.getFy().getId();
        Long periodId = (Long)this._ctx.getPeriod().getId();
        Long orgId = (Long)this._ctx.getOrg().getId();
        if (this._ctx.getNowPaths() != null && this._ctx.getNowPaths().size() == 2 && !((String)this._ctx.getNowPaths().get((int)0).p2).equals(this._ctx.getNowPaths().get((int)1).p2)) {
            this.cvtCurrencyNumber = (String)this._ctx.getNowPaths().get((int)1).p2;
        }
        return MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, fyId, periodId, orgId, this.cvtCurrencyNumber).getMergeStatus();
    }

    private void updatePcStatus(String status, boolean isBegin) {
        if (this.cvtCurrencyNumber == null) {
            return;
        }
        Long modelId = (Long)this._ctx.getModel().getId();
        Long scenarioId = (Long)this._ctx.getScenario().getId();
        Long fyId = (Long)this._ctx.getFy().getId();
        Long periodId = (Long)this._ctx.getPeriod().getId();
        Long orgId = (Long)this._ctx.getOrg().getId();
        MergeData mergeData = MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, fyId, periodId, orgId, this.cvtCurrencyNumber);
        DynamicObject pcData = mergeData.getPcData();
        if (pcData != null && !mergeData.getMergeStatus().getPcFlow().isSubmit()) {
            pcData.set("calculatestatus", (Object)status);
            pcData.set("chkstatus", (Object)"B");
            if (isBegin) {
                pcData.set("begintime", (Object)TimeServiceHelper.now());
                pcData.set("endtime", null);
            } else {
                pcData.set("endtime", (Object)TimeServiceHelper.now());
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pcData});
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.logger.error("calculate update mergestatus error: ", (Throwable)e);
                }
            }
        }
    }
}

