/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.report;

import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.csl.UnitOrgCslExecuteService;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;

public class ReportMergeExecuteService
extends UnitOrgCslExecuteService {
    public ReportMergeExecuteService(OrgNode orgNode) {
        super(orgNode);
    }

    @Override
    public void executeService(ExecuteContext ctx) {
        this.logger.startWatch();
        this._ctx = ctx;
        this.initEnv();
        try {
            if (!this.willSkipExecuteService()) {
                this.beforeExecuteService();
                this.doExecuteService();
            }
        }
        catch (Exception e) {
            this.logger.error("ReportMergeByTemplate Error:", (Throwable)e);
        }
        finally {
            this.afterExecuteService();
        }
        this.logger.infoEnd(String.format("\u7ec4\u7ec7[%s]\u6a21\u677f[%s]\u6267\u884c\u5408\u5e76\u6c47\u603b\u8017\u65f6", this._ctx.getOrg().number, this._ctx.getTemplateNumber()));
    }

    @Override
    protected void doExecuteService() {
        this.doSum();
        this.doJournalContribution();
        this.doCsl();
        this.dealTextData();
    }

    @Override
    protected boolean willSkipExecuteService() {
        return this.status.getFlow().isSubmit() || !OlapDataVerifyServiceHelper.checkPeriodOpenStatus((Long)this._ctx.getModel().getId(), this._ctx.getModel().getNumber(), this._ctx.getOrg().getNumber(), (Long)this._ctx.getScenario().getId(), (Long)this._ctx.getFy().getId(), (Long)this._ctx.getPeriod().getId());
    }

    @Override
    protected void beforeExecuteService() {
    }

    @Override
    protected void afterExecuteService() {
    }
}

