/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.thread;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;

public class BCMFuture<T>
implements Future<T>,
CompletionStage<T> {
    private static final Executor asyncPool = command -> ThreadPoolService.runCompletableFutureThread(command::run);
    private final CompletableFuture<T> completableFuture;

    private BCMFuture(CompletableFuture<T> future) {
        this.completableFuture = future;
    }

    public static <U> BCMFuture<U> supplyAsync(Supplier<U> supplier) {
        return new BCMFuture<U>(CompletableFuture.supplyAsync(supplier, asyncPool));
    }

    public static <U> BCMFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return new BCMFuture<U>(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static BCMFuture<Void> runAsync(Runnable runnable) {
        return new BCMFuture<Void>(CompletableFuture.runAsync(runnable, asyncPool));
    }

    public static BCMFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return new BCMFuture<Void>(CompletableFuture.runAsync(runnable, executor));
    }

    public static <U> BCMFuture<U> completedFuture(U value) {
        return new BCMFuture<U>(CompletableFuture.completedFuture(value));
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.completableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.completableFuture.get(timeout, unit);
    }

    public T join() {
        return this.completableFuture.join();
    }

    public T getNow(T valueIfAbsent) {
        return this.completableFuture.getNow(valueIfAbsent);
    }

    public boolean complete(T value) {
        return this.completableFuture.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.completableFuture.completeExceptionally(ex);
    }

    @Override
    public <U> BCMFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return new BCMFuture<T>(this.completableFuture.thenApply(fn));
    }

    @Override
    public <U> BCMFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return new BCMFuture<T>(this.completableFuture.thenApplyAsync(fn, asyncPool));
    }

    @Override
    public <U> BCMFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.thenApplyAsync(fn, executor));
    }

    public BCMFuture<Void> thenAccept(Consumer<? super T> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAccept((Consumer)action));
    }

    public BCMFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptAsync((Consumer)action, asyncPool));
    }

    public BCMFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptAsync((Consumer)action, executor));
    }

    public BCMFuture<Void> thenRun(Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRun(action));
    }

    public BCMFuture<Void> thenRunAsync(Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRunAsync(action, asyncPool));
    }

    public BCMFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> BCMFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new BCMFuture<T>(this.completableFuture.thenCombine(other, fn));
    }

    @Override
    public <U, V> BCMFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new BCMFuture<T>(this.completableFuture.thenCombineAsync(other, fn, asyncPool));
    }

    @Override
    public <U, V> BCMFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.thenCombineAsync(other, fn, executor));
    }

    public <U> BCMFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> BCMFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBothAsync(other, (BiConsumer)action, asyncPool));
    }

    public <U> BCMFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    public BCMFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBoth((CompletionStage)other, action));
    }

    public BCMFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBothAsync((CompletionStage)other, action, asyncPool));
    }

    public BCMFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> BCMFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new BCMFuture<T>(this.completableFuture.applyToEither((CompletionStage)other, fn));
    }

    @Override
    public <U> BCMFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new BCMFuture<T>(this.completableFuture.applyToEitherAsync((CompletionStage)other, fn, asyncPool));
    }

    @Override
    public <U> BCMFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    public BCMFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public BCMFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEitherAsync((CompletionStage)other, (Consumer)action, asyncPool));
    }

    public BCMFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public BCMFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEither((CompletionStage)other, action));
    }

    public BCMFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEitherAsync((CompletionStage)other, action, asyncPool));
    }

    public BCMFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new BCMFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> BCMFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new BCMFuture<T>(this.completableFuture.thenCompose(fn));
    }

    @Override
    public <U> BCMFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new BCMFuture<T>(this.completableFuture.thenComposeAsync(fn, asyncPool));
    }

    @Override
    public <U> BCMFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.thenComposeAsync(fn, executor));
    }

    @Override
    public BCMFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return new BCMFuture<T>(this.completableFuture.whenComplete(action));
    }

    @Override
    public BCMFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return new BCMFuture<T>(this.completableFuture.whenCompleteAsync(action, asyncPool));
    }

    @Override
    public BCMFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.whenCompleteAsync(action, executor));
    }

    @Override
    public <U> BCMFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new BCMFuture<T>(this.completableFuture.handle(fn));
    }

    @Override
    public <U> BCMFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new BCMFuture<T>(this.completableFuture.handleAsync(fn, asyncPool));
    }

    @Override
    public <U> BCMFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return new BCMFuture<T>(this.completableFuture.handleAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.completableFuture;
    }

    @Override
    public BCMFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return new BCMFuture<T>(this.completableFuture.exceptionally(fn));
    }

    public static BCMFuture<Void> allOf(BCMFuture<?> ... cfs) {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(cfs).map(future -> future.completableFuture).distinct().toArray(CompletableFuture[]::new);
        return new BCMFuture<Void>(CompletableFuture.allOf(futures));
    }

    public static BCMFuture<Object> anyOf(BCMFuture<?> ... cfs) {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(cfs).map(future -> future.completableFuture).distinct().toArray(CompletableFuture[]::new);
        return new BCMFuture<Object>(CompletableFuture.anyOf(futures));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.completableFuture.isCancelled();
    }

    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    public void obtrudeValue(T value) {
        this.completableFuture.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        this.completableFuture.obtrudeException(ex);
    }

    public int getNumberOfDependents() {
        return this.completableFuture.getNumberOfDependents();
    }
}

