/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.thread;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.fi.bcm.business.allinone.service.thread.IHook;
import kd.fi.bcm.business.allinone.service.thread.ProcessStatusHeartBeatChecker;
import kd.fi.bcm.common.enums.ProgressStatusEnum;
import kd.fi.bcm.common.util.QFBuilder;

public final class JVMShutdownHook {
    private static volatile boolean hasAddMonitorAllInOneHook = false;
    private static Set<Long> monitorAllInOnePool = new HashSet<Long>();

    private static void addMonitorAllInOneHook() {
        if (hasAddMonitorAllInOneHook) {
            return;
        }
        hasAddMonitorAllInOneHook = true;
        JVMShutdownHook.addHook(() -> {
            if (!monitorAllInOnePool.isEmpty()) {
                DynamicObject[] updateObjs;
                new ManagedThreadFeature().start();
                for (DynamicObject updateObj : updateObjs = BusinessDataServiceHelper.load((String)"bcm_mergeprogressentity", (String)"id,failedlog,fstatus,endtime", (QFilter[])new QFBuilder().add("id", "in", monitorAllInOnePool).add("endtime", "is null", null).toArray())) {
                    updateObj.set("failedlog", (Object)ResManager.loadKDString((String)"\u56e0\u670d\u52a1\u610f\u5916\u9000\u51fa\uff0c\u5bfc\u81f4\u5408\u5e76\u7ec8\u6b62\uff0c\u8bf7\u5728\u670d\u52a1\u6b63\u5e38\u540e\u91cd\u8bd5\uff01", (String)"JVMShutdownHook_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    updateObj.set("fstatus", (Object)ProgressStatusEnum.FAIL.getCode());
                    updateObj.set("endtime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])updateObjs);
            }
        });
    }

    public static void monitorProgress(Long progressId) {
        monitorAllInOnePool.add(progressId);
        JVMShutdownHook.addMonitorAllInOneHook();
        ProcessStatusHeartBeatChecker.updateHeartBeat(progressId);
    }

    public static void removeMonitorProgress(Long progressId) {
        monitorAllInOnePool.remove(progressId);
        ProcessStatusHeartBeatChecker.removeHeartBeat(progressId);
    }

    public static void addHook(IHook hook) {
        RequestContext ctx = RequestContext.copy((RequestContext)RequestContext.get());
        ctx.setClient("bcm-Hook-thread");
        RequestContextRunnable runnable = new RequestContextRunnable(() -> hook.doHook(), ctx);
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)runnable));
    }
}

